/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.linux;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class XkbKeyNameRec
implements Pointer {
    public static final int SIZEOF;
    public static final int NAME;
    private final ByteBuffer struct;

    public XkbKeyNameRec() {
        this(XkbKeyNameRec.malloc());
    }

    public XkbKeyNameRec(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setName(ByteBuffer name) {
        XkbKeyNameRec.nameSet(this.struct, name);
    }

    public void setName(CharSequence name) {
        XkbKeyNameRec.name(this.struct, name);
    }

    public void getName(ByteBuffer name) {
        XkbKeyNameRec.nameGet(this.struct, name);
    }

    public String getNameString() {
        return XkbKeyNameRec.nameString(this.struct);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(ByteBuffer name) {
        ByteBuffer xkbkeynamerec = XkbKeyNameRec.malloc();
        XkbKeyNameRec.nameSet(xkbkeynamerec, name);
        return xkbkeynamerec;
    }

    public static ByteBuffer malloc(CharSequence name) {
        ByteBuffer xkbkeynamerec = XkbKeyNameRec.malloc();
        XkbKeyNameRec.name(xkbkeynamerec, name);
        return xkbkeynamerec;
    }

    public static void nameSet(ByteBuffer xkbkeynamerec, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT1(name);
            Checks.checkBufferGT(name, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(name), MemoryUtil.memAddress(xkbkeynamerec) + (long)NAME, name.remaining());
    }

    public static void name(ByteBuffer xkbkeynamerec, CharSequence name) {
        MemoryUtil.memEncodeASCII(name, false, xkbkeynamerec, NAME);
    }

    public static void nameGet(ByteBuffer xkbkeynamerec, ByteBuffer name) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(name, 4);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(xkbkeynamerec) + (long)NAME, MemoryUtil.memAddress(name), name.remaining());
    }

    public static String nameString(ByteBuffer xkbkeynamerec) {
        return MemoryUtil.memDecodeASCII(xkbkeynamerec, 4, NAME);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(1);
        SIZEOF = XkbKeyNameRec.offsets(MemoryUtil.memAddress(offsets));
        NAME = offsets.get(0);
    }
}

