/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system.windows;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Pointer;
import org.lwjgl.system.Checks;
import org.lwjgl.system.MemoryUtil;

public final class JOYCAPS
implements Pointer {
    public static final int SIZEOF;
    public static final int MID;
    public static final int PID;
    public static final int PNAME;
    public static final int XMIN;
    public static final int XMAX;
    public static final int YMIN;
    public static final int YMAX;
    public static final int ZMIN;
    public static final int ZMAX;
    public static final int NUMBUTTONS;
    public static final int PERIODMIN;
    public static final int PERIODMAX;
    public static final int RMIN;
    public static final int RMAX;
    public static final int UMIN;
    public static final int UMAX;
    public static final int VMIN;
    public static final int VMAX;
    public static final int CAPS;
    public static final int MAXAXES;
    public static final int NUMAXES;
    public static final int MAXBUTTONS;
    public static final int REGKEY;
    public static final int OEMVXD;
    private final ByteBuffer struct;

    public JOYCAPS() {
        this(JOYCAPS.malloc());
    }

    public JOYCAPS(ByteBuffer struct) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBuffer((Buffer)struct, SIZEOF);
        }
        this.struct = struct;
    }

    public ByteBuffer buffer() {
        return this.struct;
    }

    @Override
    public long getPointer() {
        return MemoryUtil.memAddress(this.struct);
    }

    public void setMid(int mid) {
        JOYCAPS.mid(this.struct, mid);
    }

    public void setPid(int pid) {
        JOYCAPS.pid(this.struct, pid);
    }

    public void setPname(ByteBuffer pname) {
        JOYCAPS.pnameSet(this.struct, pname);
    }

    public void setPname(CharSequence pname) {
        JOYCAPS.pname(this.struct, pname);
    }

    public void setXmin(int xmin) {
        JOYCAPS.xmin(this.struct, xmin);
    }

    public void setXmax(int xmax) {
        JOYCAPS.xmax(this.struct, xmax);
    }

    public void setYmin(int ymin) {
        JOYCAPS.ymin(this.struct, ymin);
    }

    public void setYmax(int ymax) {
        JOYCAPS.ymax(this.struct, ymax);
    }

    public void setZmin(int zmin) {
        JOYCAPS.zmin(this.struct, zmin);
    }

    public void setZmax(int zmax) {
        JOYCAPS.zmax(this.struct, zmax);
    }

    public void setNumButtons(int numButtons) {
        JOYCAPS.numButtons(this.struct, numButtons);
    }

    public void setPeriodMin(int periodMin) {
        JOYCAPS.periodMin(this.struct, periodMin);
    }

    public void setPeriodMax(int periodMax) {
        JOYCAPS.periodMax(this.struct, periodMax);
    }

    public void setRmin(int rmin) {
        JOYCAPS.rmin(this.struct, rmin);
    }

    public void setRmax(int rmax) {
        JOYCAPS.rmax(this.struct, rmax);
    }

    public void setUmin(int umin) {
        JOYCAPS.umin(this.struct, umin);
    }

    public void setUmax(int umax) {
        JOYCAPS.umax(this.struct, umax);
    }

    public void setVmin(int vmin) {
        JOYCAPS.vmin(this.struct, vmin);
    }

    public void setVmax(int vmax) {
        JOYCAPS.vmax(this.struct, vmax);
    }

    public void setCaps(int caps) {
        JOYCAPS.caps(this.struct, caps);
    }

    public void setMaxAxes(int maxAxes) {
        JOYCAPS.maxAxes(this.struct, maxAxes);
    }

    public void setNumAxes(int numAxes) {
        JOYCAPS.numAxes(this.struct, numAxes);
    }

    public void setMaxButtons(int maxButtons) {
        JOYCAPS.maxButtons(this.struct, maxButtons);
    }

    public void setRegKey(ByteBuffer regKey) {
        JOYCAPS.regKeySet(this.struct, regKey);
    }

    public void setRegKey(CharSequence regKey) {
        JOYCAPS.regKey(this.struct, regKey);
    }

    public void setOEMVxD(ByteBuffer OEMVxD) {
        JOYCAPS.OEMVxDSet(this.struct, OEMVxD);
    }

    public void setOEMVxD(CharSequence OEMVxD) {
        JOYCAPS.OEMVxD(this.struct, OEMVxD);
    }

    public int getMid() {
        return JOYCAPS.mid(this.struct);
    }

    public int getPid() {
        return JOYCAPS.pid(this.struct);
    }

    public void getPname(ByteBuffer pname) {
        JOYCAPS.pnameGet(this.struct, pname);
    }

    public String getPnameString() {
        return JOYCAPS.pnameString(this.struct);
    }

    public String getPnameString(int byteLen) {
        return JOYCAPS.pnameString(this.struct, byteLen);
    }

    public int getXmin() {
        return JOYCAPS.xmin(this.struct);
    }

    public int getXmax() {
        return JOYCAPS.xmax(this.struct);
    }

    public int getYmin() {
        return JOYCAPS.ymin(this.struct);
    }

    public int getYmax() {
        return JOYCAPS.ymax(this.struct);
    }

    public int getZmin() {
        return JOYCAPS.zmin(this.struct);
    }

    public int getZmax() {
        return JOYCAPS.zmax(this.struct);
    }

    public int getNumButtons() {
        return JOYCAPS.numButtons(this.struct);
    }

    public int getPeriodMin() {
        return JOYCAPS.periodMin(this.struct);
    }

    public int getPeriodMax() {
        return JOYCAPS.periodMax(this.struct);
    }

    public int getRmin() {
        return JOYCAPS.rmin(this.struct);
    }

    public int getRmax() {
        return JOYCAPS.rmax(this.struct);
    }

    public int getUmin() {
        return JOYCAPS.umin(this.struct);
    }

    public int getUmax() {
        return JOYCAPS.umax(this.struct);
    }

    public int getVmin() {
        return JOYCAPS.vmin(this.struct);
    }

    public int getVmax() {
        return JOYCAPS.vmax(this.struct);
    }

    public int getCaps() {
        return JOYCAPS.caps(this.struct);
    }

    public int getMaxAxes() {
        return JOYCAPS.maxAxes(this.struct);
    }

    public int getNumAxes() {
        return JOYCAPS.numAxes(this.struct);
    }

    public int getMaxButtons() {
        return JOYCAPS.maxButtons(this.struct);
    }

    public void getRegKey(ByteBuffer regKey) {
        JOYCAPS.regKeyGet(this.struct, regKey);
    }

    public String getRegKeyString() {
        return JOYCAPS.regKeyString(this.struct);
    }

    public String getRegKeyString(int byteLen) {
        return JOYCAPS.regKeyString(this.struct, byteLen);
    }

    public void getOEMVxD(ByteBuffer OEMVxD) {
        JOYCAPS.OEMVxDGet(this.struct, OEMVxD);
    }

    public String getOEMVxDString() {
        return JOYCAPS.OEMVxDString(this.struct);
    }

    public String getOEMVxDString(int byteLen) {
        return JOYCAPS.OEMVxDString(this.struct, byteLen);
    }

    private static native int offsets(long var0);

    public static ByteBuffer malloc() {
        return BufferUtils.createByteBuffer(SIZEOF);
    }

    public static ByteBuffer malloc(int mid, int pid, ByteBuffer pname, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int numButtons, int periodMin, int periodMax, int rmin, int rmax, int umin, int umax, int vmin, int vmax, int caps, int maxAxes, int numAxes, int maxButtons, ByteBuffer regKey, ByteBuffer OEMVxD) {
        ByteBuffer joycaps = JOYCAPS.malloc();
        JOYCAPS.mid(joycaps, mid);
        JOYCAPS.pid(joycaps, pid);
        JOYCAPS.pnameSet(joycaps, pname);
        JOYCAPS.xmin(joycaps, xmin);
        JOYCAPS.xmax(joycaps, xmax);
        JOYCAPS.ymin(joycaps, ymin);
        JOYCAPS.ymax(joycaps, ymax);
        JOYCAPS.zmin(joycaps, zmin);
        JOYCAPS.zmax(joycaps, zmax);
        JOYCAPS.numButtons(joycaps, numButtons);
        JOYCAPS.periodMin(joycaps, periodMin);
        JOYCAPS.periodMax(joycaps, periodMax);
        JOYCAPS.rmin(joycaps, rmin);
        JOYCAPS.rmax(joycaps, rmax);
        JOYCAPS.umin(joycaps, umin);
        JOYCAPS.umax(joycaps, umax);
        JOYCAPS.vmin(joycaps, vmin);
        JOYCAPS.vmax(joycaps, vmax);
        JOYCAPS.caps(joycaps, caps);
        JOYCAPS.maxAxes(joycaps, maxAxes);
        JOYCAPS.numAxes(joycaps, numAxes);
        JOYCAPS.maxButtons(joycaps, maxButtons);
        JOYCAPS.regKeySet(joycaps, regKey);
        JOYCAPS.OEMVxDSet(joycaps, OEMVxD);
        return joycaps;
    }

    public static ByteBuffer malloc(int mid, int pid, CharSequence pname, int xmin, int xmax, int ymin, int ymax, int zmin, int zmax, int numButtons, int periodMin, int periodMax, int rmin, int rmax, int umin, int umax, int vmin, int vmax, int caps, int maxAxes, int numAxes, int maxButtons, CharSequence regKey, CharSequence OEMVxD) {
        ByteBuffer joycaps = JOYCAPS.malloc();
        JOYCAPS.mid(joycaps, mid);
        JOYCAPS.pid(joycaps, pid);
        JOYCAPS.pname(joycaps, pname);
        JOYCAPS.xmin(joycaps, xmin);
        JOYCAPS.xmax(joycaps, xmax);
        JOYCAPS.ymin(joycaps, ymin);
        JOYCAPS.ymax(joycaps, ymax);
        JOYCAPS.zmin(joycaps, zmin);
        JOYCAPS.zmax(joycaps, zmax);
        JOYCAPS.numButtons(joycaps, numButtons);
        JOYCAPS.periodMin(joycaps, periodMin);
        JOYCAPS.periodMax(joycaps, periodMax);
        JOYCAPS.rmin(joycaps, rmin);
        JOYCAPS.rmax(joycaps, rmax);
        JOYCAPS.umin(joycaps, umin);
        JOYCAPS.umax(joycaps, umax);
        JOYCAPS.vmin(joycaps, vmin);
        JOYCAPS.vmax(joycaps, vmax);
        JOYCAPS.caps(joycaps, caps);
        JOYCAPS.maxAxes(joycaps, maxAxes);
        JOYCAPS.numAxes(joycaps, numAxes);
        JOYCAPS.maxButtons(joycaps, maxButtons);
        JOYCAPS.regKey(joycaps, regKey);
        JOYCAPS.OEMVxD(joycaps, OEMVxD);
        return joycaps;
    }

    public static void mid(ByteBuffer joycaps, int mid) {
        joycaps.putShort(joycaps.position() + MID, (short)mid);
    }

    public static void pid(ByteBuffer joycaps, int pid) {
        joycaps.putShort(joycaps.position() + PID, (short)pid);
    }

    public static void pnameSet(ByteBuffer joycaps, ByteBuffer pname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(pname);
            Checks.checkBufferGT(pname, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(pname), MemoryUtil.memAddress(joycaps) + (long)PNAME, pname.remaining());
    }

    public static void pname(ByteBuffer joycaps, CharSequence pname) {
        MemoryUtil.memEncodeUTF16(pname, true, joycaps, PNAME);
    }

    public static void xmin(ByteBuffer joycaps, int xmin) {
        joycaps.putInt(joycaps.position() + XMIN, xmin);
    }

    public static void xmax(ByteBuffer joycaps, int xmax) {
        joycaps.putInt(joycaps.position() + XMAX, xmax);
    }

    public static void ymin(ByteBuffer joycaps, int ymin) {
        joycaps.putInt(joycaps.position() + YMIN, ymin);
    }

    public static void ymax(ByteBuffer joycaps, int ymax) {
        joycaps.putInt(joycaps.position() + YMAX, ymax);
    }

    public static void zmin(ByteBuffer joycaps, int zmin) {
        joycaps.putInt(joycaps.position() + ZMIN, zmin);
    }

    public static void zmax(ByteBuffer joycaps, int zmax) {
        joycaps.putInt(joycaps.position() + ZMAX, zmax);
    }

    public static void numButtons(ByteBuffer joycaps, int numButtons) {
        joycaps.putInt(joycaps.position() + NUMBUTTONS, numButtons);
    }

    public static void periodMin(ByteBuffer joycaps, int periodMin) {
        joycaps.putInt(joycaps.position() + PERIODMIN, periodMin);
    }

    public static void periodMax(ByteBuffer joycaps, int periodMax) {
        joycaps.putInt(joycaps.position() + PERIODMAX, periodMax);
    }

    public static void rmin(ByteBuffer joycaps, int rmin) {
        joycaps.putInt(joycaps.position() + RMIN, rmin);
    }

    public static void rmax(ByteBuffer joycaps, int rmax) {
        joycaps.putInt(joycaps.position() + RMAX, rmax);
    }

    public static void umin(ByteBuffer joycaps, int umin) {
        joycaps.putInt(joycaps.position() + UMIN, umin);
    }

    public static void umax(ByteBuffer joycaps, int umax) {
        joycaps.putInt(joycaps.position() + UMAX, umax);
    }

    public static void vmin(ByteBuffer joycaps, int vmin) {
        joycaps.putInt(joycaps.position() + VMIN, vmin);
    }

    public static void vmax(ByteBuffer joycaps, int vmax) {
        joycaps.putInt(joycaps.position() + VMAX, vmax);
    }

    public static void caps(ByteBuffer joycaps, int caps) {
        joycaps.putInt(joycaps.position() + CAPS, caps);
    }

    public static void maxAxes(ByteBuffer joycaps, int maxAxes) {
        joycaps.putInt(joycaps.position() + MAXAXES, maxAxes);
    }

    public static void numAxes(ByteBuffer joycaps, int numAxes) {
        joycaps.putInt(joycaps.position() + NUMAXES, numAxes);
    }

    public static void maxButtons(ByteBuffer joycaps, int maxButtons) {
        joycaps.putInt(joycaps.position() + MAXBUTTONS, maxButtons);
    }

    public static void regKeySet(ByteBuffer joycaps, ByteBuffer regKey) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(regKey);
            Checks.checkBufferGT(regKey, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(regKey), MemoryUtil.memAddress(joycaps) + (long)REGKEY, regKey.remaining());
    }

    public static void regKey(ByteBuffer joycaps, CharSequence regKey) {
        MemoryUtil.memEncodeUTF16(regKey, true, joycaps, REGKEY);
    }

    public static void OEMVxDSet(ByteBuffer joycaps, ByteBuffer OEMVxD) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkNT2(OEMVxD);
            Checks.checkBufferGT(OEMVxD, 520);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(OEMVxD), MemoryUtil.memAddress(joycaps) + (long)OEMVXD, OEMVxD.remaining());
    }

    public static void OEMVxD(ByteBuffer joycaps, CharSequence OEMVxD) {
        MemoryUtil.memEncodeUTF16(OEMVxD, true, joycaps, OEMVXD);
    }

    public static int mid(ByteBuffer joycaps) {
        return joycaps.getShort(joycaps.position() + MID);
    }

    public static int pid(ByteBuffer joycaps) {
        return joycaps.getShort(joycaps.position() + PID);
    }

    public static void pnameGet(ByteBuffer joycaps, ByteBuffer pname) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(pname, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(joycaps) + (long)PNAME, MemoryUtil.memAddress(pname), pname.remaining());
    }

    public static String pnameString(ByteBuffer joycaps) {
        return MemoryUtil.memDecodeUTF16(joycaps, MemoryUtil.memStrLen2(joycaps, PNAME), PNAME);
    }

    public static String pnameString(ByteBuffer joycaps, int byteLen) {
        return MemoryUtil.memDecodeUTF16(joycaps, byteLen, PNAME);
    }

    public static int xmin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + XMIN);
    }

    public static int xmax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + XMAX);
    }

    public static int ymin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + YMIN);
    }

    public static int ymax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + YMAX);
    }

    public static int zmin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + ZMIN);
    }

    public static int zmax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + ZMAX);
    }

    public static int numButtons(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + NUMBUTTONS);
    }

    public static int periodMin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + PERIODMIN);
    }

    public static int periodMax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + PERIODMAX);
    }

    public static int rmin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + RMIN);
    }

    public static int rmax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + RMAX);
    }

    public static int umin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + UMIN);
    }

    public static int umax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + UMAX);
    }

    public static int vmin(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + VMIN);
    }

    public static int vmax(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + VMAX);
    }

    public static int caps(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + CAPS);
    }

    public static int maxAxes(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + MAXAXES);
    }

    public static int numAxes(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + NUMAXES);
    }

    public static int maxButtons(ByteBuffer joycaps) {
        return joycaps.getInt(joycaps.position() + MAXBUTTONS);
    }

    public static void regKeyGet(ByteBuffer joycaps, ByteBuffer regKey) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(regKey, 64);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(joycaps) + (long)REGKEY, MemoryUtil.memAddress(regKey), regKey.remaining());
    }

    public static String regKeyString(ByteBuffer joycaps) {
        return MemoryUtil.memDecodeUTF16(joycaps, MemoryUtil.memStrLen2(joycaps, REGKEY), REGKEY);
    }

    public static String regKeyString(ByteBuffer joycaps, int byteLen) {
        return MemoryUtil.memDecodeUTF16(joycaps, byteLen, REGKEY);
    }

    public static void OEMVxDGet(ByteBuffer joycaps, ByteBuffer OEMVxD) {
        if (LWJGLUtil.CHECKS) {
            Checks.checkBufferGT(OEMVxD, 520);
        }
        MemoryUtil.memCopy(MemoryUtil.memAddress(joycaps) + (long)OEMVXD, MemoryUtil.memAddress(OEMVxD), OEMVxD.remaining());
    }

    public static String OEMVxDString(ByteBuffer joycaps) {
        return MemoryUtil.memDecodeUTF16(joycaps, MemoryUtil.memStrLen2(joycaps, OEMVXD), OEMVXD);
    }

    public static String OEMVxDString(ByteBuffer joycaps, int byteLen) {
        return MemoryUtil.memDecodeUTF16(joycaps, byteLen, OEMVXD);
    }

    static {
        IntBuffer offsets = BufferUtils.createIntBuffer(24);
        SIZEOF = JOYCAPS.offsets(MemoryUtil.memAddress(offsets));
        MID = offsets.get(0);
        PID = offsets.get(1);
        PNAME = offsets.get(2);
        XMIN = offsets.get(3);
        XMAX = offsets.get(4);
        YMIN = offsets.get(5);
        YMAX = offsets.get(6);
        ZMIN = offsets.get(7);
        ZMAX = offsets.get(8);
        NUMBUTTONS = offsets.get(9);
        PERIODMIN = offsets.get(10);
        PERIODMAX = offsets.get(11);
        RMIN = offsets.get(12);
        RMAX = offsets.get(13);
        UMIN = offsets.get(14);
        UMAX = offsets.get(15);
        VMIN = offsets.get(16);
        VMAX = offsets.get(17);
        CAPS = offsets.get(18);
        MAXAXES = offsets.get(19);
        NUMAXES = offsets.get(20);
        MAXBUTTONS = offsets.get(21);
        REGKEY = offsets.get(22);
        OEMVXD = offsets.get(23);
    }
}

