class GameServer {
  
  Server serverInstance;
  LocalUniverse universe;
  
  public GameServer(PApplet applet, LocalUniverse universe, int port) {
    this.universe = universe;
    this.serverInstance = new Server(applet, port);
  }
  
  public void update(float elapsed) {
    Client remoteClient = this.serverInstance.available();
    if (remoteClient != null) {
      GameClient gc = universe.getGameClient(remoteClient);
      if (gc == null) {
        gc = universe.connect(remoteClient);
        if (gc == null) {
          remoteClient.stop();
          return;
        }
      }
      
      processMessage(gc);
    }
  }
  
  public void destroy(int type, int id) {
    this.serverInstance.write("x:" + str(type) + ":" + str(id) + "|");
  }
  
  public void sync(Client client, Universe u) {
    String message = "y";
    
      for( int b = 0; b < u.bullets.length; ++b) {
        if (u.bullets[b].visible) {
          message += ":" + u.bullets[b].serialize();
        }
      }
      for( int a = 0; a < u.asteroids.length; ++a) {
        if (u.asteroids[a].visible) {
          message += ":" + u.asteroids[a].serialize();
        }
      }
      for( int s = 0; s < u.ships.length; ++s) {
        if (u.ships[s].visible) {
          message += ":" + u.ships[s].serialize();
        }
      }
      for( int e = 0; e < u.explosions.length; ++e) {
        if (u.explosions[e].visible) {
          message += ":" + u.explosions[e].serialize();
        }
      }
      
      message += "|";
      client.write(message);
  }
  
  public void write(String message) {
    this.serverInstance.write(message + "|");
  }
  
  void processMessage(GameClient gameClient) {
    char r = gameClient.remoteClient.readChar();
    if (r == 'a') {
      gameClient.accleration(true);
    } else if (r == 'b') {
      gameClient.turnLeft(true);
    } else if (r == 'c') {
      gameClient.turnRight(true);
    } else if (r == 'd') {
      gameClient.shoot(true);
    } else if (r == 'e') {
      gameClient.accleration(false);
    } else if (r == 'f') {
      gameClient.turnLeft(false);
    } else if (r == 'g') {
      gameClient.turnRight(false);
    } else if (r == 'h') {
      gameClient.shoot(false);
    }
  }
}