class GameModeScene extends Scene {
  
  ControlP5 cp5;
  
  public GameModeScene(PApplet applet) {
    super(applet);
  }
  
  public void clean() {
    if (cp5 != null) {
      cp5.hide();
      cp5 = null;
    }
  }
  
  public void setup() {
    background(0);
    
    int w = width / 2;
    int h = 25;
    int ox = (width - w) / 2;
    
    textFont(bigFont);
    float fw = textWidth("Asteroids");
    text("Asteroids", (width - fw) / 2, 75);
    
    cp5 = new ControlP5(this.applet);
    cp5.addButton("server")
       .setSize(w, h)
       .setPosition(ox, 200);
    cp5.addButton("client")
       .setSize(w, h)
       .setPosition(ox, 250);
  }
  
  public void draw() {
  }
  
  public void controlEvent(ControlEvent cevent) {
    if (cevent.getName().equals("server")) {
      currentScene.clean();
      currentScene = new LocalGameScene(this.applet);
      currentScene.setup();
    } else if (cevent.getName().equals("client")) {      
      currentScene.clean();
      currentScene = new JoinScene(this.applet);
      currentScene.setup();
    }
  }
}