class JoinScene extends Scene {
  
  ControlP5 cp5;

  public JoinScene(PApplet applet) {
    super(applet);
  }
  
  public void clean() {
    if (cp5 != null) {
      cp5.hide();
      cp5 = null;
    }
  }
  
  public void setup() {
    background(0);
    
    int w = width / 2;
    int h = 25;
    int ox = (width - w) / 2;
    
    textFont(bigFont);
    float fw = textWidth("Join Game");
    text("Join Game", (width - fw) / 2, 75);    
    
    cp5 = new ControlP5(this.applet);    
    cp5.addTextfield("remoteIP")
       .setSize(w, h)
       .setPosition(ox, 150)
       .setFocus(true)
       .setAutoClear(false)
       .setText("127.0.0.1")
       .setLabel("Remote address");
    cp5.addButton("connect")
       .setSize(w, h)
       .setPosition(ox, 200);
    cp5.addButton("back")
       .setSize(w, h)
       .setPosition(ox, 300);
  }
  
  public void draw() {
  }
    
  public void controlEvent(ControlEvent cevent) {    
    if (cevent.getName().equals("back")) {
      currentScene.clean();
      currentScene = new GameModeScene(this.applet);
      currentScene.setup();
    } else if (cevent.getName().equals("connect")) {
      String address = ("" + ((controlP5.Textfield)cp5.get("remoteIP")).getText()).trim(); 
      
      if (address == null || address.length() == 0) {
        return;
      }
      
      Client client = new Client(this.applet, address, PORT);
      if (client.active()) {
        currentScene.clean();
        currentScene = new RemoteGameScene(this.applet, client);
        currentScene.setup();
      }
    }
  }
}