class LocalGameScene extends Scene {
  
  LocalUniverse universe;
  GameClient client;
  int lastFrame = 0;
  boolean accleration = false, turnRight = false, turnLeft = false, shooting = false;
  Blur blur = null;
  
  public LocalGameScene(PApplet applet) {
    super(applet);
  }
  
  public void clean() {
    
  }
  
  public void setup() {    
    universe = new LocalUniverse(this.applet, true);
    client = universe.connect(null);
    blur = new Blur();
    blur.init();
    
    lastFrame = millis();
  }
  
  public void draw() {  
    int currentFrame = millis();
    float elapsed = (float)(currentFrame - lastFrame) / 1000.0f;
    lastFrame = currentFrame;
      
    universe.update(elapsed);
    universe.draw();
    
    blur.applyEffect();
  }
  
  public void keyReleased() {
    if (keyCode == 0x20) {
      if (shooting) {
        shooting = false;
        client.shoot(shooting);
      }
    }
    
    if (key == CODED) {
      
      if (keyCode == UP) {
        if (accleration) {
          accleration = false;
          client.accleration(accleration);
        }
      }
      
      if (keyCode == LEFT) {
        if (turnLeft) {
          turnLeft = false;
          client.turnLeft(turnLeft);
        }
      }
      
      if (keyCode == RIGHT) {
        if (turnRight) {
          turnRight = false;
          client.turnRight(turnRight);
        }
      }
    }
  }
    
  public void keyPressed() {
    if (keyCode == 82 || keyCode == 112) {
      if (universe != null) {
        universe.reset();
      }
    }
    
    if (keyCode == 0x20) {
      if (!shooting) {
        shooting = true;
        client.shoot(shooting);
      }
    }
    
    if (key == CODED) {
      if (keyCode == UP) {
        if (!accleration) {
          accleration = true;
          client.accleration(accleration);
        }
      }
      if (keyCode == LEFT) {
        if (!turnLeft) {
          turnLeft = true;
          client.turnLeft(turnLeft);
        }
      }
      if (keyCode == RIGHT) {
        if (!turnRight) {
          turnRight = true;
          client.turnRight(turnRight);
        }
      }
    }
  }
  
  public void serverEvent(Server server, Client client) {
    if (universe != null) {
      universe.connect(client);
    }
  }
  
  public void disconnectEvent(Client client) {
    if (universe != null) {
      universe.disconnect(client);
    }
  }
}