
procedure InitGraph(mode: byte);
//----------------------------------------------------------------------------------------------
// init graphics mode
//----------------------------------------------------------------------------------------------
begin

	if mode=7 then 
asm
{	mwa #160 @command.mWidth
	mva #96 @command.mHeight
};

	if mode=8 then 
asm
{	mwa #320 @command.mWidth
	mva #192 @command.mHeight
};

	if mode=15 then
asm
{	mwa #160 @command.mWidth
	mva #192 @command.mHeight

};


asm
{	stx @sp

	ldy mode

	ldx #$60	; 6*16
	lda #$00	; %00010000 with text window

	@graphics

	ldx @sp
};

end;



procedure SetBkColor(color: byte);
//----------------------------------------------------------------------------------------------
// Sets the background color to Color
//----------------------------------------------------------------------------------------------
begin

asm
{	mva color colbaks
};

end;



procedure SetColor(color: byte);
//----------------------------------------------------------------------------------------------
// Sets the foreground color to Color
//----------------------------------------------------------------------------------------------
begin

asm
{	mva color @COMMAND.colscr
};

end;



procedure PutPixel(x: word; y: word);
//----------------------------------------------------------------------------------------------
// Puts a point at (X,Y) using color Color
//----------------------------------------------------------------------------------------------
begin

asm
{	stx @sp

	cpw y @command.mHeight
	bcs stop

	mwa x colcrs
	mva y rowcrs

	lda #@IDplot

	jsr @COMMAND

stop	ldx @sp
};

end;



procedure MoveTo(x: word; y: byte);
begin
//----------------------------------------------------------------------------------------------
// Move cursor to absolute position
//----------------------------------------------------------------------------------------------
asm
{	mwa x LineTo.x0
	mva y LineTo.y0
};

end;



procedure LineTo(x: word; y: byte);
begin
//----------------------------------------------------------------------------------------------
// Draw a line starting from current position to a given point
//----------------------------------------------------------------------------------------------
asm
{	.var x0 .word
	.var y0 .byte

	stx @sp
		
	mwa x0 colcrs
	mva y0 rowcrs

	lda #@IDplot

	jsr @COMMAND
	

	lda x
	sta colcrs
	sta x0
	lda x+1
	sta colcrs+1
	sta x0+1

	mva y rowcrs
	sta y0

	lda #@IDdraw

	jsr @COMMAND

	ldx @sp
};

end;



procedure Line(x0: word; y0: byte; x1: word; y1: byte);
//----------------------------------------------------------------------------------------------
// Draw a line between 2 points
//----------------------------------------------------------------------------------------------
begin

asm
{	mwa x0 LineTo.x0
	mva y0 LineTo.y0
};

	LineTo(x1,y1);
end;



procedure FloodFill(x: word; y: byte; color: byte);
//----------------------------------------------------------------------------------------------
// Fill an area with a given color
//----------------------------------------------------------------------------------------------
begin

asm
{	stx @sp

	mva color @COMMAND.colscr

	mwa x colcrs
	mva y rowcrs

	lda #@IDfill

	jsr @COMMAND

stop	ldx @sp
};

end;



procedure Circle(x0,y0,radius: word);
//----------------------------------------------------------------------------------------------
// Bresenham Circle
//----------------------------------------------------------------------------------------------

var x,y, d: word;
    txp, typ, txm, tym: word;


 procedure Draw;
 begin
    PutPixel( txp, typ);
    PutPixel( txp, tym);
    PutPixel( txm, typ);
    PutPixel( txm, tym);
 end;


begin

  x := 0;
  y := radius;
  d := 3 - (radius shl 1);		// Decision criterion

  while (x <= y) do begin

    if (d and $8000<>0) then		// d<0

	d := d + x shl 2 + 6		// Change in decision criterion for y -> y+1

    else begin

	d := d + (x - y) shl 2 + 10;	// Change for y -> y+1, x -> x-1
	dec(y);

    end;

    txp := x0+x;  typ := y0+y;
    txm := x0-x;  tym := y0-y;

    Draw;

    txp := x0+y;  typ := y0+x;
    txm := x0-y;  tym := y0-x;

    Draw;

    inc(x);

  end;

end;

