/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.handler.MessageHandler;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.SEIModel;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageHandlerContextImpl;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;

public class ServerMessageHandlerTube
extends HandlerTube {
    private SEIModel seiModel;
    private WSBinding binding;
    private Set<String> roles;

    public ServerMessageHandlerTube(SEIModel sEIModel, WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube);
        this.seiModel = sEIModel;
        this.binding = wSBinding;
        this.setUpHandlersOnce();
    }

    private ServerMessageHandlerTube(ServerMessageHandlerTube serverMessageHandlerTube, TubeCloner tubeCloner) {
        super(serverMessageHandlerTube, tubeCloner);
        this.seiModel = serverMessageHandlerTube.seiModel;
        this.binding = serverMessageHandlerTube.binding;
        this.handlers = serverMessageHandlerTube.handlers;
        this.roles = serverMessageHandlerTube.roles;
    }

    private void setUpHandlersOnce() {
        this.handlers = new ArrayList();
        HandlerConfiguration handlerConfiguration = ((BindingImpl)this.binding).getHandlerConfig();
        List<MessageHandler> list = handlerConfiguration.getMessageHandlers();
        if (!list.isEmpty()) {
            this.handlers.addAll(list);
            this.roles = new HashSet<String>();
            this.roles.addAll(handlerConfiguration.getRoles());
        }
    }

    @Override
    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        Map map = (Map)messageUpdatableContext.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
        for (String string : map.keySet()) {
            if (attachmentSet.get(string) != null) continue;
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, (DataHandler)map.get(string));
            attachmentSet.add(dataHandlerAttachment);
        }
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
    }

    @Override
    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, !bl);
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw runtimeException;
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    @Override
    void setUpProcessor() {
        if (!this.handlers.isEmpty()) {
            this.processor = new SOAPHandlerProcessor(false, this, this.binding, this.handlers);
        }
    }

    @Override
    void closeHandlers(MessageContext messageContext) {
        this.closeServersideHandlers(messageContext);
    }

    @Override
    MessageUpdatableContext getContext(Packet packet) {
        MessageHandlerContextImpl messageHandlerContextImpl = new MessageHandlerContextImpl(this.seiModel, this.binding, this.port, packet, this.roles);
        return messageHandlerContextImpl;
    }

    @Override
    protected void initiateClosing(MessageContext messageContext) {
        this.close(messageContext);
        super.initiateClosing(messageContext);
    }

    @Override
    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ServerMessageHandlerTube(this, tubeCloner);
    }
}

