#ifdef GL_ES
precision mediump float;
#endif

#define PROCESSING_TEXTURE_SHADER

uniform float iGlobalTime;
uniform vec2 iResolution;
uniform sampler2D texture;

void main() {
	vec2 pos = gl_FragCoord.xy / iResolution;
	pos-=vec2(.45+.01*cos(.005*iGlobalTime),.85-.1*sin(.001*iGlobalTime));
	pos*=3.+sin(iGlobalTime);
	pos = cos(.8*iGlobalTime) * pos + vec2(1,-1)*sin(.1*iGlobalTime)*pos.yx; 
	vec2 c = pos;
	vec3 color = vec3(0);
	
	for(int i=0; i<50; i++) {
		pos = vec2( pos.x*pos.x - pos.y*pos.y,2.*pos.x*pos.y) + c;
		if(length(pos) < 20.)color+=vec3(0.03,0.001,0.001);
	}
	
	vec2 texcoord = gl_FragCoord.xy / iResolution;
	texcoord.y = 1-texcoord.y;

	vec4 texcolor = texture2D(texture, texcoord);


	gl_FragColor = vec4(mix(color, texcolor.xyz, texcolor.a), 1.);
}
