class Car extends GameObject {
  float h = 50;
  float vx = 0.0;

  public Car() {
  }

  public Car(float x, float z) {
    this.x = x;
    this.z = z;
  }

  void init() {
    y += - h / 2;
  }

  void update(double dt) {
    x = (float)moonlander.getValue("speed");
  }

  void drawWheel(Drawer drawer, float x, float z) {
    pg.pushMatrix();
    pg.translate(x, -50, z);
    pg.rotateZ(millis() / 1000.0);
    pg.fill(5, 7, 15);
    drawer.drawCylinder(10, 100, 50);
    pg.popMatrix();
  }

  void paint(Drawer drawer) {
    pg.pushMatrix();
    pg.translate(this.x, this.y, this.z);

    pg.fill(200, 0, 0);
    pg.pushMatrix();
    pg.translate(0, -150 + ((beatState > 1) ? 50*(float)beat : 0), 0);
    pg.box(400, 200, 240);
    pg.pushMatrix();
    pg.textSize(100);
    pg.fill(0,0,0);
    
    pg.text("Badass",-170,50,121);
    pg.rotateY(PI);
    pg.textSize(40);
    pg.text("Reserved for Sponsors",-190,0,121);
    pg.popMatrix();
    //Puskurit
    pg.fill(200, 0, 0);
    pg.translate(250, 40, 0);
    pg.box(100, 150, 240);
    pg.pushMatrix();
    pg.fill(247, 219, 7);
    pg.translate(55, -80, -30);
    pg.rotateY(PI/2);
    pg.ellipse(50, 50, 50, 50 + ((beatState > 1) ? -30*(float)beat : 0));
    pg.translate(-150, 0, 0);
    pg.ellipse(50, 50, 50, 50 + ((beatState > 1) ? -30*(float)beat : 0));
    pg.popMatrix();
    pg.fill(200, 0, 0);
    pg.translate(-500, 0, 0);
    pg.box(100, 150, 240);
    pg.translate((250.0), -185, 0);
    //Spoiler
    pg.pushMatrix();
    pg.translate(-230,0,0);
    pg.rotateZ(-PI/4);
    pg.box(30, 120, 240);
    pg.popMatrix();
    //Pää
    pg.fill(0, 0, 0);
    pg.pushMatrix();
    if (beatState > 0) {
      pg.translate(50*(float)beat, 0, 0);
    }
    pg.sphere(50);
    pg.translate(-10, -50, -40);
    pg.rotateY(PI/2);
    drawer.drawCylinder(40, 40, 40);
    pg.translate(-80, 0, 0);
    drawer.drawCylinder(40, 40, 40);
    pg.popMatrix();
    pg.fill(255, 255, 255, 50);
    pg.translate(130, 10, 0);
    pg.rotateZ(0.4);
    pg.box(100, 20, 240);
    pg.popMatrix();

    drawWheel(drawer, 200, 120);
    drawWheel(drawer, -200, 120);
    drawWheel(drawer, 200, -120);
    drawWheel(drawer, -200, -120);

    pg.popMatrix();
  }
}

