class Snowflake extends GameObject {
  
  ArrayList<GameObject> gameObjects;
  
  public color snow_color = color(200);
  public boolean draw_snow = true;
  public float snow_v = 1000;
  color snow_color2 = color(random(256), random(256), random(256));
  
  public Snowflake(ArrayList<GameObject> gameObjects) {
    
    int status = moonlander.getIntValue("status");
    float cameraZ = (float)moonlander.getValue("cameraZ");
    float cameraX = (float)moonlander.getValue("cameraX");
    
    if (status == 1) {
      this.x = random(3000) - 1500 + carx;
      this.z = random(3000) - 1500 + 250;
    } else if (status == 2){
      this.x = random(3000) - 1500 + carx + cameraX;
      this.z = random(3000) - 1500 + 250 - cameraZ;
    }else if(status == 3 || status == 5){
      this.x = random(3000) - 1500 +  carx + cameraX;
      this.z = random(3000) - 1500 + 250 - cameraZ;
    }else{
      this.x = random(3000) - 1500 + carx + 900;
      this.z = random(3000) - 1500;
    }
    this.y = -1000;
    this.gameObjects = gameObjects;
  }
  
  void init() {
    
  }
  
  void update(double dt) {
    if (sf2 > 10) snow_color = snow_color2;
    if (draw_snow == true) {
      y += snow_v * dt;
      if (y > 5) draw_snow = false; //gameObjects.remove(this);//
    }
  }
  
  void paint(Drawer drawer)
  {
    if (draw_snow == true) {
      pg.pushMatrix();
      pg.noLights();
      pg.translate(this.x, this.y, this.z);
      pg.fill(snow_color);
      pg.sphere(9);
      pg.popMatrix();
      pg.lights();  
    }    
  };
  
}
