class Tree extends GameObject {
  float sphereRadius = 100;
  float h = 300;
  int r = 0;
  int g = 0;
  int b = 0;
  double last;
  GameObject car;

  public Tree(float x, float z, GameObject cars) {
    this.x = x;
    this.z = z;
    car = cars;
  }

  void init() {
    y += - h / 2;
  }

  void update(double dt) {
    sphereRadius = 200 + (int) ((beatState > 2) ? 60*(float)beat : 0);
    if (car.x - this.x > 10000) {
      this.x = car.x + 10000;
    }
  }

  void paint(Drawer drawer) {
    float cameraX = (float)moonlander.getValue("cameraX");
    int status = moonlander.getIntValue("status");
    pg.pushMatrix();
    if (status == 1) {
      pg.translate(this.x, this.y +h*cameraX -2*cameraX, this.z);
    } else {
      pg.translate(this.x, this.y, this.z);
    }
    pg.fill(176, 80, 1);

    pg.box(40, 300, 40);
    if (status == 1) {
      pg.translate(0, -h + sphereRadius / 1.8 + h*cameraX, 0);
    } else {
      pg.translate(0, -h + sphereRadius / 1.8, 0);
    }
    if (beatState > 2.5) {
      if (beat - last > 0.7) {
        r = (int)random(256);
        g = (int)random(256);
        b = (int)random(256);
      }
      last = beat;
    } else {
      r = (int)red;
      g = (int)green;
      b = (int)blue;
    }
    pg.fill(r, g, b);
    pg.sphere(sphereRadius);
    pg.popMatrix();
  }
}

