import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class ineiros extends PApplet {

// ineiros 2015
// Contains a bunch of dead and unsightly code. Reader beware.



// Minim must be imported when using Moonlander with soundtrack.


Moonlander moonlander;

// 1920 x 1080
int CANVAS_WIDTH = 1920;
int CANVAS_HEIGHT = 1080;

float magicX = 2*467.75f; // Divide this by 2 if you halve the canvas size

float ASPECT_RATIO = (float)CANVAS_WIDTH/CANVAS_HEIGHT;

PGraphics titleSurface;
PFont mono;

String[] textLines;

public void setup() {
  moonlander = Moonlander.initWithSoundtrack(this, "kuroshio-hacked-nasty-cut.mp3", 130, 8);
  size(CANVAS_WIDTH, CANVAS_HEIGHT, P3D);
  frameRate(60);
  rectMode(CENTER);
  
  mono = loadFont("AndaleMono-36.vlw");
  initPos();

  titleSurface = createGraphics(width, height, P3D);
  g.textFont(mono);
  // PGraphics sceneB = createGraphics(width, height, P3D);

  textLines = loadStrings("scroller.txt");

  moonlander.start();
}

int textHeight = 36;
int spacing = textHeight+26;
int magic = 20;

public void drawTitle(PGraphics g2) {
  if (g != g2) { g2.beginDraw(); }
  g2.textSize(textHeight);
  g2.pushMatrix();
  g2.resetMatrix();
  g2.translate(0,0,-magicX);
  g2.fill(255);
 
  g2.text("Music by Kuroshio: Hacked (Nasty Cut)", -width/2.0f, height/2-spacing, 0);

//  g2.strokeWeight(1);
//  g2.stroke(255,0,0);
//  g2.line(-width/2.0, -height/2.0, 0, width/2.0, -height/2.0, 0); 
//  g2.line(-width/2.0, height/2.0, 0, width/2.0, height/2.0, 0);
//  g2.line(-width/2.0, height/2.0, 0, -width/2.0, -height/2.0, 0);
//  g2.line(width/2.0, height/2.0, 0, width/2.0, -height/2.0, 0);

  g2.popMatrix();
  
  if (g != g2) { g2.endDraw(); }
}

final static int singStart = 516;

float row = 0;



public void draw() {
  moonlander.update();
  background(0, 0, 0);
  
  float beat = (float) moonlander.getValue("beat");
  float cx = (float) moonlander.getValue("camera"); 
  float jitter = (float) moonlander.getValue("jitter");
  row = (float) moonlander.getCurrentRow();

  if (row < 3100) {
    // draw3DAxes(g);
    camera(cx, cx, cx, 0+randomValue2(jitter), 0+randomValue2(jitter), 150+randomValue2(jitter), 0, 1, 0);
  
    // Rotate the viewport a bit with mouse
    // rotateY((mouseX - width/2) * 0.005);
    // rotateX((mouseY - height/2) * -0.005);

    if (row < 200) {
      drawTitle(g);           
    }
  
    attractor();
    if (row > 1900) {
      if (row == 1901) { textScroll = 0; } // For debug
      drawTextScroll(g);
    }
    
    alpha = (float) moonlander.getValue("alpha");
  } else if (row < 3496) {
    // draw3DAxes(g);
    lights(); 
    camera(cx, -cx, cx, 0, 0, 0, 0, 1, 0);
    drawCube(g); 
  } else {
    exit(); 
  }
  
//  hint(DISABLE_DEPTH_TEST);
//  hint(ENABLE_DEPTH_SORT);
//  lights();  
//  
//  
//  box(30);
//  translate(-50, 0, 0);
//  fill(255); 
//  box(30);
//   
  //hint(DISABLE_DEPTH_SORT);
  //hint(ENABLE_DEPTH_TEST);
  
//  drawDebug(g); 
}

public float t() {
  return (float)moonlander.getCurrentTime();
} 

float alpha = 1;

float rho = 28;
float sigma = 10;
float beta = 2.67f;

float scale = 5;

float previousT = 0;
int nParticles = 4*1024;
float[][] pos;

ArrayList lines;
int age = 0;

float lastReset = 0;

public void initPos() {
  pos = new float[nParticles][4];
  for (int i = 0; i < nParticles; i++) {
    initParticle(i);
  }
  precalc();
  lines = new ArrayList();
}

public void precalc() {
   float dT = 0.005f;
   for (int k = 0; k < 100; k++) {
     for (int i = 0; i < pos.length; i++) {
        float x = pos[i][0];
        float y = pos[i][1];
        float z = pos[i][2];
  
        // Equations by a famous dead guy
        // R.I.P. Edward Lorenz
        pos[i][0] += dT*(sigma*(y-x));
        pos[i][1] += dT*(x*(rho-z)-y);
        pos[i][2] += dT*(x*y-beta*z);   
        pos[i][3] -= 1;
        if (pos[i][3] <= 0) {
          initParticle(i);
        }
     }      
   }
}

public void initParticle(int i) {
    pos[i][0] = randomValue();  
    pos[i][1] = randomValue();
    pos[i][2] = randomValue();
    pos[i][3] = timeToLive();
}

public float timeToLive() {
  return 5*100*abs(randomGaussian());  
}

public float randomValue() {
   return (float) (randomGaussian()/alpha);
}

public float randomValue2(float b) {
   return (float) b*(randomGaussian());  
}

public void attractor() {

  rho = (float)moonlander.getValue("rho");
  sigma = (float)moonlander.getValue("sigma");
  beta = (float)moonlander.getValue("beta");
  
  fill(255,0,255);
  
  float T = millis();
  float dT = (T - previousT)/10000;
  previousT = T;

  sphereDetail(3);
  pushMatrix();  
  translate(0,-50,0);
  scale(10,10,10);
  
  int finalI = pos.length;
  if (row > 2400) {
       finalI = (int) lerp(pos.length, 0, (row-2400)/(650));
  }
  
  for (int i = 0; i < pos.length; i++) {
      if (i >= finalI) {
        break; 
      }

    
      float x = pos[i][0];
      float y = pos[i][1];
      float z = pos[i][2];

      pos[i][0] += dT*(sigma*(y-x));
      pos[i][1] += dT*(x*(rho-z)-y);
      pos[i][2] += dT*(x*y-beta*z);
      pos[i][3] -= 1;
      
      pushMatrix();           
      translate(pos[i][0], pos[i][1], pos[i][2]);
      if (i == 0 && frameCount % 60 == 0) {
        // System.out.println(pos[i][0] + "," pos[i][1] + "," + pos[i][2]);
        System.out.println(dT + ": " + pos[i][0] + "," + pos[i][1] + "," + pos[i][2]);
      }
  
      noStroke();    
      sphere(0.05f);
  
      if (row >= 260 && row % 260 < 130 && row <= 596) {
        stroke(255,0,0);
        strokeWeight(0.05f);                
        line(pos[i][0], pos[i][1], pos[i][2], x, y, z);
          
      } else if (i < 256 && row > 596 && row < 2100) {
        FloatList l = new FloatList();
        l.append(pos[i][0]);
        l.append(pos[i][1]);
        l.append(pos[i][2]);
        l.append(x);
        l.append(y);
        l.append(z);
        l.append(row);
        lines.add(l);
      }

           
           
      popMatrix();
      
      if (pos[i][3] <= 0 || Float.isNaN(pos[i][0])) {
        initParticle(i);
      }
  }

  if (row > 1827) {
    lines.clear(); 
  }
  
  if (row < 1284 || row > 1540) {
    stroke(255,255,255);      
  } else {
    stroke(row % 255,row*74 % 128,5*row%255);
  }
  strokeWeight(0.05f);
  for (int i = 0; i < lines.size(); i++) {
   //  if (i == 0) {println(lines.size());};
    FloatList l = (FloatList)(lines.get(i));

        if (l.get(6) < row - 300) {lines.remove(i);} 
        else {        
        line(l.get(0), l.get(1), l.get(2), l.get(3), l.get(4), l.get(5));
        }

  }
  
  // For debugging / rocket
      if (row < 596) {
        lines.clear(); 
      }
  
  // println(row);
  if (row > 1555) {
    
    if (row > (lastReset - 35) && ((int) row) % 35 == 0) {
      println("CLEAR! " + row + " " + lastReset);
   
      lastReset = row;
      lines.clear();
      
     } 
  }
  
  popMatrix();  
}


int scroll = 0;
public void drawCube(PGraphics s) {
  println(row);
  if (row == 3100) {
    scroll = 0; 
  }
  s.pushMatrix();
  s.stroke(0);
  s.strokeWeight(1);
  s.fill(255,255,255);
  s.rotateX(millis()/1000.0f);
  s.rotateY(millis()/1000.0f);
  
  s.box(50);
  s.pushMatrix();
  s.resetMatrix();
  s.translate(-width/2, -height/2, -magicX);
  s.stroke(255);
  s.fill(255, 120, 255);
  s.hint(DISABLE_DEPTH_TEST);
  s.scale(.7f);
  s.textSize(textHeight);
  s.text("Obligatory cube!", width/2-150, height/2-200, 0);
  
  s.fill(255, 255, 255);
  s.textSize(2*textHeight);
  s.text("You have been watching:\n\nControl\nby ineiros / The Bayesian Conspiracy\n", 50, height-scroll++, 0);
  s.hint(ENABLE_DEPTH_TEST);
  s.popMatrix();
  s.popMatrix();
}

float textScroll = 0;
public void drawTextScroll(PGraphics s) {
  if (textScroll == 0) { textScroll = row; }
  s.pushMatrix();
  s.resetMatrix();
  s.translate(-width/2, -height/2, -magicX);
  s.scale(.7f);
  s.stroke(255);
  s.fill(255, 255, 255);
  s.hint(DISABLE_DEPTH_TEST);
  s.textSize(2*textHeight);
  // textScroll += 2;
  for (int i = 0; i < textLines.length; i++) {
    s.text(textLines[i], 30, height+1.5f*i*spacing-5*(row-textScroll), 0);
  }
  s.hint(ENABLE_DEPTH_TEST);
  s.popMatrix();
}

public void drawDebug(PGraphics g) {
  g.pushMatrix();
  g.resetMatrix();
  g.translate(-width/2, -height/2, -magicX);
  g.fill(255, 0, 0);

  g.textSize(24);
 
  g.text("Track Time: " + String.format("%.2f", moonlander.getCurrentTime()), 0, 20, 0);
  g.text("Run Time: " + String.format("%.2f", (float) millis()/1000), 0, 50, 0);
  g.text("Row: " + String.format("%.0f", moonlander.getCurrentRow()), 0, 80, 0);

  g.popMatrix();
}

public void draw3DAxes(PGraphics g) {
  g.pushMatrix();
  g.strokeWeight(1);
  
  g.stroke(255,0,0);
  g.line(0, 0, 0, 1000, 0, 0);

  g.stroke(0,255,0);  
  g.line(0, 0, 0, 0, 1000, 0);
  
  g.stroke(0,0,255);
  g.line(0, 0, 0, 0, 0, 1000);

  g.popMatrix();
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "ineiros" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
