import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import moonlander.library.*; 
import ddf.minim.*; 
import java.util.Random; 
import java.util.List; 
import java.util.Iterator; 
import java.util.Collections; 
import java.util.Comparator; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class NoHome extends PApplet {









Moonlander moonlander;

public class Cloud {
  
  double x;
  int cloudy;
  int newcloudy;
  int size1;
  int size2;
  int size3;
 
 public Cloud(int asdX) {
    x = 0;
    cloudy = 100;
    newcloudy = cloudy;
  } 
  
  public void draw() {
    if (x < WIDTH + 800) {
      x += 0.15f;
    } else {
      x = 0;
      size1 = rand.nextInt(10) + 15;
      size2 = rand.nextInt(10) + 10;
      size3 = rand.nextInt(10) + 25;
    }
    noStroke();
    fill(255, 255, 255);
    ellipse((int)x, cloudy, 130, 80);
    ellipse((int)x + 20, cloudy + size1, 110, 60);
    ellipse((int)x - 30, cloudy - size1, 160, 80);
    
    ellipse((int)x - 330, cloudy, 160, 50);
    ellipse((int)x - 350, cloudy + size2, 110, 70);
    ellipse((int)x - 360, cloudy - size2, 170, 40);
    
    ellipse((int)x - 760, cloudy, 100, 50);
    ellipse((int)x - 770, cloudy + size3, 170, 40);
    ellipse((int)x - 780, cloudy - size3, 130, 60);
  }
}

public class Ball {
  
  int x;
  int oldy;
  double newy;
  int radius;
  
  public Ball(int startX) {
    x = 0;
    oldy = HEIGHT * 3 / 4;
    newy = oldy;
    radius = 50;
  }
    
  
  public void draw() {
    if (x < WIDTH + radius) {
      x = x + 1;
      newy += 0.25f;
    } else {
      x = -radius / 2;
      if (newy >= HEIGHT - 80) {
      newy = HEIGHT / 2 + 100;
      } else {
        newy += 50;
      }
    }
    fill(184, 171, 3);
    ellipse(x, (int)newy - abs(sin(millis()* (0.005f * sin(15)))) * 10, radius, radius);
  }
}

public class Road {
  
  int x, y, width, oldY, c1, c2, c3, c4;
  
  public Road(int startY) {
    x = rand.nextInt(10);
    y = startY;
    width = rand.nextInt(5)+30;
    int oldY = startY;
    c1 = rand.nextInt(20) + 25;
    c2 = rand.nextInt(20) + 25;
    c3 = rand.nextInt(20) + 25;
    c4 = rand.nextInt(20) + 25;
  }
  
  public int getWidth() {
    return (int)(width * (((moonlander.getCurrentTime()+y)/20)%1) * 20);
  }
  
  public int getY() {
    return (int)(HEIGHT / 2 * (((moonlander.getCurrentTime()+y)/20)%1));
  }
  
  public void draw() {
    if (oldY > getY()) {
      x = rand.nextInt(7);
      width = rand.nextInt(5)+30;
      c1 = rand.nextInt(20) + 25;
      c2 = rand.nextInt(20) + 25;
      c3 = rand.nextInt(20) + 25;
      c4 = rand.nextInt(20) + 25;
    }
    oldY = getY();
    rectMode(CORNER);
    stroke(200, 80, 25);
    fill(200, 80, 25);
    rect(WIDTH/2+x-3-getWidth()/2, 
    HEIGHT/2 + horizonBonus + getY(), 
    getWidth(), 50, 
    c1, c2, c3, c4);
  }
}

public class Cactus implements Comparator<Cactus>, Comparable<Cactus>{
  
  PShape c;
  int x, y, size, oldY, bx, leftBonus, rightBonus;
  public int startY;
  boolean right = rand.nextBoolean();
  int co;
  float sizeBonus;
  
  public Cactus(int sY) {
    x = 0;
    y = 0;
    size = 0;
    oldY = y;
    startY = sY;
    bx = 100 + rand.nextInt(200);
    co = randColor();
    sizeBonus = 0.8f + (rand.nextFloat() * (0.4f));
    leftBonus = rand.nextInt(21)-10;
    rightBonus = rand.nextInt(21)-10;
  }
  public int randColor() {
    int base = rand.nextInt(100);
    return color(rand.nextInt(50) + base, 
    rand.nextInt(100) + base + 55, 
    rand.nextInt(50) + base);
  }
  
  public int getY() {
    return (int)(((startY+moonlander.getCurrentTime())%20)*20);
  }
  
  public int getX() {
    int a = (int)(40*((startY+moonlander.getCurrentTime())%20) + bx);
    if (right) { return a; }
    else { return -a; }
  }
  
  public int compareTo(Cactus c){
    return Integer.compare(this.getY(), c.getY());
  }
  
  public int compare(Cactus c1, Cactus c2){
    return c1.getY() - c2.getY();
  }
  
  public void draw() {
    
    if (oldY > getY()) {
      right = rand.nextBoolean();
      co = randColor();
      bx = 100 + rand.nextInt(200);
      sizeBonus = 0.8f + (rand.nextFloat() * (0.4f));
      leftBonus = rand.nextInt(21)-10;
      rightBonus = rand.nextInt(21)-10;
    }
    oldY = getY();
    
    resetMatrix();
    translate(0 + WIDTH/2 + getX(), getY() + HEIGHT / 2 + horizonBonus);
    scale((float)((startY+moonlander.getCurrentTime()) % 20) * sizeBonus / 5);
    
    stroke(0, 0, 0);
    fill(co);
    beginShape();
    curveVertex(x, y); //ground
    curveVertex(x - 10, y);
    curveVertex(x - 15, y - 40 + leftBonus); //left
    curveVertex(x - 55, y - 50 + leftBonus);
    curveVertex(x - 60, y - 85 + leftBonus);
    curveVertex(x - 40, y - 90 + leftBonus);
    curveVertex(x - 35, y - 65 + leftBonus);
    curveVertex(x - 15, y - 70 + leftBonus); //middle
    curveVertex(x - 10, y - 130);
    curveVertex(x + 10, y - 130);
    curveVertex(x + 15, y - 70 + rightBonus); //right
    curveVertex(x + 35, y - 65 + rightBonus);
    curveVertex(x + 40, y - 90 + rightBonus);
    curveVertex(x + 60, y - 85 + rightBonus);
    curveVertex(x + 55, y - 50 + rightBonus);
    curveVertex(x + 15, y - 40 + rightBonus);
    curveVertex(x + 10, y); //ground
    curveVertex(x, y);
    endShape();
    resetMatrix();
    
  }
}

public void setup() {
  moonlander = Moonlander.initWithSoundtrack(this, "Cullah_-_No_Home.mp3", 51, 8);
  size(WIDTH, HEIGHT, P2D);
  moonlander.start();
}

public void drawGround() {
  rectMode(CORNERS);
  stroke(220, 100, 45);
  fill(220, 100, 45);
  rect(0, HEIGHT/2 + horizonBonus, WIDTH, HEIGHT);
  stroke(200, 80, 25);
  fill(200, 80, 25);
  quad(WIDTH/2-10, HEIGHT/2 + horizonBonus, 
  WIDTH/2+10, HEIGHT/2 + horizonBonus, 
  WIDTH/2 + 20, HEIGHT,
  WIDTH/2 - 20, HEIGHT);
  
  Iterator<Road> iR = roadList().iterator();
  while (iR.hasNext()) {
    iR.next().draw();
  }
}

public void drawCity() {
  double x;
  x = 0;  
  if (dayTime() >= 0.70f) {
    x += 1;
  }
  if (dayTime() >= 0.70f) {
    beginShape();
    fill(249, 249, 115);
    vertex(100, HEIGHT / 2 + 250);
    fill(bColor());
    vertex((int)x + 150, 0);
    vertex((int)x + 230, 0);
    endShape();
   
    beginShape();
    fill(249, 249, 80);
    vertex(200, HEIGHT / 2 + 250);
    fill(bColor());
    vertex((int)x + 350, 0);
    vertex((int)x + 430, 0);
    endShape();
   
    beginShape();
    fill(249, 249, 115);
    vertex(20, HEIGHT / 2 + 250);
    fill(bColor());
    vertex((int)x + 810, 0);
    vertex((int)x + 930, 0);
    endShape();
  }
    //triangle(100, HEIGHT / 2 + 150, 150, HEIGHT / 2 - 150, 230, HEIGHT / 2 - 100);
  noStroke();
   fill(104, 9, 12);  //wine red
  rect(10, HEIGHT / 2 - 20, 50, 50);
   fill(7, 87, 79);  //deepsea blue
  rect(63, HEIGHT / 2 - 30, 70, 50);
   fill(87, 47, 7); //dark brown
  rect(136, HEIGHT / 2 - 15, 40, 50);
   fill(58, 2, 49); //dark violet
  rect(180, HEIGHT / 2 - 40, 30, 50);
   fill(36, 90, 30); //grass green
  rect(213, HEIGHT / 2 - 10, 70, 50);
   fill(177, 181, 85); //sandsea yellow
  rect(285, HEIGHT / 2 - 100, 20, 150);
   fill(215, 123, 243); //swedish dildo
  rect(310, HEIGHT / 2 - 35, 50, 50);
   fill(243, 123, 159); //fresh rose ---
  rect(362, HEIGHT / 2 - 45, 75, 50);
   fill(198, 255, 217); //green breeze
  rect(570 + 250, HEIGHT / 2 - 25, 50, 50);
   fill(252, 241, 204); //warm sand
  rect(623 + 250, HEIGHT / 2 - 35, 40, 50);
   fill(204, 252, 234); //seabreeze
  rect(670 + 250, HEIGHT / 2 - 55, 40, 70);
   fill(252, 204, 204); //lovely pink
  rect(713 + 250, HEIGHT / 2 - 15, 70, 50);
   fill(236, 252, 204); //rai rai raigrass
  rect(785 + 250, HEIGHT / 2 - 65, 20, 90);
   fill(204, 207, 252); //crystal clear sea
  rect(810 + 250, HEIGHT / 2 - 25, 40, 50);
   fill(230, 204, 252); //welcoming lila
  rect(855 + 250, HEIGHT / 2 - 30, 30, 50);
   fill(195, 255, 155); //light green
  rect(889 + 250, HEIGHT / 2 - 45, 65, 50);
   fill(255, 216, 155); //light brown
  rect(957 + 250, HEIGHT / 2 - 30, 55, 50);
  stroke(180, 255, 255);
   fill(180, 255, 255);
  ellipse(25, HEIGHT / 2 - 10, 5, 3);
  ellipse(45, HEIGHT / 2 - 10, 5, 3);
  ellipse(80, HEIGHT / 2 - 10, 5, 3);
  ellipse(100, HEIGHT / 2 - 10, 5, 3);
  ellipse(120, HEIGHT / 2 - 10, 5, 3);
  ellipse(80, HEIGHT / 2 - 18, 5, 3);
  ellipse(100, HEIGHT / 2 - 18, 5, 3);
  ellipse(120, HEIGHT / 2 - 18, 5, 3);
  ellipse(145, HEIGHT / 2  - 5, 5, 3);
  ellipse(165, HEIGHT / 2 - 5, 5, 3);
  ellipse(187, HEIGHT / 2 - 10, 5, 3);
  ellipse(203, HEIGHT / 2 - 10, 5, 3);
  ellipse(187, HEIGHT / 2 - 20, 5, 3);
  ellipse(203, HEIGHT / 2 - 20, 5, 3);
  ellipse(225, HEIGHT / 2 - 5, 5, 3);
  ellipse(240, HEIGHT / 2 - 5, 5, 3);
  ellipse(255, HEIGHT / 2 - 5, 5, 3);
  ellipse(270, HEIGHT / 2 - 5, 5, 3);
  ellipse(290, HEIGHT / 2 - 10, 5, 3);
  ellipse(300, HEIGHT / 2 - 10, 5, 3);
  ellipse(290, HEIGHT / 2 - 25, 5, 3);
  ellipse(300, HEIGHT / 2 - 25, 5, 3);
  ellipse(290, HEIGHT / 2 - 40, 5, 3);
  ellipse(300, HEIGHT / 2 - 40, 5, 3);
  ellipse(290, HEIGHT / 2 - 55, 5, 3);
  ellipse(300, HEIGHT / 2 - 55, 5, 3);
  ellipse(290, HEIGHT / 2 - 70, 5, 3);
  ellipse(300, HEIGHT / 2 - 70, 5, 3);
  ellipse(290, HEIGHT / 2 - 85, 5, 3);
  ellipse(300, HEIGHT / 2 - 85, 5, 3);
  ellipse(320, HEIGHT / 2 - 10, 5, 3);
  ellipse(335, HEIGHT / 2 - 10, 5, 3);
  ellipse(350, HEIGHT / 2 - 10, 5, 3);
  ellipse(320, HEIGHT / 2 - 20, 5, 3);
  ellipse(335, HEIGHT / 2 - 20, 5, 3);
  ellipse(350, HEIGHT / 2 - 20, 5, 3);
  ellipse(375, HEIGHT / 2 - 10, 5, 3);
  ellipse(390, HEIGHT / 2 - 10, 5, 3);
  ellipse(405, HEIGHT / 2 - 10, 5, 3);
  ellipse(420, HEIGHT / 2 - 10, 5, 3);
  ellipse(375, HEIGHT / 2 - 20, 5, 3);
  ellipse(390, HEIGHT / 2 - 20, 5, 3);
  ellipse(405, HEIGHT / 2 - 20, 5, 3);
  ellipse(420, HEIGHT / 2 - 20, 5, 3);
  ellipse(375, HEIGHT / 2 - 30, 5, 3);
  ellipse(390, HEIGHT / 2 - 30, 5, 3);
  ellipse(405, HEIGHT / 2 - 30, 5, 3);
  ellipse(420, HEIGHT / 2 - 30, 5, 3);
}

public void drawCactuses() {
  Iterator<Cactus> iC = cactusList().iterator();
  while (iC.hasNext()) {
    iC.next().draw();
  }
}

public void drawBall() {
  B0.draw();
}

public void drawClouds() {
  Cl0.draw();
}

public int bColor() {
  return lerpColor(
                      color(150, 235, 235), 
                      color(15, 30, 75), 
                      (float)dayTime()
                     );
}

public void drawSky() {
  
  background(bColor());
  
  float x = 0;
  float y = 0;
  
  resetMatrix();
  translate(WIDTH/2, HEIGHT/2);
  
  float angle = (float)(-moonlander.getCurrentTime()/10 + PI*3/2);
  fill(255, 255, 0);
  
  x = (cos(angle))*WIDTH/3;
  y = (sin(angle))*HEIGHT/3;
  
  ellipse(x, y, 100, 100);
  
  angle = (float)(-moonlander.getCurrentTime()/10 + PI/2);
  fill(255, 255, 200);
  
  x = (cos(angle))*WIDTH/3;
  y = (sin(angle))*HEIGHT/3;
  
  ellipse(x, y, 50, 50);
  
  fill(bColor());
  
  ellipse(x - 8, y - 5, 52, 52);
  
  resetMatrix();

}

public double dayTime() {
  double a = (moonlander.getCurrentTime() % 60);
  if (a <= 30) {
  return a/30;
  } else {
  return (60-a)/30;
  }
}

public void draw() {
  moonlander.update();
  horizonBonus = moonlander.getIntValue("horizonBonus") - 10;
  
  drawSky();
  drawCity();
  drawGround();
  drawBall();
  drawCactuses();
  drawClouds();
}

public int WIDTH = 1280;
public int HEIGHT = 720;
public int horizonBonus = 0;
public Random rand = new Random();

public Ball B0 = new Ball(0);
public Cloud Cl0 = new Cloud(0);

public Road R0 = new Road(0);
public Road R1 = new Road(1);
public Road R2 = new Road(2);
public Road R3 = new Road(3);
public Road R4 = new Road(4);
public Road R5 = new Road(5);
public Road R6 = new Road(6);
public Road R7 = new Road(7);
public Road R8 = new Road(8);
public Road R9 = new Road(9);
public Road R10 = new Road(10);
public Road R11 = new Road(11);
public Road R12 = new Road(12);
public Road R13 = new Road(13);
public Road R14 = new Road(14);
public Road R15 = new Road(15);
public Road R16 = new Road(16);
public Road R17 = new Road(17);
public Road R18 = new Road(18);
public Road R19 = new Road(19);

public Cactus C1 = new Cactus(6);
public Cactus C2 = new Cactus(13);
public Cactus C3 = new Cactus(18);

public List<Cactus> cactusList() {
  List<Cactus> cList = new ArrayList<Cactus>();
  cList.add(C1);
  cList.add(C2);
  cList.add(C3);
  Collections.sort(cList);
  return cList;
}

public List<Road> roadList() {
  List<Road> rList = new ArrayList<Road>();
  rList.add(R0);
  rList.add(R1);
  rList.add(R2);
  rList.add(R3);
  rList.add(R4);
  rList.add(R5);
  rList.add(R6);
  rList.add(R7);
  rList.add(R8);
  rList.add(R9);
  rList.add(R10);
  rList.add(R11);
  rList.add(R12);
  rList.add(R13);
  rList.add(R14);
  rList.add(R15);
  rList.add(R16);
  rList.add(R17);
  rList.add(R18);
  rList.add(R19);
  return rList;
}


  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "NoHome" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
