/*
 * Decompiled with CFR 0.152.
 */
import ddf.minim.AudioPlayer;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PImage;
import processing.opengl.PShader;

public class odyssey
extends PApplet {
    int CANVAS_WIDTH = 1280;
    int CANVAS_HEIGHT = 720;
    Moonlander moonlander;
    AudioPlayer song;
    PImage skeletor;
    PImage texmap;
    PShader blur;
    Intro intro;
    Sperm sperm;
    Tree tree;
    Camera camera;
    Black_hole black_hole;
    int phase;
    int beat;

    public void setup() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics3D");
        this.blur = this.loadShader("blurts.glsl");
        this.frameRate(50.0f);
        this.intro = new Intro();
        this.tree = new Tree();
        this.sperm = new Sperm();
        this.camera = new Camera();
        this.black_hole = new Black_hole();
        this.skeletor = this.loadImage("Skeletor.png");
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"skeletor.mp3", (int)140, (int)4);
        this.moonlander.start();
    }

    public void draw() {
        this.moonlander.update();
        this.phase = this.moonlander.getIntValue("phase");
        this.beat = this.moonlander.getIntValue("beat");
        this.noStroke();
        if (this.phase == 1) {
            this.intro.play();
        }
        if (this.phase >= 2 && this.phase < 10) {
            this.camera.orbit();
            this.sperm.play();
        }
        if (this.phase == 99) {
            this.tint(50);
            this.background(0);
        }
        if (this.phase == 10) {
            this.camera.zoom();
            this.pointLight(255.0f, 255.0f, 255.0f, 0.0f, 500.0f, 500.0f);
            this.black_hole.play();
        }
        if (this.phase == 20) {
            this.camera.zoom();
            this.tree.play();
        }
        if (this.phase == 100) {
            this.exit();
        }
        this.lights();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "odyssey"};
        if (stringArray != null) {
            PApplet.main((String[])odyssey.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class Black_hole {
        Black_hole() {
        }

        public void play() {
            odyssey.this.background(0);
            odyssey.this.pushMatrix();
            float f = 1.0f;
            while (f < 100.0f) {
                odyssey.this.fill(f * 20.0f, 5.0f);
                if (odyssey.this.beat == 3) {
                    odyssey.this.noFill();
                    odyssey.this.stroke(180);
                }
                odyssey.this.sphere(f);
                odyssey.this.translate(0.0f, 0.0f, f / 20.0f);
                f += 2.0f;
            }
            odyssey.this.popMatrix();
        }
    }

    class Camera {
        float rotation = 0.0f;
        float ypos = 0.0f;
        float xpos = 0.0f;
        float zpos = 0.0f;
        float count = 0.0f;
        float zoom = 0.0f;

        Camera() {
        }

        public void orbit() {
            float f = 300.0f;
            float f2 = 0.0f;
            float f3 = odyssey.cos((float)odyssey.radians((float)this.rotation)) * f;
            float f4 = odyssey.sin((float)odyssey.radians((float)this.rotation)) * f;
            odyssey.this.camera(f3, f2, f4, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
            this.rotation += 1.0f;
        }

        public void stay() {
            float f = 300.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = f;
            odyssey.this.camera(f3, f2, f4, 0.0f, 0.0f, 0.0f, 0.0f, -1.0f, 0.0f);
        }

        public void zorbit() {
            float f = 200.0f;
            float f2 = 0.0f;
            float f3 = odyssey.cos((float)odyssey.radians((float)this.rotation)) * (f - this.count);
            float f4 = odyssey.sin((float)odyssey.radians((float)this.rotation)) * (f - this.count);
            this.count += 1.0f;
            odyssey.this.camera(f3, f2, f4, 0.0f, 0.0f, 0.0f, 0.0f, this.rotation, 0.0f);
            this.rotation += 1.0f;
        }

        public void zoom() {
            float f = 300.0f;
            float f2 = 0.0f;
            float f3 = 0.0f;
            float f4 = f - this.zoom;
            odyssey.this.camera(f3, f2, f4, 0.0f, 0.0f, 0.0f, 0.0f, -this.rotation, 0.0f);
            this.zoom += 1.0f;
            this.rotation += 1.0f;
        }
    }

    class Intro {
        float counter = 2.0f;
        float vallue = 1.0f;

        Intro() {
        }

        public void play() {
            odyssey.this.background(0);
            this.vallue += this.counter;
            odyssey.this.pushMatrix();
            odyssey.this.tint(this.vallue);
            odyssey.this.image(odyssey.this.skeletor, odyssey.this.CANVAS_WIDTH / 2 - 109, odyssey.this.CANVAS_HEIGHT / 2 - 130, 218.0f, 261.0f);
            odyssey.this.filter(12);
            if (this.vallue == 255.0f) {
                this.counter = -2.0f;
            }
            if (this.vallue == 0.0f) {
                this.counter = 0.0f;
            }
            odyssey.this.popMatrix();
        }
    }

    class Sperm {
        float[] coord = new float[600];

        Sperm() {
            int n = 0;
            while (n < this.coord.length) {
                this.coord[n] = 0.0f;
                odyssey.this.background(0);
                ++n;
            }
        }

        public void grow(float f) {
            odyssey.this.pushMatrix();
            int n = 0;
            while (n < this.coord.length) {
                odyssey.this.pushMatrix();
                odyssey.this.fill(10 + n % 50);
                if (f == 1.0f) {
                    odyssey.this.fill(100 + n % 50);
                }
                if (f == 2.0f) {
                    odyssey.this.fill(150 + n % 50);
                }
                if (f == 3.0f) {
                    odyssey.this.fill(200 + n % 50);
                }
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = n + n2;
                    this.coord[n3] = this.coord[n3] + odyssey.this.random(-1.0f, 1.0f);
                    ++n2;
                }
                odyssey.this.translate(this.coord[n], this.coord[n + 1], this.coord[n + 2]);
                if (odyssey.this.beat == 2) {
                    odyssey.this.fill(30);
                }
                odyssey.this.sphere(1.0f);
                odyssey.this.popMatrix();
                n += 3;
            }
            odyssey.this.popMatrix();
        }

        public void explode() {
            odyssey.this.pushMatrix();
            int n = 0;
            while (n < this.coord.length) {
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = n + n2;
                    this.coord[n3] = this.coord[n3] + this.coord[n + n2] / 50.0f;
                    ++n2;
                }
                odyssey.this.translate(this.coord[n], this.coord[n + 1], this.coord[n + 2]);
                n += 3;
            }
            odyssey.this.popMatrix();
        }

        public void play() {
            int n;
            if (odyssey.this.phase == 2 || odyssey.this.phase == 3) {
                this.grow(0.0f);
                if (odyssey.this.phase == 3) {
                    this.explode();
                }
            }
            if (odyssey.this.phase == 4) {
                n = 0;
                while (n < this.coord.length) {
                    this.coord[n] = 0.0f;
                    ++n;
                }
            }
            if (odyssey.this.phase == 8) {
                odyssey.this.background(0);
                n = 0;
                while (n < this.coord.length) {
                    this.coord[n] = 0.0f;
                    ++n;
                }
            }
            if (odyssey.this.phase == 5) {
                this.grow(1.0f);
                this.explode();
            }
            if (odyssey.this.phase == 6) {
                this.grow(2.0f);
                this.explode();
            }
            if (odyssey.this.phase == 7) {
                odyssey.this.pushMatrix();
                odyssey.this.translate(-100.0f, 0.0f, 0.0f);
                this.grow(1.0f);
                this.explode();
                odyssey.this.popMatrix();
                odyssey.this.pushMatrix();
                odyssey.this.translate(100.0f, 0.0f, 0.0f);
                this.grow(2.0f);
                this.explode();
                odyssey.this.popMatrix();
            }
            if (odyssey.this.phase == 9) {
                odyssey.this.pushMatrix();
                odyssey.this.translate(0.0f, 100.0f, 0.0f);
                this.grow(1.0f);
                this.explode();
                odyssey.this.popMatrix();
                odyssey.this.pushMatrix();
                odyssey.this.translate(0.0f, 0.0f, 100.0f);
                this.grow(2.0f);
                this.explode();
                odyssey.this.popMatrix();
                odyssey.this.pushMatrix();
                odyssey.this.translate(100.0f, 0.0f, 0.0f);
                this.grow(3.0f);
                this.explode();
                odyssey.this.popMatrix();
            }
        }
    }

    class Tree {
        float h = 180.0f;
        float c = 0.0f;
        float d = 255.0f;
        float[] coord = new float[1800];

        Tree() {
            int n = 0;
            while (n < this.coord.length) {
                this.coord[n] = 0.0f;
                odyssey.this.background(0);
                ++n;
            }
        }

        public void grow(float f) {
            odyssey.this.noStroke();
            odyssey.this.pushMatrix();
            int n = 0;
            while (n < this.coord.length) {
                odyssey.this.pushMatrix();
                odyssey.this.fill(100 + n % 50);
                int n2 = 0;
                while (n2 < 3) {
                    int n3 = n + n2;
                    this.coord[n3] = this.coord[n3] + odyssey.this.random(-2.0f, 2.0f);
                    ++n2;
                }
                n2 = 0;
                while (n2 < 3) {
                    int n4 = n + n2;
                    this.coord[n4] = this.coord[n4] + this.coord[n + n2] % 3.0f;
                    ++n2;
                }
                odyssey.this.translate(this.coord[n], this.coord[n + 1], this.coord[n + 2]);
                odyssey.this.sphere(1.0f);
                odyssey.this.popMatrix();
                n += 3;
            }
            odyssey.this.popMatrix();
        }

        public void play() {
            if (this.h == 180.0f) {
                this.c = -3.0f;
            }
            if (this.h == 0.0f) {
                this.c = 0.0f;
            }
            this.h += this.c;
            odyssey.this.fill(this.h);
            odyssey.this.sphere(65.0f);
            this.grow(0.0f);
        }
    }
}

