/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.url.ldap;

import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.toolkit.url.GenericURLDirContext;
import com.sun.jndi.url.ldap.ldapURLContextFactory;
import java.util.Hashtable;
import java.util.StringTokenizer;
import javax.naming.CompositeName;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.spi.ResolveResult;

public final class ldapURLContext
extends GenericURLDirContext {
    ldapURLContext(Hashtable hashtable) {
        super(hashtable);
    }

    @Override
    protected ResolveResult getRootURLContext(String string, Hashtable hashtable) throws NamingException {
        return ldapURLContextFactory.getUsingURLIgnoreRootDN(string, hashtable);
    }

    @Override
    protected Name getURLSuffix(String string, String string2) throws NamingException {
        LdapURL ldapURL = new LdapURL(string2);
        String string3 = ldapURL.getDN() != null ? ldapURL.getDN() : "";
        CompositeName compositeName = new CompositeName();
        if (!"".equals(string3)) {
            compositeName.add(string3);
        }
        return compositeName;
    }

    @Override
    public Object lookup(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.lookup(string);
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookup(name);
    }

    @Override
    public void bind(String string, Object object) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.bind(string, object);
    }

    @Override
    public void bind(Name name, Object object) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, object);
    }

    @Override
    public void rebind(String string, Object object) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.rebind(string, object);
    }

    @Override
    public void rebind(Name name, Object object) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, object);
    }

    @Override
    public void unbind(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.unbind(string);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.unbind(name);
    }

    @Override
    public void rename(String string, String string2) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        if (LdapURL.hasQueryComponents(string2)) {
            throw new InvalidNameException(string2);
        }
        super.rename(string, string2);
    }

    @Override
    public void rename(Name name, Name name2) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        if (LdapURL.hasQueryComponents(name2.get(0))) {
            throw new InvalidNameException(name2.toString());
        }
        super.rename(name, name2);
    }

    public NamingEnumeration list(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.list(string);
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.list(name);
    }

    public NamingEnumeration listBindings(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.listBindings(string);
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.listBindings(name);
    }

    @Override
    public void destroySubcontext(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.destroySubcontext(string);
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.destroySubcontext(name);
    }

    @Override
    public Context createSubcontext(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.createSubcontext(string);
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name);
    }

    @Override
    public Object lookupLink(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.lookupLink(string);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.lookupLink(name);
    }

    @Override
    public NameParser getNameParser(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.getNameParser(string);
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getNameParser(name);
    }

    @Override
    public String composeName(String string, String string2) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        if (LdapURL.hasQueryComponents(string2)) {
            throw new InvalidNameException(string2);
        }
        return super.composeName(string, string2);
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        if (LdapURL.hasQueryComponents(name2.get(0))) {
            throw new InvalidNameException(name2.toString());
        }
        return super.composeName(name, name2);
    }

    @Override
    public Attributes getAttributes(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.getAttributes(string);
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name);
    }

    @Override
    public Attributes getAttributes(String string, String[] stringArray) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.getAttributes(string, stringArray);
    }

    @Override
    public Attributes getAttributes(Name name, String[] stringArray) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getAttributes(name, stringArray);
    }

    @Override
    public void modifyAttributes(String string, int n, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.modifyAttributes(string, n, attributes);
    }

    @Override
    public void modifyAttributes(Name name, int n, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, n, attributes);
    }

    @Override
    public void modifyAttributes(String string, ModificationItem[] modificationItemArray) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.modifyAttributes(string, modificationItemArray);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] modificationItemArray) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.modifyAttributes(name, modificationItemArray);
    }

    @Override
    public void bind(String string, Object object, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.bind(string, object, attributes);
    }

    @Override
    public void bind(Name name, Object object, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.bind(name, object, attributes);
    }

    @Override
    public void rebind(String string, Object object, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        super.rebind(string, object, attributes);
    }

    @Override
    public void rebind(Name name, Object object, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        super.rebind(name, object, attributes);
    }

    @Override
    public DirContext createSubcontext(String string, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.createSubcontext(string, attributes);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.createSubcontext(name, attributes);
    }

    @Override
    public DirContext getSchema(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.getSchema(string);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchema(name);
    }

    @Override
    public DirContext getSchemaClassDefinition(String string) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            throw new InvalidNameException(string);
        }
        return super.getSchemaClassDefinition(string);
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.getSchemaClassDefinition(name);
    }

    public NamingEnumeration search(String string, Attributes attributes) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            return this.searchUsingURL(string);
        }
        return super.search(string, attributes);
    }

    public NamingEnumeration search(Name name, Attributes attributes) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), attributes);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, attributes);
    }

    public NamingEnumeration search(String string, Attributes attributes, String[] stringArray) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            return this.searchUsingURL(string);
        }
        return super.search(string, attributes, stringArray);
    }

    public NamingEnumeration search(Name name, Attributes attributes, String[] stringArray) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), attributes, stringArray);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, attributes, stringArray);
    }

    public NamingEnumeration search(String string, String string2, SearchControls searchControls) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            return this.searchUsingURL(string);
        }
        return super.search(string, string2, searchControls);
    }

    public NamingEnumeration search(Name name, String string, SearchControls searchControls) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), string, searchControls);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, string, searchControls);
    }

    public NamingEnumeration search(String string, String string2, Object[] objectArray, SearchControls searchControls) throws NamingException {
        if (LdapURL.hasQueryComponents(string)) {
            return this.searchUsingURL(string);
        }
        return super.search(string, string2, objectArray, searchControls);
    }

    public NamingEnumeration search(Name name, String string, Object[] objectArray, SearchControls searchControls) throws NamingException {
        if (name.size() == 1) {
            return this.search(name.get(0), string, objectArray, searchControls);
        }
        if (LdapURL.hasQueryComponents(name.get(0))) {
            throw new InvalidNameException(name.toString());
        }
        return super.search(name, string, objectArray, searchControls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NamingEnumeration searchUsingURL(String string) throws NamingException {
        LdapURL ldapURL = new LdapURL(string);
        ResolveResult resolveResult = this.getRootURLContext(string, this.myEnv);
        try (DirContext dirContext = (DirContext)resolveResult.getResolvedObj();){
            NamingEnumeration<SearchResult> namingEnumeration = dirContext.search(resolveResult.getRemainingName(), ldapURLContext.setFilterUsingURL(ldapURL), ldapURLContext.setSearchControlsUsingURL(ldapURL));
            return namingEnumeration;
        }
    }

    private static String setFilterUsingURL(LdapURL ldapURL) {
        String string = ldapURL.getFilter();
        if (string == null) {
            string = "(objectClass=*)";
        }
        return string;
    }

    private static SearchControls setSearchControlsUsingURL(LdapURL ldapURL) {
        SearchControls searchControls = new SearchControls();
        String string = ldapURL.getScope();
        String string2 = ldapURL.getAttributes();
        if (string == null) {
            searchControls.setSearchScope(0);
        } else if (string.equals("sub")) {
            searchControls.setSearchScope(2);
        } else if (string.equals("one")) {
            searchControls.setSearchScope(1);
        } else if (string.equals("base")) {
            searchControls.setSearchScope(0);
        }
        if (string2 == null) {
            searchControls.setReturningAttributes(null);
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = stringTokenizer.countTokens();
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = stringTokenizer.nextToken();
            }
            searchControls.setReturningAttributes(stringArray);
        }
        return searchControls;
    }
}

