/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Random;
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;

public class randomitology
extends PApplet {
    ArrayList<Shape> shapes = new ArrayList();
    Random random = new Random();
    Moonlander moonlander;
    int balls = 0;
    int spawnInterval = 0;
    PShape obu;
    int exitTime;
    float theta1;
    float theta2;
    int curFrameCount2;
    int curTime = 0;
    int lastTime = 0;
    int numLine = 0;
    int numDot = 1000;
    float bSize = 100.0f;
    int curFrameCount;
    int nbr_circles = 75;
    float angle_incr = (float)Math.PI * 2 / (float)this.nbr_circles;
    int dim = 0;

    public void setup() {
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"nils.mp3", (int)127, (int)1);
        this.size(600, 600, "processing.opengl.PGraphics3D");
        int n = 0;
        while (n < 60) {
            Shape shape = new Shape((int)this.random(this.width - 10), (int)this.random(this.height - 10), this.random.nextBoolean() ? -1 : 1, this.random.nextBoolean() ? -1 : 1);
            shape.active = true;
            this.shapes.add(shape);
            ++n;
        }
        this.obu = this.loadShape("PiggyBank.obj");
        this.moonlander.start();
    }

    public void draw() {
        int n = (int)this.moonlander.getValue("background_opacity");
        this.background(n);
        int n2 = this.millis();
        this.moonlander.update();
        int n3 = (int)this.moonlander.getValue("spawn_shape");
        int n4 = (int)this.moonlander.getValue("mode");
        float f = (float)this.moonlander.getValue("pig_light");
        if (n4 <= 1) {
            if (n4 == 1) {
                this.mergeMode(n4);
            }
            int n5 = 0;
            while (n5 < n3) {
                this.shapes.get(n5).Update(n2);
                this.shapes.get(n5).Draw();
                this.curFrameCount = this.frameCount;
                ++n5;
            }
        } else if (n4 == 2) {
            this.Spiral();
            this.curFrameCount2 = this.frameCount;
        } else if (n4 == 3) {
            this.colorMode(3, 1.0f);
            this.multiLines(this.curFrameCount2);
        } else if (n4 == 4) {
            this.colorMode(1, 255.0f, 255.0f, 255.0f);
            this.piggy(n, f);
            this.exitTime = this.millis();
        } else {
            this.piggy(n, f);
            if (this.millis() - this.exitTime > 10000) {
                this.exit();
            }
        }
    }

    public void piggy(int n, float f) {
        this.background(n);
        this.translate(300.0f, 366.0f, 10.0f);
        this.theta1 += 0.05f;
        this.directionalLight(230.0f, 230.0f, 0.0f, 0.0f, 0.0f, f);
        this.ambientLight(102.0f, 102.0f, 102.0f);
        this.scale(50.0f);
        this.rotateY(4.5f);
        this.rotateY((float)this.millis() * 5.0E-4f);
        this.rotateZ((float)Math.PI);
        this.shape(this.obu);
    }

    public void multiLines(int n) {
        int n2;
        int n3;
        float f;
        float f2;
        float f3;
        float f4;
        float f5;
        float f6;
        float f7;
        float f8;
        int n4 = this.frameCount - n;
        this.background(0);
        this.curTime = this.millis();
        if (this.curTime - this.lastTime > 1000 && this.numLine < 10) {
            ++this.numLine;
            this.lastTime = this.curTime;
        }
        int n5 = 0;
        while (n5 < this.numLine) {
            f8 = (float)n4 * 0.001f + 0.1f;
            f7 = f8 * (float)n5;
            f7 = (float)((double)f7 - Math.floor(f7));
            this.fill(f7 - this.noise((float)n5 / 1.5f), 100.0f - this.noise((float)n5 / 0.1f), 100.0f * this.noise((float)n5 / 0.5f));
            this.beginShape();
            this.stroke(155.0f, 0.0f, 255.0f);
            f6 = this.noise((float)n5 / 10.0f) + 0.5f;
            f5 = this.noise((float)n5 / 7.0f);
            f4 = this.noise((float)n5 / 1.3f) + 0.5f;
            f3 = this.noise((float)n5 / 1.2f, (float)n4 / 500.0f);
            f2 = this.noise((float)n5 / 5.0f);
            f = this.noise((float)n5 / 1.8f) + 0.9f;
            n3 = (int)this.bSize;
            n2 = 0;
            while (n2 < this.numDot) {
                this.ellipse(n2, (float)(this.height / 2) + 800.0f * f3 * randomitology.sin((float)(f6 * ((float)Math.PI * 2) * (float)n2 / 600.0f + 100.0f * f5 - (float)n4 / (100.0f * f4) + 150.0f * f2 * 100.0f * f)), this.bSize, this.bSize);
                n2 += PApplet.parseInt((float)n3);
            }
            this.endShape();
            ++n5;
        }
        if ((float)this.numLine == 10.0f && this.bSize > 1.5f) {
            this.bSize -= 0.2f;
        }
        n5 = 0;
        while (n5 < this.numLine) {
            f8 = (float)n4 * 0.001f + 0.1f;
            f7 = f8 * (float)n5;
            f7 = (float)((double)f7 - Math.floor(f7));
            this.fill(0.0f, 0.0f, 0.0f);
            this.beginShape();
            this.noStroke();
            f6 = this.noise((float)n5 / 10.0f) + 0.5f;
            f5 = this.noise((float)n5 / 7.0f);
            f4 = this.noise((float)n5 / 1.3f) + 0.5f;
            f3 = this.noise((float)n5 / 1.2f, (float)n4 / 500.0f);
            f2 = this.noise((float)n5 / 5.0f);
            f = this.noise((float)n5 / 1.8f) + 0.9f;
            n3 = (int)this.bSize;
            n2 = 0;
            while (n2 < this.numDot) {
                this.ellipse(n2, (float)(this.height / 2) + 800.0f * f3 * randomitology.sin((float)(f6 * ((float)Math.PI * 2) * (float)n2 / 600.0f + 100.0f * f5 - (float)n4 / (100.0f * f4) + 150.0f * f2 * 100.0f * f)), this.bSize, this.bSize);
                n2 += PApplet.parseInt((float)n3);
            }
            this.endShape();
            ++n5;
        }
    }

    public void drawSpiral(int n, int n2) {
        this.fill(n);
        this.millis();
        float f = randomitology.radians((float)(2.0f + (float)(this.frameCount - n2) / 16.0f));
        float f2 = this.width / 2;
        float f3 = this.height / 2;
        float f4 = (float)this.width * 0.45f;
        float f5 = this.dim;
        int n3 = 1;
        while (n3 <= this.nbr_circles) {
            float f6 = (float)n3 / (float)this.nbr_circles;
            float f7 = f6 * f4;
            float f8 = (float)n3 * f;
            float f9 = f2 + randomitology.cos((float)f8) * f7;
            float f10 = f3 + randomitology.sin((float)f8) * f7;
            this.ellipse(f9, f10, f5, f5);
            ++n3;
        }
    }

    public void Spiral() {
        this.dim += 4;
        this.stroke(2);
        this.strokeWeight(1.0f);
        this.drawSpiral(255, this.curFrameCount);
    }

    public void mergeMode(int n) {
        CONFIG.MERGE = true;
        CONFIG.VELOCITY = n * 2;
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "randomitology"};
        if (stringArray != null) {
            PApplet.main((String[])randomitology.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    static class CONFIG {
        public static boolean MERGE = false;
        public static int VELOCITY = 2;

        CONFIG() {
        }
    }

    class PointXY {
        float x;
        float y;
        int c;

        PointXY(float f, float f2, int n) {
            this.x = f;
            this.y = f2;
            this.c = n;
        }
    }

    class Shape {
        float x;
        float y;
        float velocity;
        float xSign;
        float ySign;
        int size;
        int maxSize;
        boolean active;
        int curColor;
        LinkedList<PointXY> trailPoints;

        Shape(int n, int n2, int n3, int n4) {
            this.x = n;
            this.y = n2;
            this.xSign = n3;
            this.ySign = n4;
            this.colorPicker();
            this.maxSize = (int)randomitology.this.random(10.0f, 20.0f);
            this.size = 0;
            this.active = true;
            this.trailPoints = new LinkedList();
        }

        public void Draw() {
            int n = this.trailPoints.size() - 1;
            while (n >= 0) {
                randomitology.this.noStroke();
                randomitology.this.fill(this.trailPoints.get((int)n).c, 150 - n * 5);
                randomitology.this.ellipse(this.trailPoints.get((int)n).x, this.trailPoints.get((int)n).y, this.size, this.size);
                --n;
            }
        }

        public void Update(int n) {
            this.CollisionCheck();
            if (this.size < this.maxSize) {
                this.size += 10;
            } else if (this.size > this.maxSize) {
                this.size -= 10;
            }
            this.x += this.xSign * randomitology.this.noise(this.x * (float)randomitology.this.frameCount) * 1.8f * (float)CONFIG.VELOCITY;
            this.y += this.ySign * randomitology.this.noise(this.y * (float)randomitology.this.frameCount) * 1.8f * (float)CONFIG.VELOCITY;
            if (!CONFIG.MERGE && this.trailPoints.size() > 50) {
                this.trailPoints.removeLast();
            } else if (CONFIG.MERGE) {
                this.trailPoints.clear();
            }
            this.trailPoints.addFirst(new PointXY(this.x, this.y, this.curColor));
        }

        public void CollisionCheck() {
            int n = 0;
            while (n < randomitology.this.shapes.size()) {
                if (randomitology.this.shapes.get(n) != this && randomitology.this.shapes.get((int)n).active) {
                    Shape shape = randomitology.this.shapes.get(n);
                    float f = randomitology.dist((float)this.x, (float)this.y, (float)shape.x, (float)shape.y);
                    float f2 = f - (float)((this.size + shape.size) / 2);
                    if (f2 < 0.0f) {
                        if (!CONFIG.MERGE) {
                            shape.xSign *= -1.0f;
                            shape.ySign *= -1.0f;
                            this.xSign *= -1.0f;
                            this.ySign *= -1.0f;
                        } else if (this.size >= shape.size) {
                            this.maxSize += shape.size;
                            shape.maxSize = 0;
                        } else {
                            shape.maxSize += this.size;
                            this.maxSize = 0;
                        }
                        if (shape.curColor != this.curColor) {
                            shape.curColor = this.curColor;
                        }
                    }
                }
                ++n;
            }
            if (this.y - (float)(this.size / 2) <= 0.0f) {
                this.ySign = 1.0f;
                this.colorPicker();
            } else if (this.y + (float)(this.size / 2) >= (float)randomitology.this.height) {
                this.ySign = -1.0f;
                this.colorPicker();
            }
            if (this.x - (float)(this.size / 2) <= 0.0f) {
                this.xSign = 1.0f;
                this.colorPicker();
            } else if (this.x + (float)(this.size / 2) >= (float)randomitology.this.width) {
                this.xSign = -1.0f;
                this.colorPicker();
            }
        }

        private void colorPicker() {
            int n = (int)randomitology.this.random(1.0f, 4.0f);
            switch (n) {
                case 1: {
                    this.curColor = randomitology.this.color(randomitology.this.random(100.0f, 255.0f), 0.0f, 0.0f);
                    break;
                }
                case 2: {
                    this.curColor = randomitology.this.color(0.0f, randomitology.this.random(100.0f, 255.0f), 0.0f);
                    break;
                }
                case 3: {
                    this.curColor = randomitology.this.color(0.0f, 0.0f, randomitology.this.random(100.0f, 255.0f));
                }
            }
        }
    }
}

