/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.trax;

import com.sun.org.apache.xalan.internal.xsltc.dom.SAXImpl;
import java.io.IOException;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.AttributesImpl;

public class StAXEvent2SAX
implements XMLReader,
Locator {
    private final XMLEventReader staxEventReader;
    private ContentHandler _sax = null;
    private LexicalHandler _lex = null;
    private SAXImpl _saxImpl = null;
    private String version = null;
    private String encoding = null;

    public StAXEvent2SAX(XMLEventReader xMLEventReader) {
        this.staxEventReader = xMLEventReader;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._sax;
    }

    @Override
    public void setContentHandler(ContentHandler contentHandler) throws NullPointerException {
        this._sax = contentHandler;
        if (contentHandler instanceof LexicalHandler) {
            this._lex = (LexicalHandler)((Object)contentHandler);
        }
        if (contentHandler instanceof SAXImpl) {
            this._saxImpl = (SAXImpl)contentHandler;
        }
    }

    @Override
    public void parse(InputSource inputSource) throws IOException, SAXException {
        try {
            this.bridge();
        }
        catch (XMLStreamException xMLStreamException) {
            throw new SAXException(xMLStreamException);
        }
    }

    public void parse() throws IOException, SAXException, XMLStreamException {
        this.bridge();
    }

    private void bridge() throws XMLStreamException {
        try {
            int n = 0;
            boolean bl = false;
            XMLEvent xMLEvent = this.staxEventReader.peek();
            if (!xMLEvent.isStartDocument() && !xMLEvent.isStartElement()) {
                throw new IllegalStateException();
            }
            if (xMLEvent.getEventType() == 7) {
                bl = true;
                this.version = ((StartDocument)xMLEvent).getVersion();
                if (((StartDocument)xMLEvent).encodingSet()) {
                    this.encoding = ((StartDocument)xMLEvent).getCharacterEncodingScheme();
                }
                xMLEvent = this.staxEventReader.nextEvent();
                xMLEvent = this.staxEventReader.nextEvent();
            }
            this.handleStartDocument(xMLEvent);
            while (xMLEvent.getEventType() != 1) {
                switch (xMLEvent.getEventType()) {
                    case 4: {
                        this.handleCharacters(xMLEvent.asCharacters());
                        break;
                    }
                    case 3: {
                        this.handlePI((ProcessingInstruction)xMLEvent);
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing prolog event: " + xMLEvent);
                    }
                }
                xMLEvent = this.staxEventReader.nextEvent();
            }
            do {
                switch (xMLEvent.getEventType()) {
                    case 1: {
                        ++n;
                        this.handleStartElement(xMLEvent.asStartElement());
                        break;
                    }
                    case 2: {
                        this.handleEndElement(xMLEvent.asEndElement());
                        --n;
                        break;
                    }
                    case 4: {
                        this.handleCharacters(xMLEvent.asCharacters());
                        break;
                    }
                    case 9: {
                        this.handleEntityReference();
                        break;
                    }
                    case 3: {
                        this.handlePI((ProcessingInstruction)xMLEvent);
                        break;
                    }
                    case 5: {
                        this.handleComment();
                        break;
                    }
                    case 11: {
                        this.handleDTD();
                        break;
                    }
                    case 10: {
                        this.handleAttribute();
                        break;
                    }
                    case 13: {
                        this.handleNamespace();
                        break;
                    }
                    case 12: {
                        this.handleCDATA();
                        break;
                    }
                    case 15: {
                        this.handleEntityDecl();
                        break;
                    }
                    case 14: {
                        this.handleNotationDecl();
                        break;
                    }
                    case 6: {
                        this.handleSpace();
                        break;
                    }
                    default: {
                        throw new InternalError("processing event: " + xMLEvent);
                    }
                }
                xMLEvent = this.staxEventReader.nextEvent();
            } while (n != 0);
            if (bl) {
                while (xMLEvent.getEventType() != 8) {
                    switch (xMLEvent.getEventType()) {
                        case 4: {
                            this.handleCharacters(xMLEvent.asCharacters());
                            break;
                        }
                        case 3: {
                            this.handlePI((ProcessingInstruction)xMLEvent);
                            break;
                        }
                        case 5: {
                            this.handleComment();
                            break;
                        }
                        case 6: {
                            this.handleSpace();
                            break;
                        }
                        default: {
                            throw new InternalError("processing misc event after document element: " + xMLEvent);
                        }
                    }
                    xMLEvent = this.staxEventReader.nextEvent();
                }
            }
            this.handleEndDocument();
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleEndDocument() throws SAXException {
        this._sax.endDocument();
    }

    private void handleStartDocument(final XMLEvent xMLEvent) throws SAXException {
        this._sax.setDocumentLocator(new Locator2(){

            @Override
            public int getColumnNumber() {
                return xMLEvent.getLocation().getColumnNumber();
            }

            @Override
            public int getLineNumber() {
                return xMLEvent.getLocation().getLineNumber();
            }

            @Override
            public String getPublicId() {
                return xMLEvent.getLocation().getPublicId();
            }

            @Override
            public String getSystemId() {
                return xMLEvent.getLocation().getSystemId();
            }

            @Override
            public String getXMLVersion() {
                return StAXEvent2SAX.this.version;
            }

            @Override
            public String getEncoding() {
                return StAXEvent2SAX.this.encoding;
            }
        });
        this._sax.startDocument();
    }

    private void handlePI(ProcessingInstruction processingInstruction) throws XMLStreamException {
        try {
            this._sax.processingInstruction(processingInstruction.getTarget(), processingInstruction.getData());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleCharacters(Characters characters) throws XMLStreamException {
        try {
            this._sax.characters(characters.getData().toCharArray(), 0, characters.getData().length());
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleEndElement(EndElement endElement) throws XMLStreamException {
        QName qName = endElement.getName();
        String string = "";
        if (qName.getPrefix() != null && qName.getPrefix().trim().length() != 0) {
            string = qName.getPrefix() + ":";
        }
        string = string + qName.getLocalPart();
        try {
            this._sax.endElement(qName.getNamespaceURI(), qName.getLocalPart(), string);
            Iterator iterator = endElement.getNamespaces();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                if (string2 == null) {
                    string2 = "";
                }
                this._sax.endPrefixMapping(string2);
            }
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private void handleStartElement(StartElement startElement) throws XMLStreamException {
        try {
            String string;
            Object object = startElement.getNamespaces();
            while (object.hasNext()) {
                string = ((Namespace)object.next()).getPrefix();
                if (string == null) {
                    string = "";
                }
                this._sax.startPrefixMapping(string, startElement.getNamespaceURI(string));
            }
            object = startElement.getName();
            string = ((QName)object).getPrefix();
            String string2 = string == null || string.length() == 0 ? ((QName)object).getLocalPart() : string + ':' + ((QName)object).getLocalPart();
            Attributes attributes = this.getAttributes(startElement);
            this._sax.startElement(((QName)object).getNamespaceURI(), ((QName)object).getLocalPart(), string2, attributes);
        }
        catch (SAXException sAXException) {
            throw new XMLStreamException(sAXException);
        }
    }

    private Attributes getAttributes(StartElement startElement) {
        AttributesImpl attributesImpl = new AttributesImpl();
        if (!startElement.isStartElement()) {
            throw new InternalError("getAttributes() attempting to process: " + startElement);
        }
        Iterator iterator = startElement.getAttributes();
        while (iterator.hasNext()) {
            Attribute attribute = (Attribute)iterator.next();
            String string = attribute.getName().getNamespaceURI();
            if (string == null) {
                string = "";
            }
            String string2 = attribute.getName().getLocalPart();
            String string3 = attribute.getName().getPrefix();
            String string4 = string3 == null || string3.length() == 0 ? string2 : string3 + ':' + string2;
            String string5 = attribute.getDTDType();
            String string6 = attribute.getValue();
            attributesImpl.addAttribute(string, string2, string4, string5, string6);
        }
        return attributesImpl;
    }

    private void handleNamespace() {
    }

    private void handleAttribute() {
    }

    private void handleDTD() {
    }

    private void handleComment() {
    }

    private void handleEntityReference() {
    }

    private void handleSpace() {
    }

    private void handleNotationDecl() {
    }

    private void handleEntityDecl() {
    }

    private void handleCDATA() {
    }

    @Override
    public DTDHandler getDTDHandler() {
        return null;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return null;
    }

    @Override
    public boolean getFeature(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    @Override
    public void setFeature(String string, boolean bl) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public void parse(String string) throws IOException, SAXException {
        throw new IOException("This method is not yet implemented.");
    }

    @Override
    public void setDTDHandler(DTDHandler dTDHandler) throws NullPointerException {
    }

    @Override
    public void setEntityResolver(EntityResolver entityResolver) throws NullPointerException {
    }

    @Override
    public EntityResolver getEntityResolver() {
        return null;
    }

    @Override
    public void setErrorHandler(ErrorHandler errorHandler) throws NullPointerException {
    }

    @Override
    public void setProperty(String string, Object object) throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    @Override
    public Object getProperty(String string) throws SAXNotRecognizedException, SAXNotSupportedException {
        return null;
    }

    @Override
    public int getColumnNumber() {
        return 0;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public String getPublicId() {
        return null;
    }

    @Override
    public String getSystemId() {
        return null;
    }
}

