/*
 * Decompiled with CFR 0.152.
 */
package com.sun.java.swing.plaf.windows;

import com.sun.java.swing.plaf.windows.TMSchema;
import com.sun.java.swing.plaf.windows.XPStyle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class WindowsSliderUI
extends BasicSliderUI {
    private boolean rollover = false;
    private boolean pressed = false;

    public WindowsSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new WindowsSliderUI((JSlider)jComponent);
    }

    @Override
    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new WindowsTrackListener();
    }

    @Override
    public void paintTrack(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            boolean bl = this.slider.getOrientation() == 1;
            TMSchema.Part part = bl ? TMSchema.Part.TKP_TRACKVERT : TMSchema.Part.TKP_TRACK;
            XPStyle.Skin skin = xPStyle.getSkin(this.slider, part);
            if (bl) {
                int n = (this.trackRect.width - skin.getWidth()) / 2;
                skin.paintSkin(graphics, this.trackRect.x + n, this.trackRect.y, skin.getWidth(), this.trackRect.height, null);
            } else {
                int n = (this.trackRect.height - skin.getHeight()) / 2;
                skin.paintSkin(graphics, this.trackRect.x, this.trackRect.y + n, this.trackRect.width, skin.getHeight(), null);
            }
        } else {
            super.paintTrack(graphics);
        }
    }

    @Override
    protected void paintMinorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor(this.slider, TMSchema.Part.TKP_TICS, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMinorTickForHorizSlider(graphics, rectangle, n);
    }

    @Override
    protected void paintMajorTickForHorizSlider(Graphics graphics, Rectangle rectangle, int n) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor(this.slider, TMSchema.Part.TKP_TICS, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMajorTickForHorizSlider(graphics, rectangle, n);
    }

    @Override
    protected void paintMinorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor(this.slider, TMSchema.Part.TKP_TICSVERT, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMinorTickForVertSlider(graphics, rectangle, n);
    }

    @Override
    protected void paintMajorTickForVertSlider(Graphics graphics, Rectangle rectangle, int n) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            graphics.setColor(xPStyle.getColor(this.slider, TMSchema.Part.TKP_TICSVERT, null, TMSchema.Prop.COLOR, Color.black));
        }
        super.paintMajorTickForVertSlider(graphics, rectangle, n);
    }

    @Override
    public void paintThumb(Graphics graphics) {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            TMSchema.Part part = this.getXPThumbPart();
            TMSchema.State state = TMSchema.State.NORMAL;
            if (this.slider.hasFocus()) {
                state = TMSchema.State.FOCUSED;
            }
            if (this.rollover) {
                state = TMSchema.State.HOT;
            }
            if (this.pressed) {
                state = TMSchema.State.PRESSED;
            }
            if (!this.slider.isEnabled()) {
                state = TMSchema.State.DISABLED;
            }
            xPStyle.getSkin(this.slider, part).paintSkin(graphics, this.thumbRect.x, this.thumbRect.y, state);
        } else {
            super.paintThumb(graphics);
        }
    }

    @Override
    protected Dimension getThumbSize() {
        XPStyle xPStyle = XPStyle.getXP();
        if (xPStyle != null) {
            Dimension dimension = new Dimension();
            XPStyle.Skin skin = xPStyle.getSkin(this.slider, this.getXPThumbPart());
            dimension.width = skin.getWidth();
            dimension.height = skin.getHeight();
            return dimension;
        }
        return super.getThumbSize();
    }

    private TMSchema.Part getXPThumbPart() {
        XPStyle xPStyle = XPStyle.getXP();
        boolean bl = this.slider.getOrientation() == 1;
        boolean bl2 = this.slider.getComponentOrientation().isLeftToRight();
        Boolean bl3 = (Boolean)this.slider.getClientProperty("Slider.paintThumbArrowShape");
        TMSchema.Part part = !this.slider.getPaintTicks() && bl3 == null || bl3 == Boolean.FALSE ? (bl ? TMSchema.Part.TKP_THUMBVERT : TMSchema.Part.TKP_THUMB) : (bl ? (bl2 ? TMSchema.Part.TKP_THUMBRIGHT : TMSchema.Part.TKP_THUMBLEFT) : TMSchema.Part.TKP_THUMBBOTTOM);
        return part;
    }

    private class WindowsTrackListener
    extends BasicSliderUI.TrackListener {
        private WindowsTrackListener() {
            super(WindowsSliderUI.this);
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            this.updateRollover(WindowsSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY()));
            super.mouseMoved(mouseEvent);
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            this.updateRollover(WindowsSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY()));
            super.mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            this.updateRollover(false);
            super.mouseExited(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.updatePressed(WindowsSliderUI.this.thumbRect.contains(mouseEvent.getX(), mouseEvent.getY()));
            super.mousePressed(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.updatePressed(false);
            super.mouseReleased(mouseEvent);
        }

        public void updatePressed(boolean bl) {
            if (!WindowsSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (WindowsSliderUI.this.pressed != bl) {
                WindowsSliderUI.this.pressed = bl;
                WindowsSliderUI.this.slider.repaint(WindowsSliderUI.this.thumbRect);
            }
        }

        public void updateRollover(boolean bl) {
            if (!WindowsSliderUI.this.slider.isEnabled()) {
                return;
            }
            if (WindowsSliderUI.this.rollover != bl) {
                WindowsSliderUI.this.rollover = bl;
                WindowsSliderUI.this.slider.repaint(WindowsSliderUI.this.thumbRect);
            }
        }
    }
}

