/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Hashtable;
import sun.awt.FontConfiguration;
import sun.awt.FontDescriptor;
import sun.awt.windows.WDefaultFontCharset;
import sun.font.SunFontManager;

public class WFontConfiguration
extends FontConfiguration {
    private boolean useCompatibilityFallbacks = "windows-1252".equals(encoding);
    private static HashMap subsetCharsetMap = new HashMap();
    private static HashMap subsetEncodingMap = new HashMap();
    private static String textInputCharset;

    public WFontConfiguration(SunFontManager sunFontManager) {
        super(sunFontManager);
        this.initTables(encoding);
    }

    public WFontConfiguration(SunFontManager sunFontManager, boolean bl, boolean bl2) {
        super(sunFontManager, bl, bl2);
    }

    @Override
    protected void initReorderMap() {
        if (encoding.equalsIgnoreCase("windows-31j")) {
            localeMap = new Hashtable();
            localeMap.put("dialoginput.plain.japanese", "MS Mincho");
            localeMap.put("dialoginput.bold.japanese", "MS Mincho");
            localeMap.put("dialoginput.italic.japanese", "MS Mincho");
            localeMap.put("dialoginput.bolditalic.japanese", "MS Mincho");
        }
        this.reorderMap = new HashMap();
        this.reorderMap.put("UTF-8.hi", "devanagari");
        this.reorderMap.put("windows-1255", "hebrew");
        this.reorderMap.put("x-windows-874", "thai");
        this.reorderMap.put("windows-31j", "japanese");
        this.reorderMap.put("x-windows-949", "korean");
        this.reorderMap.put("GBK", "chinese-ms936");
        this.reorderMap.put("GB18030", "chinese-gb18030");
        this.reorderMap.put("x-windows-950", "chinese-ms950");
        this.reorderMap.put("x-MS950-HKSCS", this.split("chinese-ms950,chinese-hkscs"));
    }

    @Override
    protected void setOsNameAndVersion() {
        super.setOsNameAndVersion();
        if (osName.startsWith("Windows")) {
            int n;
            int n2 = osName.indexOf(32);
            osName = n2 == -1 ? null : ((n = osName.indexOf(32, n2 + 1)) == -1 ? osName.substring(n2 + 1) : osName.substring(n2 + 1, n));
            osVersion = null;
        }
    }

    @Override
    public String getFallbackFamilyName(String string, String string2) {
        String string3;
        if (this.useCompatibilityFallbacks && (string3 = this.getCompatibilityFamilyName(string)) != null) {
            return string3;
        }
        return string2;
    }

    @Override
    protected String makeAWTFontName(String string, String string2) {
        String string3 = (String)subsetCharsetMap.get(string2);
        if (string3 == null) {
            string3 = "DEFAULT_CHARSET";
        }
        return string + "," + string3;
    }

    @Override
    protected String getEncoding(String string, String string2) {
        String string3 = (String)subsetEncodingMap.get(string2);
        if (string3 == null) {
            string3 = "default";
        }
        return string3;
    }

    @Override
    protected Charset getDefaultFontCharset(String string) {
        return new WDefaultFontCharset(string);
    }

    @Override
    public String getFaceNameFromComponentFontName(String string) {
        return string;
    }

    @Override
    protected String getFileNameFromComponentFontName(String string) {
        return this.getFileNameFromPlatformName(string);
    }

    public String getTextComponentFontName(String string, int n) {
        FontDescriptor[] fontDescriptorArray = this.getFontDescriptors(string, n);
        String string2 = this.findFontWithCharset(fontDescriptorArray, textInputCharset);
        if (string2 == null) {
            string2 = this.findFontWithCharset(fontDescriptorArray, "DEFAULT_CHARSET");
        }
        return string2;
    }

    private String findFontWithCharset(FontDescriptor[] fontDescriptorArray, String string) {
        String string2 = null;
        for (int i = 0; i < fontDescriptorArray.length; ++i) {
            String string3 = fontDescriptorArray[i].getNativeName();
            if (!string3.endsWith(string)) continue;
            string2 = string3;
        }
        return string2;
    }

    private void initTables(String string) {
        subsetCharsetMap.put("alphabetic", "ANSI_CHARSET");
        subsetCharsetMap.put("alphabetic/1252", "ANSI_CHARSET");
        subsetCharsetMap.put("alphabetic/default", "DEFAULT_CHARSET");
        subsetCharsetMap.put("arabic", "ARABIC_CHARSET");
        subsetCharsetMap.put("chinese-ms936", "GB2312_CHARSET");
        subsetCharsetMap.put("chinese-gb18030", "GB2312_CHARSET");
        subsetCharsetMap.put("chinese-ms950", "CHINESEBIG5_CHARSET");
        subsetCharsetMap.put("chinese-hkscs", "CHINESEBIG5_CHARSET");
        subsetCharsetMap.put("cyrillic", "RUSSIAN_CHARSET");
        subsetCharsetMap.put("devanagari", "DEFAULT_CHARSET");
        subsetCharsetMap.put("dingbats", "SYMBOL_CHARSET");
        subsetCharsetMap.put("greek", "GREEK_CHARSET");
        subsetCharsetMap.put("hebrew", "HEBREW_CHARSET");
        subsetCharsetMap.put("japanese", "SHIFTJIS_CHARSET");
        subsetCharsetMap.put("korean", "HANGEUL_CHARSET");
        subsetCharsetMap.put("latin", "ANSI_CHARSET");
        subsetCharsetMap.put("symbol", "SYMBOL_CHARSET");
        subsetCharsetMap.put("thai", "THAI_CHARSET");
        subsetEncodingMap.put("alphabetic", "default");
        subsetEncodingMap.put("alphabetic/1252", "windows-1252");
        subsetEncodingMap.put("alphabetic/default", string);
        subsetEncodingMap.put("arabic", "windows-1256");
        subsetEncodingMap.put("chinese-ms936", "GBK");
        subsetEncodingMap.put("chinese-gb18030", "GB18030");
        if ("x-MS950-HKSCS".equals(string)) {
            subsetEncodingMap.put("chinese-ms950", "x-MS950-HKSCS");
        } else {
            subsetEncodingMap.put("chinese-ms950", "x-windows-950");
        }
        subsetEncodingMap.put("chinese-hkscs", "sun.awt.HKSCS");
        subsetEncodingMap.put("cyrillic", "windows-1251");
        subsetEncodingMap.put("devanagari", "UTF-16LE");
        subsetEncodingMap.put("dingbats", "sun.awt.windows.WingDings");
        subsetEncodingMap.put("greek", "windows-1253");
        subsetEncodingMap.put("hebrew", "windows-1255");
        subsetEncodingMap.put("japanese", "windows-31j");
        subsetEncodingMap.put("korean", "x-windows-949");
        subsetEncodingMap.put("latin", "windows-1252");
        subsetEncodingMap.put("symbol", "sun.awt.Symbol");
        subsetEncodingMap.put("thai", "x-windows-874");
        textInputCharset = "windows-1256".equals(string) ? "ARABIC_CHARSET" : ("GBK".equals(string) ? "GB2312_CHARSET" : ("GB18030".equals(string) ? "GB2312_CHARSET" : ("x-windows-950".equals(string) ? "CHINESEBIG5_CHARSET" : ("x-MS950-HKSCS".equals(string) ? "CHINESEBIG5_CHARSET" : ("windows-1251".equals(string) ? "RUSSIAN_CHARSET" : ("UTF-8".equals(string) ? "DEFAULT_CHARSET" : ("windows-1253".equals(string) ? "GREEK_CHARSET" : ("windows-1255".equals(string) ? "HEBREW_CHARSET" : ("windows-31j".equals(string) ? "SHIFTJIS_CHARSET" : ("x-windows-949".equals(string) ? "HANGEUL_CHARSET" : ("x-windows-874".equals(string) ? "THAI_CHARSET" : "DEFAULT_CHARSET")))))))))));
    }
}

