/*
 * Decompiled with CFR 0.152.
 */
import moonlander.library.Moonlander;
import processing.core.PApplet;
import processing.core.PShape;
import processing.core.PVector;

public class stickman
extends PApplet {
    int CANVAS_WIDTH = 1000;
    int CANVAS_HEIGHT = 600;
    int ground_y = this.CANVAS_HEIGHT - (int)((float)this.CANVAS_HEIGHT * 0.05f);
    Moonlander moonlander;
    float[] x_index;
    float[] y_index;
    int INTENSITY = 100;
    int relative_mov = 0;
    int init_rain = 0;
    StickMan man1;
    StickMan man2;
    int bg_red = 135;
    int bg_green = 206;
    int bg_blue = 250;
    int renderTree2 = 1;
    int renderFire = 0;
    int renderFire2 = 0;
    int renderRain = 0;
    int currSceneStage = 0;
    int prevTimeMarker = 0;
    int renderLightning = 0;
    PVector tree1Loc = new PVector(100.0f, (float)this.ground_y, 0.0f);
    PVector tree2Loc = new PVector((float)(this.CANVAS_WIDTH / 2), (float)this.ground_y, 0.0f);
    PVector fireLoc = new PVector((float)(this.CANVAS_WIDTH / 2), (float)this.ground_y, 0.6f);
    PVector cloudLoc = new PVector(200.0f, 100.0f, 0.5f);
    int woodColor = this.color(139, 69, 19, 255);
    int rain_g = this.ground_y;
    int lightningCount = 0;

    public void draw_lightning(PVector pVector, PVector pVector2) {
        this.stroke(255);
        this.strokeWeight(8.0f);
        PVector pVector3 = new PVector(pVector.x, pVector.y);
        PVector pVector4 = new PVector(pVector.x, pVector.y);
        boolean bl = false;
        int n = 0;
        while (!bl) {
            float f;
            float f2;
            float f3 = pVector2.x > pVector3.x ? stickman.degrees((float)stickman.atan((float)((pVector2.y - pVector3.y) / (pVector2.x - pVector3.x)))) : 180.0f - stickman.degrees((float)stickman.atan((float)((pVector2.y - pVector3.y) / (pVector3.x - pVector2.x))));
            if (n % 2 == 0) {
                f2 = this.random(30.0f, 150.0f);
                f = this.random(5.0f, 10.0f);
            } else {
                f2 = this.random(f3 - 5.0f, f3 + 5.0f);
                f = this.random(15.0f, stickman.min((float)pVector2.dist(pVector3), (float)100.0f));
            }
            pVector4.set(pVector3.x + f * stickman.cos((float)stickman.radians((float)f2)), pVector3.y + f * stickman.sin((float)stickman.radians((float)f2)));
            this.line(pVector3.x, pVector3.y, pVector4.x, pVector4.y);
            pVector3.x = pVector4.x;
            pVector3.y = pVector4.y;
            if (pVector4.dist(pVector2) < 20.0f || pVector4.y >= (float)this.ground_y) {
                bl = true;
            }
            ++n;
        }
        this.strokeWeight(1.0f);
        this.noStroke();
    }

    public void draw_cloud(PVector pVector) {
        this.noStroke();
        this.fill(255);
        this.pushMatrix();
        this.translate(pVector.x, pVector.y);
        this.scale(pVector.z);
        this.ellipse(100.0f, 100.0f, 100.0f, 100.0f);
        this.ellipse(50.0f, 100.0f, 100.0f, 100.0f);
        this.ellipse(150.0f, 100.0f, 100.0f, 100.0f);
        this.ellipse(200.0f, 100.0f, 130.0f, 100.0f);
        this.ellipse(50.0f, 50.0f, 100.0f, 70.0f);
        this.ellipse(150.0f, 50.0f, 130.0f, 70.0f);
        this.popMatrix();
    }

    public void let_it_rain(PVector pVector, int n) {
        int n2;
        this.relative_mov = (int)pVector.x;
        int n3 = this.color(255, 255, 255, 128);
        this.fill(n3);
        if (this.init_rain == 0) {
            this.x_index = new float[this.INTENSITY];
            this.y_index = new float[this.INTENSITY];
            n2 = 0;
            while (n2 < this.INTENSITY) {
                this.x_index[n2] = this.random(pVector.x, pVector.x + 250.0f * pVector.z);
                this.y_index[n2] = this.random(pVector.y, n);
                ++n2;
            }
            this.init_rain = 1;
        }
        n2 = 0;
        while (n2 < this.INTENSITY) {
            this.ellipse(this.x_index[n2], this.y_index[n2], 2.0f, 4.0f);
            this.y_index[n2] = this.y_index[n2] + 10.0f;
            int n4 = n2;
            this.x_index[n4] = this.x_index[n4] + 1.0f;
            if (this.y_index[n2] >= (float)n) {
                this.x_index[n2] = (float)this.relative_mov + this.random(250.0f * pVector.z);
                this.y_index[n2] = pVector.y;
            }
            ++n2;
        }
    }

    public void tree(PVector pVector) {
        this.stroke(0);
        float f = 20.0f;
        this.pushMatrix();
        float f2 = stickman.radians((float)f);
        this.translate(pVector.x, pVector.y);
        this.rotate(pVector.z);
        this.fill(139.0f, 69.0f, 19.0f);
        this.rect(-1.0f, 0.0f, 4.0f, -120.0f);
        this.translate(0.0f, -120.0f);
        this.branch(80.0f, f2);
        this.popMatrix();
    }

    public void ground() {
        this.fill(124.0f, 252.0f, 0.0f);
        this.rect(0.0f, (float)this.height - (float)this.height * 0.05f, this.width, (float)this.height * 0.05f);
    }

    public void branch(float f, float f2) {
        if ((f *= 0.66f) > 2.0f) {
            this.pushMatrix();
            this.rotate(f2);
            this.fill(0.0f, 255.0f, 0.0f);
            this.rect(0.0f, 0.0f, 2.0f, -f);
            this.translate(0.0f, -f);
            this.branch(f, f2);
            this.popMatrix();
            this.pushMatrix();
            this.rotate(-f2);
            this.rect(0.0f, 0.0f, 2.0f, -f);
            this.translate(0.0f, -f);
            this.branch(f, f2);
            this.popMatrix();
        }
    }

    public void fire(PVector pVector) {
        this.pushMatrix();
        this.translate(pVector.x, pVector.y);
        this.scale(pVector.z);
        float f = this.random(3.0f);
        this.curveTightness(f);
        this.noStroke();
        this.fill(255.0f, 215.0f, 0.0f);
        this.beginShape();
        this.curveVertex(0.0f, 0.0f);
        this.curveVertex(-22.0f, 0.0f);
        this.curveVertex(-35.0f, -20.0f);
        this.curveVertex(-62.0f, -35.0f);
        this.curveVertex(-22.0f, -37.0f);
        this.curveVertex(-35.0f, -65.0f);
        this.curveVertex(-15.0f, -55.0f);
        this.curveVertex(0.0f, -85.0f);
        this.curveVertex(15.0f, -55.0f);
        this.curveVertex(35.0f, -65.0f);
        this.curveVertex(22.0f, -37.0f);
        this.curveVertex(62.0f, -35.0f);
        this.curveVertex(35.0f, -20.0f);
        this.curveVertex(22.0f, 0.0f);
        this.curveVertex(0.0f, 0.0f);
        this.endShape();
        this.popMatrix();
    }

    public void setup() {
        this.size(this.CANVAS_WIDTH, this.CANVAS_HEIGHT, "processing.opengl.PGraphics2D");
        this.frameRate(60.0f);
        this.moonlander = Moonlander.initWithSoundtrack((PApplet)this, (String)"MetalVersion.mp3", (int)128, (int)4);
        this.moonlander.start();
        this.man1 = new StickMan();
        this.man2 = new StickMan();
        this.man1.curr_loc.set((float)(this.width + 20), (float)this.ground_y - this.man1.man_height);
        this.man1.curr_theta = 0.0f;
        this.man2.curr_loc.set(-20.0f, (float)this.ground_y - this.man1.man_height);
        this.man2.curr_theta = 0.0f;
    }

    public void sceneScheduler() {
        if (this.currSceneStage == 0) {
            this.man1.set_run_params(-1.0f, 0.0f, 0, this.width / 2 + 20, (int)((float)this.ground_y - this.man1.man_height));
            this.man2.set_run_params(1.0f, 0.0f, 1, this.width / 2 - 20, (int)((float)this.ground_y - this.man2.man_height));
            ++this.currSceneStage;
            stickman.println((Object[])new Object[]{"INITIALIzed", this.currSceneStage});
        }
        if (this.currSceneStage == 1 && this.man1.running == 0 && this.man2.running == 0) {
            this.prevTimeMarker = this.millis();
            this.man2.lHa = 0.0f;
            this.man2.rHa = 0.0f;
            this.man2.lHLim.set(-90.0f, 90.0f);
            this.man2.handRotVel.set(10.0f, 0.0f);
            this.man1.lHa = 180.0f;
            this.man1.rHa = 180.0f;
            this.man1.rHLim.set(90.0f, 270.0f);
            this.man1.handRotVel.set(0.0f, 10.0f);
            ++this.currSceneStage;
        }
        if (this.currSceneStage == 2 && this.millis() - this.prevTimeMarker > 6000) {
            this.man2.resetMan();
            this.man1.resetMan();
            float f = (float)(this.millis() - this.prevTimeMarker - 6000) * 0.05f;
            if (f <= 90.0f) {
                this.tree2Loc.z = stickman.radians((float)f);
            }
            if (f >= 150.0f) {
                ++this.currSceneStage;
                this.renderTree2 = 0;
            }
        }
        if (this.currSceneStage == 3) {
            this.man1.curr_loc.set((float)(this.width / 2 + 90), (float)(this.ground_y - 70));
            this.man1.curr_theta = 20.0f;
            this.man1.lLa = 135.0f;
            this.man1.rLa = 120.0f;
            this.man1.rLLim.set(90.0f, 120.0f);
            this.man2.curr_loc.set((float)(this.width / 2 - 90), (float)(this.ground_y - 70));
            this.man2.curr_theta = -20.0f;
            this.man2.lLa = 60.0f;
            this.man2.rLa = 45.0f;
            this.man2.lLLim.set(0.0f, 90.0f);
            this.renderFire = 1;
            this.fireLoc.z = 0.9f;
            ++this.currSceneStage;
            this.prevTimeMarker = this.millis();
        }
        if (this.currSceneStage == 4 && this.millis() - this.prevTimeMarker > 7500) {
            this.renderRain = 1;
            this.cloudLoc.x += 1.0f;
            if (this.cloudLoc.x >= (float)(this.width / 2 - 100)) {
                this.cloudLoc.x = this.width / 2 - 100;
                this.prevTimeMarker = this.millis();
                ++this.currSceneStage;
            }
        }
        if (this.currSceneStage == 5) {
            this.renderRain = 1;
            this.fireLoc.z -= 0.01f;
            if (this.fireLoc.z <= 0.1f) {
                this.fireLoc.z = 0.1f;
            }
            if (this.millis() - this.prevTimeMarker > 2000) {
                this.renderFire = 2;
                this.woodColor = this.color(0, 0, 0, 255);
                if (this.millis() - this.prevTimeMarker > 3000) {
                    this.man1.curr_loc.set((float)(this.width / 2 + 90), (float)this.ground_y - this.man1.man_height);
                    this.man1.resetMan();
                    this.man2.curr_loc.set((float)(this.width / 2 - 90), (float)this.ground_y - this.man2.man_height);
                    this.man2.resetMan();
                }
                if (this.millis() - this.prevTimeMarker > 4500) {
                    ++this.currSceneStage;
                    this.man1.set_run_params(-2.0f, 0.0f, 0, 80, (int)((float)this.ground_y - this.man1.man_height));
                    this.man2.set_run_params(-1.0f, 0.0f, 0, 120, (int)((float)this.ground_y - this.man2.man_height));
                }
            }
        }
        if (this.currSceneStage == 6) {
            this.cloudLoc.x -= 1.0f;
            if (this.cloudLoc.x <= 20.0f) {
                this.cloudLoc.x = 20.0f;
                this.prevTimeMarker = this.millis();
                ++this.currSceneStage;
            }
            if (this.cloudLoc.x <= 60.0f) {
                this.rain_g = this.ground_y - 200;
            }
        }
        if (this.currSceneStage == 7 && this.millis() - this.prevTimeMarker > 2000) {
            this.cloudLoc.x += 1.0f;
            if (this.cloudLoc.x >= 60.0f) {
                this.rain_g = this.ground_y;
            }
            if (this.cloudLoc.x >= 130.0f) {
                this.cloudLoc.x = 130.0f;
                this.cloudLoc.y += 1.0f;
                if (this.cloudLoc.y >= (float)(this.ground_y - 300)) {
                    this.cloudLoc.y = this.ground_y - 300;
                    ++this.currSceneStage;
                    this.prevTimeMarker = this.millis();
                }
            }
        }
        if (this.currSceneStage == 8 && this.millis() - this.prevTimeMarker > 500) {
            this.prevTimeMarker = this.millis();
            this.renderLightning = 1 - this.renderLightning;
            this.lightningCount += this.renderLightning;
            if (this.lightningCount > 2) {
                this.renderRain = 0;
                this.prevTimeMarker = this.millis();
                ++this.currSceneStage;
                this.man1.set_run_params(1.5f, 0.0f, 1, this.width + 30, (int)((float)this.ground_y - this.man1.man_height));
                this.man2.set_run_params(1.5f, 0.0f, 1, this.width + 30, (int)((float)this.ground_y - this.man2.man_height));
            }
        }
        if (this.currSceneStage == 9) {
            if (this.millis() - this.prevTimeMarker > 400) {
                this.prevTimeMarker = this.millis();
                this.renderLightning = 1 - this.renderLightning;
                this.lightningCount += this.renderLightning;
            }
            if (this.lightningCount > 8) {
                this.renderFire2 = 1;
                this.fireLoc.z = 0.5f;
            }
            this.cloudLoc.x += 1.0f;
            this.cloudLoc.y -= 0.5f;
            if (this.cloudLoc.y <= 10.0f) {
                this.cloudLoc.y = 10.0f;
            }
            if (this.man1.running == 0) {
                this.renderLightning = 0;
                ++this.currSceneStage;
            }
        }
    }

    public void draw() {
        this.moonlander.update();
        this.moonlander.getIntValue("playback_start");
        this.sceneScheduler();
        this.background(this.bg_red, this.bg_green, this.bg_blue);
        this.ground();
        this.tree(this.tree1Loc);
        if (this.renderTree2 == 1) {
            this.tree(this.tree2Loc);
        }
        if (this.renderFire > 0) {
            this.pushMatrix();
            this.translate(this.width / 2, this.ground_y - 30);
            this.rectMode(0);
            this.rotate(stickman.radians((float)30.0f));
            int n = 0;
            while (n < 7) {
                this.rotate(stickman.radians((float)15.0f));
                this.fill(this.woodColor);
                this.rect(0.0f, 0.0f, 50.0f, 10.0f);
                ++n;
            }
            this.popMatrix();
            this.fireLoc.y = this.ground_y - 20;
            if (this.renderFire == 1) {
                this.fire(this.fireLoc);
            }
        }
        this.man1.display();
        this.man2.display();
        this.draw_cloud(this.cloudLoc);
        if (this.renderLightning == 1) {
            this.draw_lightning(this.cloudLoc, this.man2.curr_loc);
            this.draw_lightning(this.cloudLoc, this.man1.curr_loc);
        }
        if (this.renderRain == 1) {
            this.let_it_rain(this.cloudLoc, this.rain_g);
        }
        if (this.renderFire2 == 1) {
            this.fireLoc.x = this.man1.curr_loc.x;
            this.fireLoc.y = this.man1.curr_loc.y;
            this.fire(this.fireLoc);
            this.fireLoc.x = this.man2.curr_loc.x;
            this.fireLoc.y = this.man2.curr_loc.y;
            this.fire(this.fireLoc);
        }
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"--full-screen", "--bgcolor=#666666", "--hide-stop", "stickman"};
        if (stringArray != null) {
            PApplet.main((String[])stickman.concat((String[])stringArray2, (String[])stringArray));
        } else {
            PApplet.main((String[])stringArray2);
        }
    }

    class StickMan {
        PShape man;
        PShape head;
        PShape body;
        PShape lHand;
        PShape rHand;
        PShape lLeg;
        PShape rLeg;
        PVector curr_loc = new PVector(0.0f, 0.0f);
        float curr_theta;
        int hOx = 0;
        int hOy = 30;
        int lOx = 0;
        int lOy = 70;
        float lHa = 135.0f;
        float rHa = 45.0f;
        float lLa = 135.0f;
        float rLa = 45.0f;
        int handLen = 30;
        int legLen = 30;
        PVector vel = new PVector(0.0f, 0.0f, 0.0f);
        PVector handRotVel = new PVector(0.0f, 0.0f);
        PVector legRotVel = new PVector(0.0f, 0.0f);
        PVector lHLim = new PVector(95.0f, 210.0f);
        PVector rHLim = new PVector(-30.0f, 85.0f);
        PVector lLLim = new PVector(95.0f, 210.0f);
        PVector rLLim = new PVector(-30.0f, 85.0f);
        PVector v = new PVector(0.0f, 0.0f);
        int running;
        float man_height;
        PVector run_targ = new PVector(0.0f, 0.0f);

        StickMan() {
            this.man = stickman.this.createShape(0);
            stickman.this.ellipseMode(2);
            this.head = stickman.this.createShape(31, new float[]{-12.0f, 0.0f, 24.0f, 24.0f});
            this.body = stickman.this.createShape(4, new float[]{0.0f, 24.0f, 0.0f, 70.0f});
            this.lHand = stickman.this.createShape();
            this.lHand.beginShape(5);
            this.lHand.vertex((float)this.hOx, (float)this.hOy);
            this.lHand.vertex((float)this.hOx + (float)this.handLen * stickman.cos((float)stickman.radians((float)this.lHa)), (float)this.hOy + (float)this.handLen * stickman.sin((float)stickman.radians((float)this.lHa)));
            this.lHand.endShape();
            this.rHand = stickman.this.createShape();
            this.rHand.beginShape(5);
            this.rHand.vertex((float)this.hOx, (float)this.hOy);
            this.rHand.vertex((float)this.hOx + (float)this.handLen * stickman.cos((float)stickman.radians((float)this.rHa)), (float)this.hOy + (float)this.handLen * stickman.sin((float)stickman.radians((float)this.rHa)));
            this.rHand.endShape();
            this.rLeg = stickman.this.createShape();
            this.rLeg.beginShape(5);
            this.rLeg.vertex((float)this.lOx, (float)this.lOy);
            this.rLeg.vertex((float)this.lOx + (float)this.legLen * stickman.cos((float)stickman.radians((float)this.rLa)), (float)this.lOy + (float)this.legLen * stickman.sin((float)stickman.radians((float)this.rLa)));
            this.rLeg.endShape();
            this.lLeg = stickman.this.createShape();
            this.lLeg.beginShape(5);
            this.lLeg.vertex((float)this.lOx, (float)this.lOy);
            this.lLeg.vertex((float)this.lOx + (float)this.legLen * stickman.cos((float)stickman.radians((float)this.lLa)), (float)this.lOy + (float)this.legLen * stickman.sin((float)stickman.radians((float)this.lLa)));
            this.lLeg.endShape();
            this.man_height = (float)this.lOy + (float)this.legLen * stickman.sin((float)stickman.radians((float)this.lLa));
            this.man.addChild(this.head);
            this.man.addChild(this.body);
            this.man.addChild(this.lHand);
            this.man.addChild(this.rHand);
            this.man.addChild(this.lLeg);
            this.man.addChild(this.rLeg);
            this.running = 0;
        }

        public void rotateHand(int n) {
            stickman.this.pushMatrix();
            stickman.this.translate(this.curr_loc.x, this.curr_loc.y);
            if (n == 0) {
                this.lHa += this.handRotVel.x;
                if (this.lHa <= this.lHLim.x || this.lHa >= this.lHLim.y) {
                    this.handRotVel.x = -1.0f * this.handRotVel.x;
                    this.lHa = this.lHa <= this.lHLim.x ? this.lHLim.x : this.lHLim.y;
                }
                this.v.x = (float)this.hOx + (float)this.handLen * stickman.cos((float)stickman.radians((float)this.lHa));
                this.v.y = (float)this.hOy + (float)this.handLen * stickman.sin((float)stickman.radians((float)this.lHa));
                this.lHand.setVertex(1, this.v);
            } else {
                this.rHa += this.handRotVel.y;
                if (this.rHa <= this.rHLim.x || this.rHa >= this.rHLim.y) {
                    this.handRotVel.y = -1.0f * this.handRotVel.y;
                    this.rHa = this.rHa <= this.rHLim.x ? this.rHLim.x : this.rHLim.y;
                }
                this.v.x = (float)this.hOx + (float)this.handLen * stickman.cos((float)stickman.radians((float)this.rHa));
                this.v.y = (float)this.hOy + (float)this.handLen * stickman.sin((float)stickman.radians((float)this.rHa));
                this.rHand.setVertex(1, this.v);
            }
            stickman.this.popMatrix();
        }

        public void rotateLeg(int n) {
            stickman.this.pushMatrix();
            stickman.this.translate(this.curr_loc.x, this.curr_loc.y);
            if (n == 0) {
                this.lLa += this.legRotVel.x;
                if (this.lLa <= this.lLLim.x || this.lLa >= this.lLLim.y) {
                    this.legRotVel.x = -1.0f * this.legRotVel.x;
                    this.lLa = this.lLa <= this.lLLim.x ? this.lLLim.x : this.lLLim.y;
                }
                this.v.x = (float)this.lOx + (float)this.legLen * stickman.cos((float)stickman.radians((float)this.lLa));
                this.v.y = (float)this.lOy + (float)this.legLen * stickman.sin((float)stickman.radians((float)this.lLa));
                this.lLeg.setVertex(1, this.v);
            } else {
                this.rLa += this.legRotVel.y;
                if (this.rLa <= this.rLLim.x || this.rLa >= this.rLLim.y) {
                    this.legRotVel.y = -1.0f * this.legRotVel.y;
                    this.rLa = this.rLa <= this.rLLim.x ? this.rLLim.x : this.rLLim.y;
                }
                this.v.x = (float)this.lOx + (float)this.legLen * stickman.cos((float)stickman.radians((float)this.rLa));
                this.v.y = (float)this.lOy + (float)this.legLen * stickman.sin((float)stickman.radians((float)this.rLa));
                this.rLeg.setVertex(1, this.v);
            }
            stickman.this.popMatrix();
        }

        public void set_run_params(float f, float f2, int n, int n2, int n3) {
            if (n == 1) {
                this.lHa = 65.0f;
                this.rHa = 65.0f;
                this.lLa = 80.0f;
                this.rLa = 80.0f;
                this.lHLim.x = -20.0f;
                this.lHLim.y = 150.0f;
                this.rHLim.x = -20.0f;
                this.rHLim.y = 150.0f;
                this.lLLim.x = 30.0f;
                this.lLLim.y = 130.0f;
                this.rLLim.x = 30.0f;
                this.rLLim.y = 130.0f;
                this.handRotVel.x = -4.0f;
                this.handRotVel.y = 4.0f;
                this.legRotVel.x = -6.0f;
                this.legRotVel.y = 6.0f;
                this.curr_theta = 20.0f;
            } else {
                this.lHa = 145.0f;
                this.rHa = 145.0f;
                this.lLa = 120.0f;
                this.rLa = 120.0f;
                this.lHLim.x = 50.0f;
                this.lHLim.y = 220.0f;
                this.rHLim.x = 50.0f;
                this.rHLim.y = 220.0f;
                this.lLLim.x = 70.0f;
                this.lLLim.y = 170.0f;
                this.rLLim.x = 70.0f;
                this.rLLim.y = 170.0f;
                this.handRotVel.x = -4.0f;
                this.handRotVel.y = 4.0f;
                this.legRotVel.x = -6.0f;
                this.legRotVel.y = 6.0f;
                this.curr_theta = -20.0f;
            }
            this.vel.x = f;
            this.vel.y = f2;
            this.running = 1;
            this.run_targ.x = n2;
            this.run_targ.y = n3;
        }

        public void resetMan() {
            this.lHa = 135.0f;
            this.rHa = 45.0f;
            this.lLa = 135.0f;
            this.rLa = 45.0f;
            this.curr_theta = 0.0f;
            this.vel.set(0.0f, 0.0f, 0.0f);
            this.handRotVel.set(0.0f, 0.0f);
            this.legRotVel.set(0.0f, 0.0f);
            this.lHLim.set(95.0f, 210.0f);
            this.rHLim.set(-30.0f, 85.0f);
            this.lLLim.set(95.0f, 210.0f);
            this.rLLim.set(-30.0f, 85.0f);
        }

        public void update_locs() {
            this.rotateHand(0);
            this.rotateHand(1);
            this.rotateLeg(1);
            this.rotateLeg(0);
            this.curr_loc.x += this.vel.x;
            this.curr_loc.y += this.vel.y;
            if (this.curr_loc.dist(this.run_targ) < this.vel.mag()) {
                this.running = 0;
                this.resetMan();
            }
        }

        public void display() {
            stickman.this.pushMatrix();
            this.update_locs();
            stickman.this.translate(this.curr_loc.x, this.curr_loc.y);
            stickman.this.rotate(stickman.radians((float)this.curr_theta));
            stickman.this.shape(this.man);
            stickman.this.popMatrix();
        }
    }
}

