/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.utils;

import com.sun.org.apache.xalan.internal.utils.SecuritySupport;

public final class XMLSecurityPropertyManager {
    private final String[] values;
    private State[] states = new State[]{State.DEFAULT, State.DEFAULT};

    public XMLSecurityPropertyManager() {
        this.values = new String[Property.values().length];
        for (Property property : Property.values()) {
            this.values[property.ordinal()] = property.defaultValue();
        }
        this.readSystemProperties();
    }

    public void setValue(Property property, State state, String string) {
        if (state.compareTo(this.states[property.ordinal()]) >= 0) {
            this.values[property.ordinal()] = string;
            this.states[property.ordinal()] = state;
        }
    }

    public void setValue(int n, State state, String string) {
        if (state.compareTo(this.states[n]) >= 0) {
            this.values[n] = string;
            this.states[n] = state;
        }
    }

    public String getValue(Property property) {
        return this.values[property.ordinal()];
    }

    public String getValueByIndex(int n) {
        return this.values[n];
    }

    public int getIndex(String string) {
        for (Property property : Property.values()) {
            if (!property.equalsName(string)) continue;
            return property.ordinal();
        }
        return -1;
    }

    private void readSystemProperties() {
        this.getSystemProperty(Property.ACCESS_EXTERNAL_DTD, "javax.xml.accessExternalDTD");
        this.getSystemProperty(Property.ACCESS_EXTERNAL_STYLESHEET, "javax.xml.accessExternalStylesheet");
    }

    private void getSystemProperty(Property property, String string) {
        try {
            String string2 = SecuritySupport.getSystemProperty(string);
            if (string2 != null) {
                this.values[property.ordinal()] = string2;
                this.states[property.ordinal()] = State.SYSTEMPROPERTY;
                return;
            }
            string2 = SecuritySupport.readJAXPProperty(string);
            if (string2 != null) {
                this.values[property.ordinal()] = string2;
                this.states[property.ordinal()] = State.JAXPDOTPROPERTIES;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    public static enum Property {
        ACCESS_EXTERNAL_DTD("http://javax.xml.XMLConstants/property/accessExternalDTD", "all"),
        ACCESS_EXTERNAL_STYLESHEET("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "all");

        final String name;
        final String defaultValue;

        private Property(String string2, String string3) {
            this.name = string2;
            this.defaultValue = string3;
        }

        public boolean equalsName(String string) {
            return string == null ? false : this.name.equals(string);
        }

        String defaultValue() {
            return this.defaultValue;
        }
    }

    public static enum State {
        DEFAULT,
        FSP,
        JAXPDOTPROPERTIES,
        SYSTEMPROPERTY,
        APIPROPERTY;

    }
}

