/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xpath.internal;

import com.sun.org.apache.xalan.internal.res.XSLMessages;
import com.sun.org.apache.xml.internal.dtm.DTM;
import com.sun.org.apache.xml.internal.dtm.DTMFilter;
import com.sun.org.apache.xml.internal.dtm.DTMIterator;
import com.sun.org.apache.xml.internal.dtm.DTMManager;
import com.sun.org.apache.xml.internal.utils.NodeVector;
import com.sun.org.apache.xpath.internal.XPathContext;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class NodeSetDTM
extends NodeVector
implements DTMIterator,
Cloneable {
    static final long serialVersionUID = 7686480133331317070L;
    DTMManager m_manager;
    protected transient int m_next = 0;
    protected transient boolean m_mutable = true;
    protected transient boolean m_cacheNodes = true;
    protected int m_root = -1;
    private transient int m_last = 0;

    public NodeSetDTM(DTMManager dTMManager) {
        this.m_manager = dTMManager;
    }

    public NodeSetDTM(int n, int n2, DTMManager dTMManager) {
        super(n);
        this.m_manager = dTMManager;
    }

    public NodeSetDTM(NodeSetDTM nodeSetDTM) {
        this.m_manager = nodeSetDTM.getDTMManager();
        this.m_root = nodeSetDTM.getRoot();
        this.addNodes(nodeSetDTM);
    }

    public NodeSetDTM(DTMIterator dTMIterator) {
        this.m_manager = dTMIterator.getDTMManager();
        this.m_root = dTMIterator.getRoot();
        this.addNodes(dTMIterator);
    }

    public NodeSetDTM(NodeIterator nodeIterator, XPathContext xPathContext) {
        Node node;
        this.m_manager = xPathContext.getDTMManager();
        while (null != (node = nodeIterator.nextNode())) {
            int n = xPathContext.getDTMHandleFromNode(node);
            this.addNodeInDocOrder(n, xPathContext);
        }
    }

    public NodeSetDTM(NodeList nodeList, XPathContext xPathContext) {
        this.m_manager = xPathContext.getDTMManager();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node = nodeList.item(i);
            int n2 = xPathContext.getDTMHandleFromNode(node);
            this.addNode(n2);
        }
    }

    public NodeSetDTM(int n, DTMManager dTMManager) {
        this.m_manager = dTMManager;
        this.addNode(n);
    }

    public void setEnvironment(Object object) {
    }

    @Override
    public int getRoot() {
        if (-1 == this.m_root) {
            if (this.size() > 0) {
                return this.item(0);
            }
            return -1;
        }
        return this.m_root;
    }

    @Override
    public void setRoot(int n, Object object) {
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        NodeSetDTM nodeSetDTM = (NodeSetDTM)super.clone();
        return nodeSetDTM;
    }

    @Override
    public DTMIterator cloneWithReset() throws CloneNotSupportedException {
        NodeSetDTM nodeSetDTM = (NodeSetDTM)this.clone();
        nodeSetDTM.reset();
        return nodeSetDTM;
    }

    @Override
    public void reset() {
        this.m_next = 0;
    }

    @Override
    public int getWhatToShow() {
        return -17;
    }

    public DTMFilter getFilter() {
        return null;
    }

    @Override
    public boolean getExpandEntityReferences() {
        return true;
    }

    @Override
    public DTM getDTM(int n) {
        return this.m_manager.getDTM(n);
    }

    @Override
    public DTMManager getDTMManager() {
        return this.m_manager;
    }

    @Override
    public int nextNode() {
        if (this.m_next < this.size()) {
            int n = this.elementAt(this.m_next);
            ++this.m_next;
            return n;
        }
        return -1;
    }

    @Override
    public int previousNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_ITERATE", null));
        }
        if (this.m_next - 1 > 0) {
            --this.m_next;
            return this.elementAt(this.m_next);
        }
        return -1;
    }

    @Override
    public void detach() {
    }

    @Override
    public void allowDetachToRelease(boolean bl) {
    }

    @Override
    public boolean isFresh() {
        return this.m_next == 0;
    }

    @Override
    public void runTo(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = n >= 0 && this.m_next < this.m_firstFree ? n : this.m_firstFree - 1;
    }

    @Override
    public int item(int n) {
        this.runTo(n);
        return this.elementAt(n);
    }

    @Override
    public int getLength() {
        this.runTo(-1);
        return this.size();
    }

    public void addNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.addElement(n);
    }

    public void insertNode(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.insertElementAt(n, n2);
    }

    public void removeNode(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        this.removeElement(n);
    }

    public void addNodes(DTMIterator dTMIterator) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        if (null != dTMIterator) {
            int n;
            while (-1 != (n = dTMIterator.nextNode())) {
                this.addElement(n);
            }
        }
    }

    public void addNodesInDocOrder(DTMIterator dTMIterator, XPathContext xPathContext) {
        int n;
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        while (-1 != (n = dTMIterator.nextNode())) {
            this.addNodeInDocOrder(n, xPathContext);
        }
    }

    public int addNodeInDocOrder(int n, boolean bl, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        int n2 = -1;
        if (bl) {
            int n3;
            int n4 = this.size();
            for (n3 = n4 - 1; n3 >= 0; --n3) {
                int n5 = this.elementAt(n3);
                if (n5 == n) {
                    n3 = -2;
                    break;
                }
                DTM dTM = xPathContext.getDTM(n);
                if (!dTM.isNodeAfter(n, n5)) break;
            }
            if (n3 != -2) {
                n2 = n3 + 1;
                this.insertElementAt(n, n2);
            }
        } else {
            n2 = this.size();
            boolean bl2 = false;
            for (int i = 0; i < n2; ++i) {
                if (i != n) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                this.addElement(n);
            }
        }
        return n2;
    }

    public int addNodeInDocOrder(int n, XPathContext xPathContext) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        return this.addNodeInDocOrder(n, true, xPathContext);
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public void addElement(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.addElement(n);
    }

    @Override
    public void insertElementAt(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.insertElementAt(n, n2);
    }

    @Override
    public void appendNodes(NodeVector nodeVector) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.appendNodes(nodeVector);
    }

    @Override
    public void removeAllElements() {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.removeAllElements();
    }

    @Override
    public boolean removeElement(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        return super.removeElement(n);
    }

    @Override
    public void removeElementAt(int n) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.removeElementAt(n);
    }

    @Override
    public void setElementAt(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.setElementAt(n, n2);
    }

    @Override
    public void setItem(int n, int n2) {
        if (!this.m_mutable) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_NOT_MUTABLE", null));
        }
        super.setElementAt(n, n2);
    }

    @Override
    public int elementAt(int n) {
        this.runTo(n);
        return super.elementAt(n);
    }

    @Override
    public boolean contains(int n) {
        this.runTo(-1);
        return super.contains(n);
    }

    @Override
    public int indexOf(int n, int n2) {
        this.runTo(-1);
        return super.indexOf(n, n2);
    }

    @Override
    public int indexOf(int n) {
        this.runTo(-1);
        return super.indexOf(n);
    }

    @Override
    public int getCurrentPos() {
        return this.m_next;
    }

    @Override
    public void setCurrentPos(int n) {
        if (!this.m_cacheNodes) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_NODESETDTM_CANNOT_INDEX", null));
        }
        this.m_next = n;
    }

    @Override
    public int getCurrentNode() {
        if (!this.m_cacheNodes) {
            throw new RuntimeException("This NodeSetDTM can not do indexing or counting functions!");
        }
        int n = this.m_next;
        int n2 = this.m_next > 0 ? this.m_next - 1 : this.m_next;
        int n3 = n2 < this.m_firstFree ? this.elementAt(n2) : -1;
        this.m_next = n;
        return n3;
    }

    public boolean getShouldCacheNodes() {
        return this.m_cacheNodes;
    }

    @Override
    public void setShouldCacheNodes(boolean bl) {
        if (!this.isFresh()) {
            throw new RuntimeException(XSLMessages.createXPATHMessage("ER_CANNOT_CALL_SETSHOULDCACHENODE", null));
        }
        this.m_cacheNodes = bl;
        this.m_mutable = true;
    }

    @Override
    public boolean isMutable() {
        return this.m_mutable;
    }

    public int getLast() {
        return this.m_last;
    }

    public void setLast(int n) {
        this.m_last = n;
    }

    @Override
    public boolean isDocOrdered() {
        return true;
    }

    @Override
    public int getAxis() {
        return -1;
    }
}

