public class Drip2 implements Effect {
  
  PImage img;
  float dx[];
  float time, t0 = -1;
  int[] tatumtimes;
  
  public boolean isWithin(float value, float compare, float epsilon)
  {
    return ((value <= compare + epsilon) && (value >= compare - epsilon));
  }
  
  void setup(PGraphics pg) 
  {
    img = loadImage(dataPath("skull2.jpg"));
    String[] meterdata = loadStrings("kiva_valtakunta_Siel2.met");
    int tatums = Integer.parseInt(meterdata[0]), beats = Integer.parseInt(meterdata[1]), bars = Integer.parseInt(meterdata[2]);
    println("Expecting " + tatums + " tatums, " + beats + " beats, " + bars + " bars.");
    tatumtimes = new int[tatums];
    for (int i = 3; i < tatums+3; i++)
    {
      tatumtimes[i-3] = int(float(meterdata[i])*1000);
      //println("Tatum " + (i-3) + " at time " + tatumtimes[i-3]);
    }
    dx = new float[img.height];
    for (int x = 0; x < img.height; x++)
      dx[x] = random(30);
  }
  
  void draw(PGraphics pg)
  {
    if (t0 < 0)
      t0 = millis();
    int st = player.position();
    int watchedtatum = 0;
    if (abs(tatumtimes[min(watchedtatum+1, tatumtimes.length)]-st) < abs(tatumtimes[watchedtatum]-st)) 
      for (int i = 0; i < tatumtimes.length; i++)
      {
        if (st < tatumtimes[i]) {
          println("Found tatum " + i + " at " + tatumtimes[i], " which is after " + st);
          watchedtatum = i;
          break;
        }
      }
    println("Waiting for tatum " + watchedtatum + " at " + tatumtimes[watchedtatum] + ", now at " + player.position());
    pg.beginDraw();
    if (isWithin(st, tatumtimes[watchedtatum], 75)) {
      println("Hit tatum " + tatumtimes[watchedtatum] + " with playhead at " + player.position());
      tint(220, 20, 30);
    }
    else
      tint(200, 0, 0);
    //println("Blitting " + img.width + "x" + img.height + " at 0,0 on a " + pg.width + "x" + pg.height + " canvas.");
    //println("At effective time " + max(millis()-t0-3500, 0));
    for (int y = 0; y < pg.height; y++)
    {
      for (int x = 0; x < pg.width; x++)
      {
        pg.set(x, y, img.get((int)(((float)img.width*x)/pg.width)+(int)lerp(0, -1*dx[(int)(((float)img.height*y)/pg.height)], max(millis()-t0-3500, 0)/15000.0)+(int)(map(max(millis()-t0-6500, 0), 0, 15000, 0, 1.0)*20*sin(random(2*PI))), (int)(((float)img.height*y)/pg.height)));
      }
    }

 //   pg.image(img, 0, 0, pg.width, pg.height);
    pg.endDraw();
  }
}
