import processing.core.*; 
import processing.data.*; 
import processing.event.*; 
import processing.opengl.*; 

import ddf.minim.*; 

import java.util.HashMap; 
import java.util.ArrayList; 
import java.io.File; 
import java.io.BufferedReader; 
import java.io.PrintWriter; 
import java.io.InputStream; 
import java.io.OutputStream; 
import java.io.IOException; 

public class valtakunta extends PApplet {



public interface Effect {
  public void setup(PGraphics pg);
  public void draw(PGraphics pg); 
}

static Effect[] effects;
static float partTimes[] = {25000, 35000};
  
Minim minim;
AudioPlayer player;

float startTime = -1;
int activePart = 0, lastPart = -1;

PGraphics pg;

public void setup() {
    pg = createGraphics(displayWidth, displayHeight);
    pg.background(0);
    pg.setSize(displayWidth, displayHeight);
    size(displayWidth, displayHeight);
    println("Tried to create graphics at size " + displayWidth + "x" + displayHeight + ", got " + pg.width + "x" + pg.height);
    pg.smooth();
    frameRate(25);
    frame.setResizable(true);
    frame.setSize(displayWidth, displayHeight);
    sketchFullScreen();
    minim = new Minim(this);
    //print(dataPath("kiva_valtakunta_Siel2.mp3"));
    player = minim.loadFile(dataPath("kiva_valtakunta_Siel2.mp3"));
    effects = new Effect[2];
    effects[0] = new Drip();
    effects[1] = new Drip2();
    for (Effect fx: effects) {
      fx.setup(pg);
    }
    player.play();
}  

  public void draw()
  {
    if (startTime == -1)
      startTime = millis();
    lastPart = activePart;
    float pastParts = 0;
    for (int i = 0; i < activePart; i++)
      pastParts += partTimes[i];
    if (millis() - pastParts - startTime > partTimes[activePart]) {
      println(millis()-pastParts-startTime + " greater than " + partTimes[activePart] + ", moving on to next part...");
      lastPart = activePart++;
    }
    if (activePart < effects.length)
      effects[activePart].draw(pg);
    else
      exit();
    image(((PImage)pg), 0, 0);
  }
  
  public void mouseClicked()
  {
    lastPart = activePart++;  
  }
  
  public void stop()
  {
    player.close();
    minim.stop();
    super.stop();
  }
public class Drip implements Effect {
  
  PImage img;
  float dy[];
  float time, t0;
  
  public void setup(PGraphics pg) 
  {
    img = loadImage(dataPath("skull.jpg"));
    dy = new float[img.width];
    for (int x = 0; x < img.width; x++)
      dy[x] = random(120);
    t0 = millis();
  }
  
  public void draw(PGraphics pg)
  { 
    pg.beginDraw();
    tint(200, 0, 0);
    //println("Blitting " + img.width + "x" + img.height + " at 0,0 on a " + pg.width + "x" + pg.height + " canvas.");
    for (int y = 0; y < pg.height; y++)
    {
      for (int x = 0; x < pg.width; x++)
      {
        pg.set(x, y, img.get((int)(((float)img.width*x)/pg.width), (int)(((float)img.height*y)/pg.height)+(int)lerp(0, -1*dy[(int)(((float)img.width*x)/pg.width)], max(millis()-t0-3500, 0)/15000.0f) ));
      }
    }

 //   pg.image(img, 0, 0, pg.width, pg.height);
    pg.endDraw();
  }
}
public class Drip2 implements Effect {
  
  PImage img;
  float dx[];
  float time, t0 = -1;
  int[] tatumtimes;
  
  public boolean isWithin(float value, float compare, float epsilon)
  {
    return ((value <= compare + epsilon) && (value >= compare - epsilon));
  }
  
  public void setup(PGraphics pg) 
  {
    img = loadImage(dataPath("skull2.jpg"));
    String[] meterdata = loadStrings("kiva_valtakunta_Siel2.met");
    int tatums = Integer.parseInt(meterdata[0]), beats = Integer.parseInt(meterdata[1]), bars = Integer.parseInt(meterdata[2]);
    println("Expecting " + tatums + " tatums, " + beats + " beats, " + bars + " bars.");
    tatumtimes = new int[tatums];
    for (int i = 3; i < tatums+3; i++)
    {
      tatumtimes[i-3] = PApplet.parseInt(PApplet.parseFloat(meterdata[i])*1000);
      //println("Tatum " + (i-3) + " at time " + tatumtimes[i-3]);
    }
    dx = new float[img.height];
    for (int x = 0; x < img.height; x++)
      dx[x] = random(30);
  }
  
  public void draw(PGraphics pg)
  {
    if (t0 < 0)
      t0 = millis();
    int st = player.position();
    int watchedtatum = 0;
    if (abs(tatumtimes[min(watchedtatum+1, tatumtimes.length)]-st) < abs(tatumtimes[watchedtatum]-st)) 
      for (int i = 0; i < tatumtimes.length; i++)
      {
        if (st < tatumtimes[i]) {
          println("Found tatum " + i + " at " + tatumtimes[i], " which is after " + st);
          watchedtatum = i;
          break;
        }
      }
    println("Waiting for tatum " + watchedtatum + " at " + tatumtimes[watchedtatum] + ", now at " + player.position());
    pg.beginDraw();
    if (isWithin(st, tatumtimes[watchedtatum], 75)) {
      println("Hit tatum " + tatumtimes[watchedtatum] + " with playhead at " + player.position());
      tint(220, 20, 30);
    }
    else
      tint(200, 0, 0);
    //println("Blitting " + img.width + "x" + img.height + " at 0,0 on a " + pg.width + "x" + pg.height + " canvas.");
    //println("At effective time " + max(millis()-t0-3500, 0));
    for (int y = 0; y < pg.height; y++)
    {
      for (int x = 0; x < pg.width; x++)
      {
        pg.set(x, y, img.get((int)(((float)img.width*x)/pg.width)+(int)lerp(0, -1*dx[(int)(((float)img.height*y)/pg.height)], max(millis()-t0-3500, 0)/15000.0f)+(int)(map(max(millis()-t0-6500, 0), 0, 15000, 0, 1.0f)*20*sin(random(2*PI))), (int)(((float)img.height*y)/pg.height)));
      }
    }

 //   pg.image(img, 0, 0, pg.width, pg.height);
    pg.endDraw();
  }
}
  static public void main(String[] passedArgs) {
    String[] appletArgs = new String[] { "--full-screen", "--bgcolor=#666666", "--hide-stop", "valtakunta" };
    if (passedArgs != null) {
      PApplet.main(concat(appletArgs, passedArgs));
    } else {
      PApplet.main(appletArgs);
    }
  }
}
