/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.stream;

import com.sun.org.apache.xerces.internal.impl.PropertyManager;
import com.sun.org.apache.xerces.internal.impl.XMLErrorReporter;
import com.sun.org.apache.xerces.internal.impl.msg.XMLMessageFormatter;
import com.sun.org.apache.xerces.internal.util.MessageFormatter;
import com.sun.org.apache.xerces.internal.xni.XMLLocator;
import com.sun.org.apache.xerces.internal.xni.XNIException;
import javax.xml.stream.Location;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;

public class StaxErrorReporter
extends XMLErrorReporter {
    protected XMLReporter fXMLReporter = null;

    public StaxErrorReporter(PropertyManager propertyManager) {
        this.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", new XMLMessageFormatter());
        this.reset(propertyManager);
    }

    public StaxErrorReporter() {
        this.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", new XMLMessageFormatter());
    }

    public void reset(PropertyManager propertyManager) {
        this.fXMLReporter = (XMLReporter)propertyManager.getProperty("javax.xml.stream.reporter");
    }

    @Override
    public String reportError(XMLLocator xMLLocator, String string, String string2, Object[] objectArray, short s) throws XNIException {
        String string3;
        MessageFormatter messageFormatter = this.getMessageFormatter(string);
        if (messageFormatter != null) {
            string3 = messageFormatter.formatMessage(this.fLocale, string2, objectArray);
        } else {
            int n;
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string);
            stringBuffer.append('#');
            stringBuffer.append(string2);
            int n2 = n = objectArray != null ? objectArray.length : 0;
            if (n > 0) {
                stringBuffer.append('?');
                for (int i = 0; i < n; ++i) {
                    stringBuffer.append(objectArray[i]);
                    if (i >= n - 1) continue;
                    stringBuffer.append('&');
                }
            }
            string3 = stringBuffer.toString();
        }
        switch (s) {
            case 0: {
                try {
                    if (this.fXMLReporter == null) break;
                    this.fXMLReporter.report(string3, "WARNING", null, this.convertToStaxLocation(xMLLocator));
                    break;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new XNIException(xMLStreamException);
                }
            }
            case 1: {
                try {
                    if (this.fXMLReporter == null) break;
                    this.fXMLReporter.report(string3, "ERROR", null, this.convertToStaxLocation(xMLLocator));
                    break;
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new XNIException(xMLStreamException);
                }
            }
            case 2: {
                if (this.fContinueAfterFatalError) break;
                throw new XNIException(string3);
            }
        }
        return string3;
    }

    Location convertToStaxLocation(final XMLLocator xMLLocator) {
        return new Location(){

            @Override
            public int getColumnNumber() {
                return xMLLocator.getColumnNumber();
            }

            @Override
            public int getLineNumber() {
                return xMLLocator.getLineNumber();
            }

            @Override
            public String getPublicId() {
                return xMLLocator.getPublicId();
            }

            @Override
            public String getSystemId() {
                return xMLLocator.getLiteralSystemId();
            }

            @Override
            public int getCharacterOffset() {
                return xMLLocator.getCharacterOffset();
            }

            public String getLocationURI() {
                return "";
            }
        };
    }
}

