/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.addressing;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.Nullable;
import com.sun.xml.internal.ws.addressing.W3CAddressingConstants;
import com.sun.xml.internal.ws.addressing.WsaServerTube;
import com.sun.xml.internal.ws.addressing.model.InvalidAddressingHeaderException;
import com.sun.xml.internal.ws.addressing.model.MissingAddressingHeaderException;
import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.addressing.WSEndpointReference;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.server.WSEndpoint;
import javax.xml.ws.soap.AddressingFeature;

public class W3CWsaServerTube
extends WsaServerTube {
    private final AddressingFeature af;

    public W3CWsaServerTube(WSEndpoint wSEndpoint, @NotNull WSDLPort wSDLPort, WSBinding wSBinding, Tube tube) {
        super(wSEndpoint, wSDLPort, wSBinding, tube);
        this.af = wSBinding.getFeature(AddressingFeature.class);
    }

    public W3CWsaServerTube(W3CWsaServerTube w3CWsaServerTube, TubeCloner tubeCloner) {
        super(w3CWsaServerTube, tubeCloner);
        this.af = w3CWsaServerTube.af;
    }

    @Override
    public W3CWsaServerTube copy(TubeCloner tubeCloner) {
        return new W3CWsaServerTube(this, tubeCloner);
    }

    @Override
    protected void checkMandatoryHeaders(Packet packet, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        super.checkMandatoryHeaders(packet, bl, bl2, bl3, bl4, bl5, bl6);
        WSDLBoundOperation wSDLBoundOperation = this.getWSDLBoundOperation(packet);
        if (wSDLBoundOperation != null && !wSDLBoundOperation.getOperation().isOneWay() && !bl5) {
            throw new MissingAddressingHeaderException(this.addressingVersion.messageIDTag, packet);
        }
    }

    @Override
    protected boolean isAnonymousRequired(@Nullable WSDLBoundOperation wSDLBoundOperation) {
        return this.getResponseRequirement(wSDLBoundOperation) == WSDLBoundOperation.ANONYMOUS.required;
    }

    private WSDLBoundOperation.ANONYMOUS getResponseRequirement(@Nullable WSDLBoundOperation wSDLBoundOperation) {
        try {
            if (this.af.getResponses() == AddressingFeature.Responses.ANONYMOUS) {
                return WSDLBoundOperation.ANONYMOUS.required;
            }
            if (this.af.getResponses() == AddressingFeature.Responses.NON_ANONYMOUS) {
                return WSDLBoundOperation.ANONYMOUS.prohibited;
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return wSDLBoundOperation != null ? wSDLBoundOperation.getAnonymous() : WSDLBoundOperation.ANONYMOUS.optional;
    }

    @Override
    protected void checkAnonymousSemantics(WSDLBoundOperation wSDLBoundOperation, WSEndpointReference wSEndpointReference, WSEndpointReference wSEndpointReference2) {
        String string = null;
        String string2 = null;
        if (wSEndpointReference != null) {
            string = wSEndpointReference.getAddress();
        }
        if (wSEndpointReference2 != null) {
            string2 = wSEndpointReference2.getAddress();
        }
        WSDLBoundOperation.ANONYMOUS aNONYMOUS = this.getResponseRequirement(wSDLBoundOperation);
        switch (aNONYMOUS) {
            case prohibited: {
                if (string != null && string.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (string2 == null || !string2.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidAddressingHeaderException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_NON_ANONYMOUS_ADDRESS_SUPPORTED);
            }
            case required: {
                if (string != null && !string.equals(this.addressingVersion.anonymousUri)) {
                    throw new InvalidAddressingHeaderException(this.addressingVersion.replyToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
                }
                if (string2 == null || string2.equals(this.addressingVersion.anonymousUri)) break;
                throw new InvalidAddressingHeaderException(this.addressingVersion.faultToTag, W3CAddressingConstants.ONLY_ANONYMOUS_ADDRESS_SUPPORTED);
            }
        }
    }
}

