/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.zip.InflaterInputStream;

class CharacterName {
    private static SoftReference<byte[]> refStrPool;
    private static int[][] lookup;

    CharacterName() {
    }

    private static synchronized byte[] initNamePool() {
        byte[] byArray = null;
        if (refStrPool != null && (byArray = refStrPool.get()) != null) {
            return byArray;
        }
        FilterInputStream filterInputStream = null;
        try {
            filterInputStream = new DataInputStream(new InflaterInputStream(AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

                @Override
                public InputStream run() {
                    return this.getClass().getResourceAsStream("uniName.dat");
                }
            })));
            lookup = new int[4352][];
            int n = ((DataInputStream)filterInputStream).readInt();
            int n2 = ((DataInputStream)filterInputStream).readInt();
            byte[] byArray2 = new byte[n2];
            ((DataInputStream)filterInputStream).readFully(byArray2);
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            do {
                int n6;
                if ((n6 = byArray2[n4++] & 0xFF) == 0) {
                    n6 = byArray2[n4++] & 0xFF;
                    n5 = (byArray2[n4++] & 0xFF) << 16 | (byArray2[n4++] & 0xFF) << 8 | byArray2[n4++] & 0xFF;
                } else {
                    ++n5;
                }
                int n7 = n5 >> 8;
                if (lookup[n7] == null) {
                    CharacterName.lookup[n7] = new int[256];
                }
                CharacterName.lookup[n7][n5 & 0xFF] = n3 << 8 | n6;
                n3 += n6;
            } while (n4 < n2);
            byArray = new byte[n - n2];
            ((DataInputStream)filterInputStream).readFully(byArray);
            refStrPool = new SoftReference<byte[]>(byArray);
        }
        catch (Exception exception) {
            throw new InternalError(exception.getMessage());
        }
        finally {
            try {
                if (filterInputStream != null) {
                    filterInputStream.close();
                }
            }
            catch (Exception exception) {}
        }
        return byArray;
    }

    public static String get(int n) {
        byte[] byArray = null;
        if (refStrPool == null || (byArray = refStrPool.get()) == null) {
            byArray = CharacterName.initNamePool();
        }
        int n2 = 0;
        if (lookup[n >> 8] == null || (n2 = lookup[n >> 8][n & 0xFF]) == 0) {
            return null;
        }
        return new String(byArray, 0, n2 >>> 8, n2 & 0xFF);
    }
}

