/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.lowlevel;

import java.lang.reflect.Field;
import java.util.EnumSet;
import org.gstreamer.lowlevel.IntegerEnum;
import org.gstreamer.lowlevel.annotations.DefaultEnumValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumMapper {
    private static final EnumMapper mapper = new EnumMapper();

    public static EnumMapper getInstance() {
        return mapper;
    }

    public int intValue(Enum<?> value) {
        return value instanceof IntegerEnum ? ((IntegerEnum)((Object)value)).intValue() : value.ordinal();
    }

    public <E extends Enum<E>> E valueOf(int value, Class<E> enumClass) {
        if (IntegerEnum.class.isAssignableFrom(enumClass)) {
            for (Enum e : EnumSet.allOf(enumClass)) {
                if (((IntegerEnum)((Object)e)).intValue() != value) continue;
                return (E)e;
            }
        } else {
            for (Enum e : EnumSet.allOf(enumClass)) {
                if (e.ordinal() != value) continue;
                return (E)e;
            }
        }
        try {
            for (Field f : enumClass.getDeclaredFields()) {
                if (f.getAnnotation(DefaultEnumValue.class) == null) continue;
                return Enum.valueOf(enumClass, f.getName());
            }
            throw new IllegalArgumentException();
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("No known Enum mapping for " + enumClass.getName() + " value=" + value);
        }
    }
}

