
		device	ZXSPECTRUM128	

		include	ts-ports.asm
	

		org	#C000
;----------------------------------------------------------------------------
begin		defw	#0000		
;----------------------------------------------------------------------------
		;
start		ld	ix,#8000
		call	fill_up_tmap
		ld	ix,#8000+128
		call	fill_up_tmap

		;--------------------------------------------
		ld	l,low dma_fill
		call	set_ports
		halt
		;--------------------------------------------
		ld	hl,#a020
		ld	(#c000),hl

		ld	a,17
		ld	(dm_dp+1),a

		ld	a,12/2-1
		ld	(dm_ln+1),a

		ld	a,%00011100
		ld	(dm_ctl+1),a

		call	draw_mmf
		;---------------------------------------------
		ld 	l,low graph_init
		call	set_ports
		;---------------------------------------------
		;   = #af
;-----------------------------------------------------------------------------
loop		halt

		ld	a,(#c000)
		add	a,2
		ld	(#c000),a
		ld	b,high T0XOffsL
		out	(c),a

		cpl
		ld	b,high T1XOffsL
		out	(c),a		
		
		ld	b,high GYOffsL
		out	(c),a

		inc	b
		out	(c),a
		
		jr	loop		
;------------------------------------------------------------------------------		
set_ports 		ld	h,#c0
		ld 	c,#AF
.m1  		ld 	b,(hl) 
  		inc 	hl
  		inc 	b
  		jr 	z,dma_stats
  		outi
  		jr 	.m1	
dma_stats 		halt
  		ret
;-----------------------------------------------------------------------------	
draw_mmf		ld	de,mmf_letters
		ld	b,15
drw_lp		ld	a,(de)
		ld	(dm_dl+1),a
		inc	e
		ld	a,(de)
		ld	(dm_dh+1),a
		inc	e
		ld	a,(de)
		ld	(dm_nm+1),a
		inc	e
		exx
		ld	l,low dma_fill
		call	set_ports
		exx
		djnz	drw_lp
		ret				
		;-------- M --------------------
mmf_letters		defw	#0004+256*8*3
		defb	120/2-1

		defw	#100c+256*8*3
		defb	32/2-1

		defw	#2018+256*8*3
		defb	24/2-1
		
		defw	#1024+256*8*3
		defb	32/2-1

		defw	#002c+256*8*3
		defb	120/2-1
		;------- M ---------------------
		defw	#0004+14*4
		defb	120/2-1

		defw	#100c+14*4
		defb	32/2-1

		defw	#2018+14*4
		defb	24/2-1
		
		defw	#1024+14*4
		defb	32/2-1

		defw	#002c+14*4
		defb	120/2-1
		;------- F ---------------------
		defw	#0074+256*8*3
		defb	120/2-1

		defw	#0080+256*8*3
		defb	24/2-1

		defw	#3084+256*8*1
		defb	24/2-1

		defw	#0090+256*8*3
		defb	24/2-1

		defw	#3090+256*8*1
		defb	24/2-1

;-------------------------------------------------------------------------------

dma_fill		defb	high DMASAddrL, 0
		defb	high DMASAddrH, 0
		defb	high DMASAddrX, 15

dm_dl		defb	high DMADAddrL, 0
dm_dh		defb	high DMADAddrH, 0

dm_dp		defb	high DMADAddrX, 16
dm_nm		defb	high DMANum,	255
dm_ln		defb	high DMALen,	255
dm_ctl		defb	high DMACtrl,	%00000100
		defb	#ff
	
;-------------------------------------------------------------------------------

graph_init		defb	high VConfig, 	%11000001
		defb	high SysConfig,	%00000110
		defb	high PalSel, 	%11111111

		defb	high VPage, 	16
		defb	high T0GPage, 	16
		defb	high T1GPage, 	16

		defb	high TMPage, 	0
		defb	high TSConfig, 	%01101100

		defb	high GXOffsL, 	#f0
		defb	high GXOffsH, 	#ff

		defb	high T0YOffsL, 	0
		defb	high T0YOffsH, 	0

		defb	high T1YOffsL, 	1
		defb	high T1YOffsH, 	0

		defb	#ff
;------------------------------------------------------------------------------------
fill_up_tmap		ld	bc,Page2
		xor	a
		out	(c),a		
		ld	h,a	; hl=0 start t_num
		ld	l,a	;
		ld	de,64
		ld	c,e	;64
fill_y1		push	ix
		ld	b,e	;64
fill_x1		ld	(ix+0),l
		ld	a,h
		or	%00110000
		ld	h,a
		ld	(ix+1),h
		inc	hl
		inc	ix,ix
		djnz	fill_x1
		pop	ix
		inc	ixh
		dec	c
		jr	nz,fill_y1
		ret
;--------------------------------------------------------------------------------------
endcode				
		SAVEBIN "1-spg\mmf256b.bin",begin, endcode-begin


