''
''
'' fmod -- header translated with help of SWIG FB wrapper
''
'' NOTICE: This file is part of the FreeBASIC Compiler package and can't
''         be included in other distributions without authorization.
''
''
#ifndef __fmod_bi__
#define __fmod_bi__

#inclib "fmod"

#define FMOD_VERSION 3.74f

Type FSOUND_SAMPLE As Any
Type FMUSIC_MODULE As Any

Type FSOUND_OPENCALLBACK As Function (Byval As Zstring Ptr) As Any Ptr
Type FSOUND_CLOSECALLBACK As Sub (Byval As Any Ptr)
Type FSOUND_READCALLBACK As Function (Byval As Any Ptr, Byval As Integer, Byval As Any Ptr) As Integer
Type FSOUND_SEEKCALLBACK As Function (Byval As Any Ptr, Byval As Integer, Byval As Byte) As Integer
Type FSOUND_TELLCALLBACK As Function (Byval As Any Ptr) As Integer
Type FSOUND_ALLOCCALLBACK As Function (Byval As Uinteger) As Any Ptr
Type FSOUND_REALLOCCALLBACK As Function (Byval As Any Ptr, Byval As Uinteger) As Any Ptr
Type FSOUND_FREECALLBACK As Sub (Byval As Any Ptr)
Type FSOUND_DSPCALLBACK As Function (Byval As Any Ptr, Byval As Any Ptr, Byval As Integer, Byval As Any Ptr) As Any Ptr
Type FSOUND_METADATACALLBACK As Function (Byval As Zstring Ptr, Byval As Zstring Ptr, Byval As Any Ptr) As Byte
Type FMUSIC_CALLBACK As Sub (Byval As FMUSIC_MODULE Ptr, Byval As Ubyte)


Enum FSOUND_OUTPUTTYPES
	FSOUND_OUTPUT_NOSOUND
	FSOUND_OUTPUT_WINMM
	FSOUND_OUTPUT_DSOUND
	FSOUND_OUTPUT_A3D
	FSOUND_OUTPUT_OSS
	FSOUND_OUTPUT_ESD
	FSOUND_OUTPUT_ALSA
	FSOUND_OUTPUT_ASIO
	FSOUND_OUTPUT_XBOX
	FSOUND_OUTPUT_PS2
	FSOUND_OUTPUT_MAC
	FSOUND_OUTPUT_GC
	FSOUND_OUTPUT_NOSOUND_NONREALTIME
End Enum

Enum FSOUND_MIXERTYPES
	FSOUND_MIXER_AUTODETECT
	FSOUND_MIXER_BLENDMODE
	FSOUND_MIXER_MMXP5
	FSOUND_MIXER_MMXP6
	FSOUND_MIXER_QUALITY_AUTODETECT
	FSOUND_MIXER_QUALITY_FPU
	FSOUND_MIXER_QUALITY_MMXP5
	FSOUND_MIXER_QUALITY_MMXP6
	FSOUND_MIXER_MONO
	FSOUND_MIXER_QUALITY_MONO
	FSOUND_MIXER_MAX
End Enum

Enum FMUSIC_TYPES
	FMUSIC_TYPE_NONE
	FMUSIC_TYPE_MOD
	FMUSIC_TYPE_S3M
	FMUSIC_TYPE_XM
	FMUSIC_TYPE_IT
	FMUSIC_TYPE_MIDI
	FMUSIC_TYPE_FSB
End Enum

#define FSOUND_DSP_DEFAULTPRIORITY_CLEARUNIT 0
#define FSOUND_DSP_DEFAULTPRIORITY_SFXUNIT 100
#define FSOUND_DSP_DEFAULTPRIORITY_MUSICUNIT 200
#define FSOUND_DSP_DEFAULTPRIORITY_USER 300
#define FSOUND_DSP_DEFAULTPRIORITY_FFTUNIT 900
#define FSOUND_DSP_DEFAULTPRIORITY_CLIPANDCOPYUNIT 1000
#define FSOUND_CAPS_HARDWARE &h1
#define FSOUND_CAPS_EAX2 &h2
#define FSOUND_CAPS_EAX3 &h10
#define FSOUND_LOOP_OFF &h00000001
#define FSOUND_LOOP_NORMAL &h00000002
#define FSOUND_LOOP_BIDI &h00000004
#define FSOUND_8BITS &h00000008
#define FSOUND_16BITS &h00000010
#define FSOUND_MONO &h00000020
#define FSOUND_STEREO &h00000040
#define FSOUND_UNSIGNED &h00000080
#define FSOUND_SIGNED &h00000100
#define FSOUND_DELTA &h00000200
#define FSOUND_IT214 &h00000400
#define FSOUND_IT215 &h00000800
#define FSOUND_HW3D &h00001000
#define FSOUND_2D &h00002000
#define FSOUND_STREAMABLE &h00004000
#define FSOUND_LOADMEMORY &h00008000
#define FSOUND_LOADRAW &h00010000
#define FSOUND_MPEGACCURATE &h00020000
#define FSOUND_FORCEMONO &h00040000
#define FSOUND_HW2D &h00080000
#define FSOUND_ENABLEFX &h00100000
#define FSOUND_MPEGHALFRATE &h00200000
#define FSOUND_IMAADPCM &h00400000
#define FSOUND_VAG &h00800000
#define FSOUND_NONBLOCKING &h01000000
#define FSOUND_GCADPCM &h02000000
#define FSOUND_MULTICHANNEL &h04000000
#define FSOUND_USECORE0 &h08000000
#define FSOUND_USECORE1 &h10000000
#define FSOUND_LOADMEMORYIOP &h20000000
#define FSOUND_IGNORETAGS &h40000000
#define FSOUND_STREAM_NET &h80000000
#define FSOUND_NORMAL (&h00000010 or &h00000100 or &h00000020)

#define FSOUND_CD_PLAYCONTINUOUS 0
#define FSOUND_CD_PLAYONCE 1
#define FSOUND_CD_PLAYLOOPED 2
#define FSOUND_CD_PLAYRANDOM 3
#define FSOUND_FREE -1
#define FSOUND_UNMANAGED -2
#define FSOUND_ALL -3
#define FSOUND_STEREOPAN -1
#define FSOUND_SYSTEMCHANNEL -1000
#define FSOUND_SYSTEMSAMPLE -1000

#define FSOUND_PRESET_OFF              (0,	7.5f,	1.00f, -10000, -10000, 0,   1.00f,  1.00f, 1.0f,  -2602, 0.007f, ( 0.0f,0.0f,0.0f },   200, 0.011f, ( 0.0f,0.0f,0.0f }, 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,   0.0f,   0.0f, &h33f )
#define FSOUND_PRESET_GENERIC          (0,	7.5f,	1.00f, -1000,  -100,   0,   1.49f,  0.83f, 1.0f,  -2602, 0.007f, ( 0.0f,0.0f,0.0f ),   200, 0.011f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_PADDEDCELL       (1,	1.4f,	1.00f, -1000,  -6000,  0,   0.17f,  0.10f, 1.0f,  -1204, 0.001f, ( 0.0f,0.0f,0.0f ),   207, 0.002f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_ROOM 	           (2,	1.9f,	1.00f, -1000,  -454,   0,   0.40f,  0.83f, 1.0f,  -1646, 0.002f, ( 0.0f,0.0f,0.0f ),    53, 0.003f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_BATHROOM 	       (3,	1.4f,	1.00f, -1000,  -1200,  0,   1.49f,  0.54f, 1.0f,   -370, 0.007f, ( 0.0f,0.0f,0.0f ),  1030, 0.011f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f,  60.0f, &h3f )
#define FSOUND_PRESET_LIVINGROOM       (4,	2.5f,	1.00f, -1000,  -6000,  0,   0.50f,  0.10f, 1.0f,  -1376, 0.003f, ( 0.0f,0.0f,0.0f ), -1104, 0.004f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_STONEROOM        (5,	11.6f,	1.00f, -1000,  -300,   0,   2.31f,  0.64f, 1.0f,   -711, 0.012f, ( 0.0f,0.0f,0.0f ),    83, 0.017f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_AUDITORIUM       (6,	21.6f,	1.00f, -1000,  -476,   0,   4.32f,  0.59f, 1.0f,   -789, 0.020f, ( 0.0f,0.0f,0.0f ),  -289, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_CONCERTHALL      (7,	19.6f,	1.00f, -1000,  -500,   0,   3.92f,  0.70f, 1.0f,  -1230, 0.020f, ( 0.0f,0.0f,0.0f ),    -2, 0.029f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_CAVE             (8,	14.6f,	1.00f, -1000,  0,      0,   2.91f,  1.30f, 1.0f,   -602, 0.015f, ( 0.0f,0.0f,0.0f ),  -302, 0.022f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h1f )
#define FSOUND_PRESET_ARENA            (9,	36.2f,	1.00f, -1000,  -698,   0,   7.24f,  0.33f, 1.0f,  -1166, 0.020f, ( 0.0f,0.0f,0.0f ),    16, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_HANGAR           (10,	50.3f,	1.00f, -1000,  -1000,  0,   10.05f, 0.23f, 1.0f,   -602, 0.020f, ( 0.0f,0.0f,0.0f ),   198, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_CARPETTEDHALLWAY (11,	1.9f,	1.00f, -1000,  -4000,  0,   0.30f,  0.10f, 1.0f,  -1831, 0.002f, ( 0.0f,0.0f,0.0f ), -1630, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_HALLWAY          (12,	1.8f,	1.00f, -1000,  -300,   0,   1.49f,  0.59f, 1.0f,  -1219, 0.007f, ( 0.0f,0.0f,0.0f ),   441, 0.011f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_STONECORRIDOR    (13,	13.5f,	1.00f, -1000,  -237,   0,   2.70f,  0.79f, 1.0f,  -1214, 0.013f, ( 0.0f,0.0f,0.0f ),   395, 0.020f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_ALLEY 	       (14,	7.5f,	0.30f, -1000,  -270,   0,   1.49f,  0.86f, 1.0f,  -1204, 0.007f, ( 0.0f,0.0f,0.0f ),    -4, 0.011f, ( 0.0f,0.0f,0.0f ), 0.125f, 0.95f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_FOREST 	       (15,	38.0f,	0.30f, -1000,  -3300,  0,   1.49f,  0.54f, 1.0f,  -2560, 0.162f, ( 0.0f,0.0f,0.0f ),  -229, 0.088f, ( 0.0f,0.0f,0.0f ), 0.125f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  79.0f, 100.0f, &h3f )
#define FSOUND_PRESET_CITY             (16,	7.5f,	0.50f, -1000,  -800,   0,   1.49f,  0.67f, 1.0f,  -2273, 0.007f, ( 0.0f,0.0f,0.0f ), -1691, 0.011f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  50.0f, 100.0f, &h3f )
#define FSOUND_PRESET_MOUNTAINS        (17,	100.0f, 0.27f, -1000,  -2500,  0,   1.49f,  0.21f, 1.0f,  -2780, 0.300f, ( 0.0f,0.0f,0.0f ), -1434, 0.100f, ( 0.0f,0.0f,0.0f ), 0.250f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  27.0f, 100.0f, &h1f )
#define FSOUND_PRESET_QUARRY           (18,	17.5f,	1.00f, -1000,  -1000,  0,   1.49f,  0.83f, 1.0f, -10000, 0.061f, ( 0.0f,0.0f,0.0f ),   500, 0.025f, ( 0.0f,0.0f,0.0f ), 0.125f, 0.70f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_PLAIN            (19,	42.5f,	0.21f, -1000,  -2000,  0,   1.49f,  0.50f, 1.0f,  -2466, 0.179f, ( 0.0f,0.0f,0.0f ), -1926, 0.100f, ( 0.0f,0.0f,0.0f ), 0.250f, 1.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  21.0f, 100.0f, &h3f )
#define FSOUND_PRESET_PARKINGLOT       (20,	8.3f,	1.00f, -1000,  0,      0,   1.65f,  1.50f, 1.0f,  -1363, 0.008f, ( 0.0f,0.0f,0.0f ), -1153, 0.012f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h1f )
#define FSOUND_PRESET_SEWERPIPE        (21,	1.7f,	0.80f, -1000,  -1000,  0,   2.81f,  0.14f, 1.0f,    429, 0.014f, ( 0.0f,0.0f,0.0f ),  1023, 0.021f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 0.000f, -5.0f, 5000.0f, 250.0f, 0.0f,  80.0f,  60.0f, &h3f )
#define FSOUND_PRESET_UNDERWATER       (22,	1.8f,	1.00f, -1000,  -4000,  0,   1.49f,  0.10f, 1.0f,   -449, 0.007f, ( 0.0f,0.0f,0.0f ),  1700, 0.011f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 1.18f, 0.348f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h3f )
#define FSOUND_PRESET_DRUGGED          (23,	1.9f,	0.50f, -1000,  0,      0,   8.39f,  1.39f, 1.0f,  -115,  0.002f, ( 0.0f,0.0f,0.0f ),   985, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 0.25f, 1.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h1f )
#define FSOUND_PRESET_DIZZY            (24,	1.8f,	0.60f, -1000,  -400,   0,   17.23f, 0.56f, 1.0f,  -1713, 0.020f, ( 0.0f,0.0f,0.0f ),  -613, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 1.00f, 0.81f, 0.310f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h1f )
#define FSOUND_PRESET_PSYCHOTIC        (25,	1.0f,	0.50f, -1000,  -151,   0,   7.56f,  0.91f, 1.0f,  -626,  0.020f, ( 0.0f,0.0f,0.0f ),   774, 0.030f, ( 0.0f,0.0f,0.0f ), 0.250f, 0.00f, 4.00f, 1.000f, -5.0f, 5000.0f, 250.0f, 0.0f, 100.0f, 100.0f, &h1f )
#define FSOUND_PRESET_PS2_ROOM         (1,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_STUDIO_A     (2,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_STUDIO_B     (3,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_STUDIO_C     (4,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_HALL         (5,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_SPACE        (6,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_ECHO         (7,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_DELAY        (8,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )
#define FSOUND_PRESET_PS2_PIPE         (9,	0,	    0,         0,  0,      0,   0.0f,   0.0f,  0.0f,     0,  0.000f, ( 0.0f,0.0f,0.0f ),     0, 0.000f, ( 0.0f,0.0f,0.0f ), 0.000f, 0.00f, 0.00f, 0.000f,  0.0f, 0000.0f,   0.0f, 0.0f,   0.0f,   0.0f, &h31f )

Type FSOUND_REVERB_PROPERTIES
	Environment As Uinteger
	EnvSize As Single
	EnvDiffusion As Single
	Room As Integer
	RoomHF As Integer
	RoomLF As Integer
	DecayTime As Single
	DecayHFRatio As Single
	DecayLFRatio As Single
	Reflections As Integer
	ReflectionsDelay As Single
	ReflectionsPan(0 To 3-1) As Single
	Reverb As Integer
	ReverbDelay As Single
	ReverbPan(0 To 3-1) As Single
	EchoTime As Single
	EchoDepth As Single
	ModulationTime As Single
	ModulationDepth As Single
	AirAbsorptionHF As Single
	HFReference As Single
	LFReference As Single
	RoomRolloffFactor As Single
	Diffusion As Single
	Density As Single
	Flags As Uinteger
End Type

#define FSOUND_REVERB_FLAGS_DECAYTIMESCALE &h00000001
#define FSOUND_REVERB_FLAGS_REFLECTIONSSCALE &h00000002
#define FSOUND_REVERB_FLAGS_REFLECTIONSDELAYSCALE &h00000004
#define FSOUND_REVERB_FLAGS_REVERBSCALE &h00000008
#define FSOUND_REVERB_FLAGS_REVERBDELAYSCALE &h00000010
#define FSOUND_REVERB_FLAGS_DECAYHFLIMIT &h00000020
#define FSOUND_REVERB_FLAGS_ECHOTIMESCALE &h00000040
#define FSOUND_REVERB_FLAGS_MODULATIONTIMESCALE &h00000080
#define FSOUND_REVERB_FLAGS_CORE0 &h00000100
#define FSOUND_REVERB_FLAGS_CORE1 &h00000200
#define FSOUND_REVERB_FLAGS_DEFAULT (&h00000001 or &h00000002 or &h00000004 or &h00000008 or &h00000010 or &h00000020 or &h00000100 or &h00000200)


Type FSOUND_REVERB_CHANNELPROPERTIES
	Direct As Integer
	DirectHF As Integer
	Room As Integer
	RoomHF As Integer
	Obstruction As Integer
	ObstructionLFRatio As Single
	Occlusion As Integer
	OcclusionLFRatio As Single
	OcclusionRoomRatio As Single
	OcclusionDirectRatio As Single
	Exclusion As Integer
	ExclusionLFRatio As Single
	OutsideVolumeHF As Integer
	DopplerFactor As Single
	RolloffFactor As Single
	RoomRolloffFactor As Single
	AirAbsorptionFactor As Single
	Flags As Integer
End Type

#define FSOUND_REVERB_CHANNELFLAGS_DIRECTHFAUTO &h00000001
#define FSOUND_REVERB_CHANNELFLAGS_ROOMAUTO &h00000002
#define FSOUND_REVERB_CHANNELFLAGS_ROOMHFAUTO &h00000004
#define FSOUND_REVERB_CHANNELFLAGS_DEFAULT (&h00000001 or &h00000002 or &h00000004)

Enum FSOUND_FX_MODES
	FSOUND_FX_CHORUS
	FSOUND_FX_COMPRESSOR
	FSOUND_FX_DISTORTION
	FSOUND_FX_ECHO
	FSOUND_FX_FLANGER
	FSOUND_FX_GARGLE
	FSOUND_FX_I3DL2REVERB
	FSOUND_FX_PARAMEQ
	FSOUND_FX_WAVES_REVERB
	FSOUND_FX_MAX
End Enum

Enum FSOUND_SPEAKERMODES
	FSOUND_SPEAKERMODE_DOLBYDIGITAL
	FSOUND_SPEAKERMODE_HEADPHONES
	FSOUND_SPEAKERMODE_MONO
	FSOUND_SPEAKERMODE_QUAD
	FSOUND_SPEAKERMODE_STEREO
	FSOUND_SPEAKERMODE_SURROUND
	FSOUND_SPEAKERMODE_DTS
	FSOUND_SPEAKERMODE_PROLOGIC2
	FSOUND_SPEAKERMODE_PROLOGIC2_INTERIOR
End Enum

#define FSOUND_INIT_USEDEFAULTMIDISYNTH &h0001
#define FSOUND_INIT_GLOBALFOCUS &h0002
#define FSOUND_INIT_ENABLESYSTEMCHANNELFX &h0004
#define FSOUND_INIT_ACCURATEVULEVELS &h0008
#define FSOUND_INIT_PS2_DISABLECORE0REVERB &h0010
#define FSOUND_INIT_PS2_DISABLECORE1REVERB &h0020
#define FSOUND_INIT_PS2_SWAPDMACORES &h0040
#define FSOUND_INIT_DONTLATENCYADJUST &h0080
#define FSOUND_INIT_GC_INITLIBS &h0100
#define FSOUND_INIT_STREAM_FROM_MAIN_THREAD &h0200
#define FSOUND_INIT_PS2_USEVOLUMERAMPING &h0400
#define FSOUND_INIT_DSOUND_DEFERRED &h0800
#define FSOUND_INIT_DSOUND_HRTF_LIGHT &h1000
#define FSOUND_INIT_DSOUND_HRTF_FULL &h2000

Enum FSOUND_STREAM_NET_STATUS
	FSOUND_STREAM_NET_NOTCONNECTED = 0
	FSOUND_STREAM_NET_CONNECTING
	FSOUND_STREAM_NET_BUFFERING
	FSOUND_STREAM_NET_READY
	FSOUND_STREAM_NET_ERROR
End Enum

Enum FSOUND_TAGFIELD_TYPE
	FSOUND_TAGFIELD_VORBISCOMMENT = 0
	FSOUND_TAGFIELD_ID3V1
	FSOUND_TAGFIELD_ID3V2
	FSOUND_TAGFIELD_SHOUTCAST
	FSOUND_TAGFIELD_ICECAST
	FSOUND_TAGFIELD_ASF
End Enum

#define FSOUND_PROTOCOL_SHOUTCAST &h00000001
#define FSOUND_PROTOCOL_ICECAST &h00000002
#define FSOUND_PROTOCOL_HTTP &h00000004
#define FSOUND_FORMAT_MPEG &h00010000
#define FSOUND_FORMAT_OGGVORBIS &h00020000

Type FSOUND_TOC_TAG
	Name(0 To 4-1) As Byte
	numtracks As Integer
	'min(0 to 100-1) as integer
	sec(0 To 100-1) As Integer
	frame(0 To 100-1) As Integer
End Type

Declare Function FSOUND_SetOutput Alias "FSOUND_SetOutput" (Byval outputtype As Integer) As Byte
Declare Function FSOUND_SetDriver Alias "FSOUND_SetDriver" (Byval driver As Integer) As Byte
Declare Function FSOUND_SetMixer Alias "FSOUND_SetMixer" (Byval mixer As Integer) As Byte
Declare Function FSOUND_SetBufferSize Alias "FSOUND_SetBufferSize" (Byval len_ms As Integer) As Byte
Declare Function FSOUND_SetHWND Alias "FSOUND_SetHWND" (Byval hwnd As Any Ptr) As Byte
Declare Function FSOUND_SetMinHardwareChannels Alias "FSOUND_SetMinHardwareChannels" (Byval min As Integer) As Byte
Declare Function FSOUND_SetMaxHardwareChannels Alias "FSOUND_SetMaxHardwareChannels" (Byval max As Integer) As Byte
Declare Function FSOUND_SetMemorySystem Alias "FSOUND_SetMemorySystem" (Byval pool As Any Ptr, Byval poollen As Integer, Byval useralloc As FSOUND_ALLOCCALLBACK, Byval userrealloc As FSOUND_REALLOCCALLBACK, Byval userfree As FSOUND_FREECALLBACK) As Byte
Declare Function FSOUND_Init Alias "FSOUND_Init" (Byval mixrate As Integer, Byval maxsoftwarechannels As Integer, Byval flags As Uinteger) As Byte
Declare Sub FSOUND_Close Alias "FSOUND_Close" ()
Declare Sub FSOUND_Update Alias "FSOUND_Update" ()
Declare Sub FSOUND_SetSpeakerMode Alias "FSOUND_SetSpeakerMode" (Byval speakermode As Uinteger)
Declare Sub FSOUND_SetSFXMasterVolume Alias "FSOUND_SetSFXMasterVolume" (Byval volume As Integer)
Declare Sub FSOUND_SetPanSeperation Alias "FSOUND_SetPanSeperation" (Byval pansep As Single)
Declare Sub FSOUND_File_SetCallbacks Alias "FSOUND_File_SetCallbacks" (Byval useropen As FSOUND_OPENCALLBACK, Byval userclose As FSOUND_CLOSECALLBACK, Byval userread As FSOUND_READCALLBACK, Byval userseek As FSOUND_SEEKCALLBACK, Byval usertell As FSOUND_TELLCALLBACK)
Declare Function FSOUND_GetError Alias "FSOUND_GetError" () As Integer
Declare Function FSOUND_GetVersion Alias "FSOUND_GetVersion" () As Single
Declare Function FSOUND_GetOutput Alias "FSOUND_GetOutput" () As Integer
Declare Function FSOUND_GetOutputHandle Alias "FSOUND_GetOutputHandle" () As Any Ptr
Declare Function FSOUND_GetDriver Alias "FSOUND_GetDriver" () As Integer
Declare Function FSOUND_GetMixer Alias "FSOUND_GetMixer" () As Integer
Declare Function FSOUND_GetNumDrivers Alias "FSOUND_GetNumDrivers" () As Integer
Declare Function FSOUND_GetDriverName Alias "FSOUND_GetDriverName" (Byval id As Integer) As Zstring Ptr
Declare Function FSOUND_GetDriverCaps Alias "FSOUND_GetDriverCaps" (Byval id As Integer, Byval caps As Uinteger Ptr) As Byte
Declare Function FSOUND_GetOutputRate Alias "FSOUND_GetOutputRate" () As Integer
Declare Function FSOUND_GetMaxChannels Alias "FSOUND_GetMaxChannels" () As Integer
Declare Function FSOUND_GetMaxSamples Alias "FSOUND_GetMaxSamples" () As Integer
Declare Function FSOUND_GetSFXMasterVolume Alias "FSOUND_GetSFXMasterVolume" () As Integer
Declare Function FSOUND_GetNumHWChannels Alias "FSOUND_GetNumHWChannels" (Byval num2d As Integer Ptr, Byval num3d As Integer Ptr, Byval total As Integer Ptr) As Byte
Declare Function FSOUND_GetChannelsPlaying Alias "FSOUND_GetChannelsPlaying" () As Integer
Declare Function FSOUND_GetCPUUsage Alias "FSOUND_GetCPUUsage" () As Single
Declare Sub FSOUND_GetMemoryStats Alias "FSOUND_GetMemoryStats" (Byval currentalloced As Uinteger Ptr, Byval maxalloced As Uinteger Ptr)
Declare Function FSOUND_Sample_Load Alias "FSOUND_Sample_Load" (Byval index As Integer, Byval name_or_data As Zstring Ptr, Byval mode As Uinteger, Byval offset As Integer, Byval length As Integer) As FSOUND_SAMPLE Ptr
Declare Function FSOUND_Sample_Alloc Alias "FSOUND_Sample_Alloc" (Byval index As Integer, Byval length As Integer, Byval mode As Uinteger, Byval deffreq As Integer, Byval defvol As Integer, Byval defpan As Integer, Byval defpri As Integer) As FSOUND_SAMPLE Ptr
Declare Sub FSOUND_Sample_Free Alias "FSOUND_Sample_Free" (Byval sptr As FSOUND_SAMPLE Ptr)
Declare Function FSOUND_Sample_Upload Alias "FSOUND_Sample_Upload" (Byval sptr As FSOUND_SAMPLE Ptr, Byval srcdata As Any Ptr, Byval mode As Uinteger) As Byte
Declare Function FSOUND_Sample_Lock Alias "FSOUND_Sample_Lock" (Byval sptr As FSOUND_SAMPLE Ptr, Byval offset As Integer, Byval length As Integer, Byval ptr1 As Any Ptr Ptr, Byval ptr2 As Any Ptr Ptr, Byval len1 As Uinteger Ptr, Byval len2 As Uinteger Ptr) As Byte
Declare Function FSOUND_Sample_Unlock Alias "FSOUND_Sample_Unlock" (Byval sptr As FSOUND_SAMPLE Ptr, Byval ptr1 As Any Ptr, Byval ptr2 As Any Ptr, Byval len1 As Uinteger, Byval len2 As Uinteger) As Byte
Declare Function FSOUND_Sample_SetMode Alias "FSOUND_Sample_SetMode" (Byval sptr As FSOUND_SAMPLE Ptr, Byval mode As Uinteger) As Byte
Declare Function FSOUND_Sample_SetLoopPoints Alias "FSOUND_Sample_SetLoopPoints" (Byval sptr As FSOUND_SAMPLE Ptr, Byval loopstart As Integer, Byval loopend As Integer) As Byte
Declare Function FSOUND_Sample_SetDefaults Alias "FSOUND_Sample_SetDefaults" (Byval sptr As FSOUND_SAMPLE Ptr, Byval deffreq As Integer, Byval defvol As Integer, Byval defpan As Integer, Byval defpri As Integer) As Byte
Declare Function FSOUND_Sample_SetDefaultsEx Alias "FSOUND_Sample_SetDefaultsEx" (Byval sptr As FSOUND_SAMPLE Ptr, Byval deffreq As Integer, Byval defvol As Integer, Byval defpan As Integer, Byval defpri As Integer, Byval varfreq As Integer, Byval varvol As Integer, Byval varpan As Integer) As Byte
Declare Function FSOUND_Sample_SetMinMaxDistance Alias "FSOUND_Sample_SetMinMaxDistance" (Byval sptr As FSOUND_SAMPLE Ptr, Byval min As Single, Byval max As Single) As Byte
Declare Function FSOUND_Sample_SetMaxPlaybacks Alias "FSOUND_Sample_SetMaxPlaybacks" (Byval sptr As FSOUND_SAMPLE Ptr, Byval max As Integer) As Byte
Declare Function FSOUND_Sample_Get Alias "FSOUND_Sample_Get" (Byval sampno As Integer) As FSOUND_SAMPLE Ptr
Declare Function FSOUND_Sample_GetName Alias "FSOUND_Sample_GetName" (Byval sptr As FSOUND_SAMPLE Ptr) As Zstring Ptr
Declare Function FSOUND_Sample_GetLength Alias "FSOUND_Sample_GetLength" (Byval sptr As FSOUND_SAMPLE Ptr) As Uinteger
Declare Function FSOUND_Sample_GetLoopPoints Alias "FSOUND_Sample_GetLoopPoints" (Byval sptr As FSOUND_SAMPLE Ptr, Byval loopstart As Integer Ptr, Byval loopend As Integer Ptr) As Byte
Declare Function FSOUND_Sample_GetDefaults Alias "FSOUND_Sample_GetDefaults" (Byval sptr As FSOUND_SAMPLE Ptr, Byval deffreq As Integer Ptr, Byval defvol As Integer Ptr, Byval defpan As Integer Ptr, Byval defpri As Integer Ptr) As Byte
Declare Function FSOUND_Sample_GetDefaultsEx Alias "FSOUND_Sample_GetDefaultsEx" (Byval sptr As FSOUND_SAMPLE Ptr, Byval deffreq As Integer Ptr, Byval defvol As Integer Ptr, Byval defpan As Integer Ptr, Byval defpri As Integer Ptr, Byval varfreq As Integer Ptr, Byval varvol As Integer Ptr, Byval varpan As Integer Ptr) As Byte
Declare Function FSOUND_Sample_GetMode Alias "FSOUND_Sample_GetMode" (Byval sptr As FSOUND_SAMPLE Ptr) As Uinteger
Declare Function FSOUND_Sample_GetMinMaxDistance Alias "FSOUND_Sample_GetMinMaxDistance" (Byval sptr As FSOUND_SAMPLE Ptr, Byval min As Single Ptr, Byval max As Single Ptr) As Byte
Declare Function FSOUND_PlaySound Alias "FSOUND_PlaySound" (Byval channel As Integer, Byval sptr As FSOUND_SAMPLE Ptr) As Integer
Declare Function FSOUND_StopSound Alias "FSOUND_StopSound" (Byval channel As Integer) As Byte
Declare Function FSOUND_SetFrequency Alias "FSOUND_SetFrequency" (Byval channel As Integer, Byval freq As Integer) As Byte
Declare Function FSOUND_SetVolume Alias "FSOUND_SetVolume" (Byval channel As Integer, Byval vol As Integer) As Byte
Declare Function FSOUND_SetVolumeAbsolute Alias "FSOUND_SetVolumeAbsolute" (Byval channel As Integer, Byval vol As Integer) As Byte
Declare Function FSOUND_SetPan Alias "FSOUND_SetPan" (Byval channel As Integer, Byval pan As Integer) As Byte
Declare Function FSOUND_SetSurround Alias "FSOUND_SetSurround" (Byval channel As Integer, Byval surround As Byte) As Byte
Declare Function FSOUND_SetMute Alias "FSOUND_SetMute" (Byval channel As Integer, Byval mute As Byte) As Byte
Declare Function FSOUND_SetPriority Alias "FSOUND_SetPriority" (Byval channel As Integer, Byval priority As Integer) As Byte
Declare Function FSOUND_SetReserved Alias "FSOUND_SetReserved" (Byval channel As Integer, Byval reserved As Byte) As Byte
Declare Function FSOUND_SetPaused Alias "FSOUND_SetPaused" (Byval channel As Integer, Byval paused As Byte) As Byte
Declare Function FSOUND_SetLoopMode Alias "FSOUND_SetLoopMode" (Byval channel As Integer, Byval loopmode As Uinteger) As Byte
Declare Function FSOUND_SetCurrentPosition Alias "FSOUND_SetCurrentPosition" (Byval channel As Integer, Byval offset As Uinteger) As Byte
Declare Function FSOUND_3D_SetAttributes Alias "FSOUND_3D_SetAttributes" (Byval channel As Integer, Byval Pos As Single Ptr, Byval vel As Single Ptr) As Byte
Declare Function FSOUND_3D_SetMinMaxDistance Alias "FSOUND_3D_SetMinMaxDistance" (Byval channel As Integer, Byval min As Single, Byval max As Single) As Byte
Declare Function FSOUND_IsPlaying Alias "FSOUND_IsPlaying" (Byval channel As Integer) As Byte
Declare Function FSOUND_GetFrequency Alias "FSOUND_GetFrequency" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetVolume Alias "FSOUND_GetVolume" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetAmplitude Alias "FSOUND_GetAmplitude" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetPan Alias "FSOUND_GetPan" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetSurround Alias "FSOUND_GetSurround" (Byval channel As Integer) As Byte
Declare Function FSOUND_GetMute Alias "FSOUND_GetMute" (Byval channel As Integer) As Byte
Declare Function FSOUND_GetPriority Alias "FSOUND_GetPriority" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetReserved Alias "FSOUND_GetReserved" (Byval channel As Integer) As Byte
Declare Function FSOUND_GetPaused Alias "FSOUND_GetPaused" (Byval channel As Integer) As Byte
Declare Function FSOUND_GetLoopMode Alias "FSOUND_GetLoopMode" (Byval channel As Integer) As Uinteger
Declare Function FSOUND_GetCurrentPosition Alias "FSOUND_GetCurrentPosition" (Byval channel As Integer) As Uinteger
Declare Function FSOUND_GetCurrentSample Alias "FSOUND_GetCurrentSample" (Byval channel As Integer) As FSOUND_SAMPLE Ptr
Declare Function FSOUND_GetCurrentLevels Alias "FSOUND_GetCurrentLevels" (Byval channel As Integer, l As Single Ptr, r As Single Ptr) As Byte
Declare Function FSOUND_GetNumSubChannels Alias "FSOUND_GetNumSubChannels" (Byval channel As Integer) As Integer
Declare Function FSOUND_GetSubChannel Alias "FSOUND_GetSubChannel" (Byval channel As Integer, Byval subchannel As Integer) As Integer
Declare Function FMUSIC_LoadSong Alias "FMUSIC_LoadSong" (Byval Name As Zstring Ptr) As FMUSIC_MODULE Ptr
Declare Function FMUSIC_LoadSongEx Alias "FMUSIC_LoadSongEx" (Byval name_or_data As Zstring Ptr, Byval offset As Integer, Byval length As Integer, Byval mode As Uinteger, Byval samplelist As Integer Ptr, Byval samplelistnum As Integer) As FMUSIC_MODULE Ptr
Declare Function FMUSIC_GetOpenState Alias "FMUSIC_GetOpenState" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_FreeSong Alias "FMUSIC_FreeSong" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Function FMUSIC_PlaySong Alias "FMUSIC_PlaySong" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Function FMUSIC_StopSong Alias "FMUSIC_StopSong" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Sub FMUSIC_StopAllSongs Alias "FMUSIC_StopAllSongs" ()
Declare Function FMUSIC_SetZxxCallback Alias "FMUSIC_SetZxxCallback" (Byval mod_ As FMUSIC_MODULE Ptr, Byval callback As FMUSIC_CALLBACK) As Byte
Declare Function FMUSIC_SetRowCallback Alias "FMUSIC_SetRowCallback" (Byval mod_ As FMUSIC_MODULE Ptr, Byval callback As FMUSIC_CALLBACK, Byval rowstep As Integer) As Byte
Declare Function FMUSIC_SetOrderCallback Alias "FMUSIC_SetOrderCallback" (Byval mod_ As FMUSIC_MODULE Ptr, Byval callback As FMUSIC_CALLBACK, Byval orderstep As Integer) As Byte
Declare Function FMUSIC_SetInstCallback Alias "FMUSIC_SetInstCallback" (Byval mod_ As FMUSIC_MODULE Ptr, Byval callback As FMUSIC_CALLBACK, Byval instrument As Integer) As Byte
Declare Function FMUSIC_SetSample Alias "FMUSIC_SetSample" (Byval mod_ As FMUSIC_MODULE Ptr, Byval sampno As Integer, Byval sptr As FSOUND_SAMPLE Ptr) As Byte
Declare Function FMUSIC_SetUserData Alias "FMUSIC_SetUserData" (Byval mod_ As FMUSIC_MODULE Ptr, Byval userdata As Any Ptr) As Byte
Declare Function FMUSIC_OptimizeChannels Alias "FMUSIC_OptimizeChannels" (Byval mod_ As FMUSIC_MODULE Ptr, Byval maxchannels As Integer, Byval minvolume As Integer) As Byte
Declare Function FMUSIC_SetReverb Alias "FMUSIC_SetReverb" (Byval reverb As Byte) As Byte
Declare Function FMUSIC_SetLooping Alias "FMUSIC_SetLooping" (Byval mod_ As FMUSIC_MODULE Ptr, Byval looping As Byte) As Byte
Declare Function FMUSIC_SetOrder Alias "FMUSIC_SetOrder" (Byval mod_ As FMUSIC_MODULE Ptr, Byval order As Integer) As Byte
Declare Function FMUSIC_SetPaused Alias "FMUSIC_SetPaused" (Byval mod_ As FMUSIC_MODULE Ptr, Byval pause As Byte) As Byte
Declare Function FMUSIC_SetMasterVolume Alias "FMUSIC_SetMasterVolume" (Byval mod_ As FMUSIC_MODULE Ptr, Byval volume As Integer) As Byte
Declare Function FMUSIC_SetMasterSpeed Alias "FMUSIC_SetMasterSpeed" (Byval mode As FMUSIC_MODULE Ptr, Byval speed As Single) As Byte
Declare Function FMUSIC_SetPanSeperation Alias "FMUSIC_SetPanSeperation" (Byval mod_ As FMUSIC_MODULE Ptr, Byval pansep As Single) As Byte
Declare Function FMUSIC_GetName Alias "FMUSIC_GetName" (Byval mod_ As FMUSIC_MODULE Ptr) As Zstring Ptr
Declare Function FMUSIC_GetType Alias "FMUSIC_GetType" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetNumOrders Alias "FMUSIC_GetNumOrders" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetNumPatterns Alias "FMUSIC_GetNumPatterns" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetNumInstruments Alias "FMUSIC_GetNumInstruments" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetNumSamples Alias "FMUSIC_GetNumSamples" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetNumChannels Alias "FMUSIC_GetNumChannels" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetSample Alias "FMUSIC_GetSample" (Byval mod_ As FMUSIC_MODULE Ptr, Byval sampno As Integer) As FSOUND_SAMPLE Ptr
Declare Function FMUSIC_GetPatternLength Alias "FMUSIC_GetPatternLength" (Byval mod_ As FMUSIC_MODULE Ptr, Byval orderno As Integer) As Integer
Declare Function FMUSIC_IsFinished Alias "FMUSIC_IsFinished" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Function FMUSIC_IsPlaying Alias "FMUSIC_IsPlaying" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Function FMUSIC_GetMasterVolume Alias "FMUSIC_GetMasterVolume" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetGlobalVolume Alias "FMUSIC_GetGlobalVolume" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetOrder Alias "FMUSIC_GetOrder" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetPattern Alias "FMUSIC_GetPattern" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetSpeed Alias "FMUSIC_GetSpeed" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetBPM Alias "FMUSIC_GetBPM" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetRow Alias "FMUSIC_GetRow" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetPaused Alias "FMUSIC_GetPaused" (Byval mod_ As FMUSIC_MODULE Ptr) As Byte
Declare Function FMUSIC_GetTime Alias "FMUSIC_GetTime" (Byval mod_ As FMUSIC_MODULE Ptr) As Integer
Declare Function FMUSIC_GetRealChannel Alias "FMUSIC_GetRealChannel" (Byval mod_ As FMUSIC_MODULE Ptr, Byval modchannel As Integer) As Integer
Declare Function FMUSIC_GetUserData Alias "FMUSIC_GetUserData" (Byval mod_ As FMUSIC_MODULE Ptr) As Any Ptr

#endif


Dim Shared MusicHandle As Long Ptr

Sub initFMOD()
	If FSOUND_GetVersion < FMOD_VERSION Then
        Exit Sub
    End If
    
	If FSOUND_Init(44100, 64, 0) = False Then
        Exit Sub
    End If
    
End Sub

Sub closeFMOD()
    FMUSIC_FreeSong(MusicHandle)
	FSOUND_Close
End Sub

Sub LoadSong(File As String)
    If MusicHandle Then FMUSIC_FreeSong(MusicHandle)
    If config.MusicVolume = 0 Then Exit Sub
    MusicHandle = FMUSIC_LoadSongEx("gamedata\sfx\" + File,0,0,FSOUND_LOOP_NORMAL,0,0)
    If Musichandle Then
        FMUSIC_PlaySong(MusicHandle)
        'FMUSIC_SetOrder (MusicHandle,0)
        FMUSIC_SetMasterVolume MusicHandle, config.MusicVolume
    End If
End Sub

Function LoadSound(File As String, Looping As Integer = 0) As Long Ptr
    Dim Flag As Integer
    If Looping = 0 Then Flag = FSOUND_LOOP_OFF
    If Looping = 1 Then Flag = FSOUND_LOOP_NORMAL
    If Looping = 2 Then Flag = FSOUND_LOOP_BIDI
    Return FSOUND_Sample_Load (FSound_Free,"gamedata\sfx\" + File,Flag,0,0)
End Function

Sub PlaySound(pntr As Long Ptr, Volume As Integer = -1, Panning As Integer = -1)
    If Panning = -1 Then Panning = 128
    If Panning>255 Then Panning=255
    If Panning<0 Then Panning=0
    If Volume = -1 Then Volume = 255

    Dim chn As Integer
    chn = FSOUND_PlaySound (FSound_Free, pntr)
    FSOUND_SetPan Chn,Panning
    Volume *= (config.SoundVolume / 255)
    FSOUND_SetVolume Chn,Volume
    FSOUND_SetSurround FSOUND_ALL, TRUE
End Sub
