#include "fw_Globals.fxi"		// shared stuff
#include "fw_States.fxi"		// standard fw_Effect states

float gImageAspect;


//-----------------------------------------------------------------------------
// Textures
//-----------------------------------------------------------------------------


Texture2D gGrainTexture;


SamplerState sampler1
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = WRAP;
    AddressV = WRAP;
};


//----------------------------------------------------------------------------
// Vertex input stream.
//----------------------------------------------------------------------------
struct VS_INPUT
{
    float2 position : POSITION0;
};

struct VS_OUTPUT
{
    float4 position : SV_POSITION;
    float2 uv : TEXCOORD1;
    float bodyPos : TEXCOORD2;
};


//-----------------------------------------------------------------------------
// Shaders
//-----------------------------------------------------------------------------

// Motion-blurry time.
float gTime;



VS_OUTPUT
VS(VS_INPUT In)
{
    VS_OUTPUT Out;

    // Compute the world space coordinates.
    float3 positionWorldSpace =
        float3(210.0f*In.position, -20.0);
    positionWorldSpace.x *= 16.0/9.0;
    Out.position = mul(float4(positionWorldSpace, 1.0), ViewProjection);
    Out.uv = 0.5 + 0.5*float2(In.position.x, -In.position.y);
    Out.uv.x += 0.62*gTime;

    // unused
    Out.bodyPos = 0.0;

    return Out;
}


float4 
PS(VS_OUTPUT In) : SV_TARGET0
{
    float4 color = gGrainTexture.Sample(sampler1, In.uv) +
        gGrainTexture.Sample(sampler1, float2(0.6*In.uv.x, 0.5*In.uv.y)) +
        gGrainTexture.Sample(sampler1, float2(0.4*In.uv.x, 0.3*In.uv.y));

    return float4(0.15*color.rgb, 1.0);
}


float4 gHeroParameters;

VS_OUTPUT
heroVS(VS_INPUT In)
{
    VS_OUTPUT Out;

    // Compute the world space coordinates.
    float3 positionWorldSpace =
        float3(5.0*gHeroParameters.w*In.position, 0.0);

    positionWorldSpace.x *= 16.0/9.0;

    if (positionWorldSpace.x < 0.0)
        positionWorldSpace.x -= 1000.0;

    positionWorldSpace += gHeroParameters.xyz;

    Out.bodyPos = In.position.x;

    Out.position = mul(float4(positionWorldSpace, 1.0), ViewProjection);
    Out.uv = 0.5 + 0.5*float2(In.position.x, -In.position.y);
    Out.uv.x += 5.85*gTime;

    return Out;
}


float4 
heroPS(VS_OUTPUT In) : SV_TARGET0
{
    float4 color = gGrainTexture.Sample(sampler1, In.uv);

    if (In.bodyPos < 0.95)
    {
        float t = In.uv.y + -0.15 + 0.3*((In.uv.x + gTime)%1.0);
        if (t < 0.2 || t > 0.8 || ((5.0*In.uv.x)%1.0) < 0.4)
            discard;
    }

    return float4(1.0, 1.0, 1.0, 1.0);
}


technique10 grain
{
    pass P0
    {
//        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
//        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetBlendState(Blending_Add, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(Culling_None);

        SetVertexShader(CompileShader(vs_4_0, VS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, PS()));
    }
}



technique10 hero
{
    pass P0
    {
//        SetBlendState(Blending_None, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
//        SetBlendState(Blending_Alpha, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetBlendState(Blending_Add, /*Blendfactor*/ float4(0.0, 0.0, 0.0, 0.0), /*Sample mask*/ 0xFFFFFFFF);
        SetDepthStencilState(Depth_Enable_No_Write, /*ref value*/ 0);
        SetRasterizerState(Culling_None);

        SetVertexShader(CompileShader(vs_4_0, heroVS()));
        SetGeometryShader(NULL);
        SetPixelShader(CompileShader(ps_4_0, heroPS()));
    }
}


