
#ifdef vertexcompile

layout (location=0) in vec3 a_position;


uniform mat4 world_to_cam;
uniform mat4 cam_to_clip;

uniform float t;

out vec3 texcoord, cam_pos, pos;
out float flash;
void main() {
	texcoord = a_position;
	pos = a_position;
	vec4 cpos = world_to_cam * vec4(a_position*10.0, 1.0);
	cam_pos = cpos.xyz;
	gl_Position = cam_to_clip * cpos;
	
	float tt = t * 1.6;
	flash = mix(
		1.0, 
		1.0 + (1.0-mod(tt, 1.0))*0.4,
		min(1.0, 
			max(0.0, t - 100.0)
		) - min(1.0, max(0.0, t - 120.0)));
}

#endif

#ifdef fragmentcompile

layout (location=0) out vec4 outcol;
layout (location=1) out vec4 outbloom;

in vec3 texcoord, cam_pos, pos;
flat in vec3 normal;
in vec3 col;
in float flash;

uniform vec3 lightdir, lightpos;
uniform mat4 world_to_cam;
uniform mat4 world_to_light_clip;
uniform sampler2DShadow shadowmap;
uniform samplerCube skybox;
uniform float bloom_treshold;
uniform float t;

vec4 project(vec3 pos){
	vec4 projected = world_to_light_clip*vec4(pos,1.0);
	
	projected.xyz = vec3(.5)+projected.xyz*.5;
	projected.xy += fract(1000.0*cos(pos.xz*1000.0))*.00025;
	projected.z -= .001;
	return projected;
}

float shadow_factor(vec3 pos) {
	vec4 projected = project(pos);
	return textureProj(shadowmap, vec4(projected), -.01);
}

float vol_light(vec3 cam_pos,vec3 pos) {
	int steps=20;
	float light=0.;
	float last=0.;
	vec3 rdir = pos-cam_pos;
	float rnd = fract(100.0*cos(40.0*dot(pos, vec3(1,1.1,1.3))));
	for(int i=0;i<=steps;i++){
		float a= (i+rnd) /float(steps+1);
		vec3 new_pos= cam_pos*(1-a)+pos*a;
		float scatter=max(0.,2.7-abs(dot(normalize(cam_pos-pos),normalize(new_pos-lightpos))));
		float step=a-last;
		last=0;
		light+=shadow_factor(new_pos)*step*length(cam_pos-pos)*scatter;
	}
	return light;
}

mat4 cam_to_world = inverse(world_to_cam);

void main() {
	vec3 camerapos = (cam_to_world*vec4(0,0,0,1)).xyz;
	vec3 coord = texcoord / vec3(10.0);

	float scatter = vol_light(camerapos, cam_pos);
	vec3 skycol = texture(skybox, texcoord).rgb;
	skycol = pow(skycol, vec3(2.2));
	skycol *= 1.4;
	skycol -= 0.5;
	skycol = max(vec3(0.0), skycol);
	vec3 hard = pow(max(vec3(0.0), 2.0*(skycol-vec3(0.5))), vec3(4.0));
	hard*=flash;
	
	float Y = vec3(dot(skycol, vec3(0.2125, 0.72, 0.07)));
	float mult = pow(Y-0.1, 2.0) * 1.1 + 0.04;
	skycol *= mult;
	
	vec3 fogc = vec3(.35, 0.1, 0.11) * 0.06;
	float foggy = 1.0 - coord.y;
	skycol = mix(skycol, 
	fogc + hard*3.0*max(0.,dot(normalize(texcoord), -lightdir)), 
	vec3(foggy));
	outcol = vec4(skycol, 1.0);
	outbloom = min(vec4(1.0), max(vec4(.0), (outcol)-vec4(bloom_treshold)));
}

#endif
