#version 330 core
in vec2 UV;
out vec4 color;
uniform sampler2D tex;
uniform float iGlobalTime;
uniform float sigma;
uniform float addconst;
#define NSAMPLES 32

float rand(vec2 co){
    return fract(sin(dot(co.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

void main() {
	color = texture(tex, UV);
	vec4 addcolor = vec4(0.0);

	for (int i = 0; i < NSAMPLES; i++) {
		float r = sigma * rand(vec2(UV + vec2(10.0 * iGlobalTime)));
		float theta = 2 * 3.141 * rand(vec2(2.0 * UV + vec2(iGlobalTime)));
		vec2 dir = vec2(cos(theta), sin(theta));
		addcolor += texture(tex, UV + r * dir);
	} 

	color *= vec4(0.9, 0.8, 0.98, 1.0) + addconst * addcolor;

}
