import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    id: group
    property var itemId
    property string shader: "fx/drawItem"

    property bool flip: true
    property real overlayAlpha: 1.0

    Blit {
        textureRT: "screenBuffer"
    }
    Shader {
        file: group.shader
    }
//    Texture {
//        textureUnit: 0
//        textureRT: "colorBuffer"
//    }

    Texture {
        textureUnit: 0
        textureItem: itemId
//        Text {
//            width: 1280
//            height: 720
//            id: kuppa
//            font.pixelSize: 40
//            layer.enabled: true
//            color: "blue"
//            text:"jorma is here"
//        }
    }


    Texture {
        textureUnit: 1
        textureRT: "screenBuffer"
    }

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: group.flip ? 1.0 : 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: overlayAlpha
        }

        type: "quad"
        depthTest: false
        depthWrite: false
    }


}

