import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    id: group
    property string file
    property string shader: "fx/overlay"

    property real posX: 0.0
    property real posY: 0.0


    property bool flip: true
    property real overlayAlpha: 1.0

    Blit {
        textureRT: "colorBuffer"
    }
    Shader {
        file: group.shader
    }
    Texture {
        textureUnit: 0
        textureRT: "colorBuffer"
    }

    Texture {
        textureUnit: 1
        textureItem: kuvakuva
        Image {
            id: kuvakuva
            visible: false
            source: "../images/"+group.file
        }
    }

    DrawVB {
        ShaderParam {
            paramName: "flip"
            paramValue: group.flip ? 1.0 : 0.0
        }
        ShaderParam {
            paramName: "overlayAlpha"
            paramValue: overlayAlpha
        }
        ShaderParam {
            paramName: "g_posX"
            paramValue: group.posX
        }
        ShaderParam {
            paramName: "g_posY"
            paramValue: group.posY
        }

        type: "quad"
        depthTest: false
        depthWrite: false
    }


}

