import QtQuick 2.3

import AdaptDemoSystem 1.0

Group {
    Blit {
        textureRT: "screenBuffer"
        blitRT: 0
    }
    Blit {
        textureRT: "godRays"
        blitRT: 1
    }

    Texture {
        textureUnit: 0
        textureRT: "screenBuffer"
    }
    Texture {
        textureUnit: 1
        textureRT: "godRays"
    }
    Shader {
        file: "fx/godray"
        ShaderParam {
            paramName: "rayX"
            paramValue: sync("godray.x")
        }
        ShaderParam {
            paramName: "rayY"
            paramValue: sync("godray.y")
        }
//        uniform float lightZ = 2.0;
//        float g_intensity = 1.0;
//        float g_specRounds = 2.0;
//        float g_specWeight = 1.5;
        ShaderParam {
            paramName: "lightZ"
            paramValue: sync("godray.lightZ")+1.0
        }
        ShaderParam {
            paramName: "g_intensity"
            paramValue: sync("godray.intensity")
        }
        ShaderParam {
            paramName: "g_specRounds"
            paramValue: sync("godray.specRounds")
        }
        ShaderParam {
            paramName: "g_specWeight"
            paramValue: sync("godray.specWeight")
        }
        ShaderParam {
            paramName: "g_length"
            paramValue: sync("godray.length")
        }
        ShaderParam {
            paramName: "g_vignette"
            paramValue: sync("vignette")
        }
        ShaderParam {
            paramName: "g_vignRad"
            paramValue: sync("vignRad")
        }
        ShaderParam {
            paramName: "g_preBright"
            paramValue: sync("preBright")
        }
        ShaderParam {
            paramName: "g_postBright"
            paramValue: sync("postBright")
        }
        ShaderParam {
            paramName: "g_exp"
            paramValue: sync("exp")
        }
    }
//    uniform float g_vignRad = 0.70;
//    uniform float g_preBright = 3.50;
//    uniform float g_postBright = 1.50;
//    uniform float g_exp = 2.0;




    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false

    }
}

