import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {

    sceneName: "Skene2"

    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 1.0
        upY: 0.0
        upZ: 0.0
    }

    Shader {
        property string name: "mesh1"
        file: sync(name + ".shader") < 0.5 ? sceneDir+"sm" : sceneDir+"sm2"
    }

    Texture {
        property string name: "mesh1"
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/adapt_logo2_fulla.png"
        }
    }

    DrawMesh {
        property string name: "mesh1"
        file: "mesh/aivob.x"
        Pos { x: 0; y: 0; z: 0 }
        Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0; cx: 0.0; cy: 0.0; cz: 0.0 }
        Sca { x: 1.0; y: 1.0; z: 1.0 }
    }


    //    Texture {
    //        property string name: "mesh1"
    //        textureItem: image
    //        Image {
    //            visible: bSceneEnabled
    //            x: sync(parent.name + "." + "adaptX")*windowWidth/1920.0
    //            y: sync(parent.name + "." + "adaptY")*windowHeight/1080.0
    //            id: image
    //       //     visible: false
    //            width: windowWidth
    //            height: windowHeight
    //            fillMode: Image.PreserveAspectFit
    //            //source: "../../data/PICT8011_.jpg"
    //            //source: "../../data/adapt_koho_2048.png"
    //            source: "../../data/adapt_logo2_fulla.png"
    //        }
    //    }

    //    ImageLayer {
    //        property string name: "image1"
    //        file: "data/adapt_koho_512.png"
    //        shader: sceneDir+"imageLayer"
    //        Pos { x: 0; y: 0; z: 0 }
    //        Sca { x: 1.0 }
    //    }



    Shader {
        property string name: "mesh2"
        file: sceneDir+"plastic"
    }

    DrawMesh {
        property string name: "mesh2"
        file: "mesh/apehead.obj"
    }

    //    DrawMesh {
    //        property string name: "mesh2"
    //        file: "data/apehead.obj"
    //    }

    //    DrawMesh {
    //        property string name: "mesh2"
    //        file: "data/apehead.obj"
    //    }

    //    DrawMesh {
    //        property string name: "mesh2"
    //        file: "data/apehead.obj"
    //    }

    //    DrawMesh {
    //        property string name: "mesh2"
    //        file: "data/apehead.obj"
    //    }

    //    DrawMesh {
    //        property string name: "mesh2"
    //        file: "data/apehead.obj"
    //    }


}
