#version 430



vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}

layout(points) in;
layout(triangle_strip, max_vertices = 8) out;
//layout(line_strip, max_vertices = 15) out;

in vec2 uv[];

out vec2 uvG;
 
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;

uniform float windowWidth = 1280.0;
uniform float windowHeight = 720.0;

layout(binding=0) uniform sampler2D tex;

uniform float g_pikselos = 0.0;

void main(void) {

//    if (gl_in.length()<1) {
//        return;
//    }


    mat4 mvp = projectionMatrix * modelViewMatrix;

    vec4 pos = gl_in[0].gl_Position*1.0;

    pos.z += sin(pos.x*10.4+g_time)*0.1+cos(pos.y*2.2*sin(pos.x*3.4)+g_time)*0.1+2.0;

    pos.xyz *= 32.0*g_pikselos;
    pos.x *= 16.0/9.0;

    vec4 posO = modelViewMatrix*pos;

    float sizeX = 0.95; // /posO.z; // 100.0/windowWidth;
    float sizeY = 0.5; // /posO.z; // 100.0/windowHeight;

    gl_Position = mvp*pos+vec4(-sizeX, -sizeY, 0.0, 0.0);
    uvG = uv[0];
    EmitVertex();

    gl_Position = mvp*pos+vec4(sizeX, -sizeY, 0.0, 0.0);
    uvG = uv[0];
    EmitVertex();

    gl_Position = mvp*pos+vec4(-sizeX, sizeY, 0.0, 0.0);
    uvG = uv[0];
    EmitVertex();

    gl_Position = mvp*pos+vec4(sizeX, sizeY, 0.0, 0.0);
    uvG = uv[0];
    EmitVertex();

    EndPrimitive();

}
