import QtQuick 2.3
import QtGraphicalEffects 1.0

import "../" // to import RocketScene

import AdaptDemoSystem 1.0


RocketScene {

    sceneName: "SkeneAvaruusMato"


    ClearRT {
        cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0
        clearAmount: sync("clear")
    }




    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: -1.0
        upZ: 0.0
    }

    Group {
        property string gn: "meshHand"
        Shader {
            file: sceneDir+"sm"
            ShaderParam {
                paramName: "g_exploWeight"
                paramValue: sync(parent.parent.gn+".exploWeight")
            }
            ShaderParam {
                paramName: "g_alpha"
                paramValue: sync(parent.parent.gn+".alpha")
            }
        }
        TextureImage {
            textureUnit: 0
            file: "bg_3s.png"
        }
        TextureImage {
            textureUnit: 1
            file: "bg_3s.png"
        }
        DrawMesh {
            property string name: "mato"
            file: "mesh/aivob.x"
            //    file: "mesh/skull.obj"
            Pos { x: sync(parent.parent.gn+".x"); y: sync(parent.parent.gn+".y"); z: sync(parent.parent.gn+".z") }
            Rot { d: sync(parent.parent.gn+".rotX"); ax: 1.0; ay: 0.0; az: 0.0; }
            Sca { s: 1+sync(parent.parent.gn+".scale") }
        }
    }

}
