#version 430


layout (location=0) in vec3 vertexPosition;
layout (location=1) in vec3 vertexNormal;
layout (location=2) in vec2 vertexUV;
layout (location=3) in vec3 vertexTangent;
out vec3 normal;
out vec2 uv;
out vec3 tangent;
out vec4 origPos;

uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform float g_time;


vec4 rotateXZ(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.z;
  r.z = sin(a)*p.x + cos(a)*p.z;
  return r;
}

vec3 rotateXZ3(vec3 p, float a) {
  return rotateXZ(vec4(p, 0.0), a).xyz;
}

vec4 rotateXY(vec4 p, float a) {
  vec4 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec3 rotateXY3(vec3 p, float a) {
  vec3 r = p;
  r.x = cos(a)*p.x - sin(a)*p.y;
  r.y = sin(a)*p.x + cos(a)*p.y;
  return r;
}

vec4 rotateYZ(vec4 p, float a) {
  vec4 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}
vec3 rotateYZ3(vec3 p, float a) {
  vec3 r = p;
  r.y = cos(a)*p.y - sin(a)*p.z;
  r.z = sin(a)*p.y + cos(a)*p.z;
  return r;
}



void main() {
  gl_Position = vec4(vertexPosition*1.0, 1.0);

  vec4 posse = gl_Position*5.0;

  origPos = posse*1.0;

 
  float times = g_time*0.1;
  float times2 = g_time*0.02;

  normal = vertexNormal;
  tangent = vertexTangent;
 // gl_Position.xyz += normal*1.0*(1.0+sin(posse.y*0.4+g_time*3.4));


  float makkara = clamp(0.50+1.50*sin(g_time*0.4), 0.0, 1.0);

//  makkara = 0.0;

  float km = 1.10;
  gl_Position = rotateXZ(gl_Position, -g_time*2.20+km*posse.y*sin(times2)+0.0*posse.z);
  gl_Position.xz *= mix(1.0, 0.015, makkara);
  gl_Position.y *= (1.0+makkara*16.0);
  normal = rotateXZ3(normal, -g_time*2.20+km*posse.y*sin(times2)+0.0*posse.z);
  tangent = rotateXZ3(tangent, -g_time*2.20+km*posse.y*sin(times2)+0.0*posse.z);

//  gl_Position.xz *= 1.0+sin(cos(posse.y+g_time*2.0)+g_time*9.2)*0.02;

 // normal = (modelViewMatrix * vec4(normal, 0.0)).xyz;

    vec4 posNR = gl_Position;
/*
   gl_Position = rotateXY(gl_Position, g_time*0.0+0.30*posse.y*(cos(times)))+0.10*rotateYZ(gl_Position, 0.01*posse.y*(cos(times)));
   normal = rotateXY3(normal, g_time*0.0+0.30*posse.y*(cos(times)))+0.10*rotateYZ3(normal, 0.01*posse.y*(cos(times)));
   tangent = rotateXY3(tangent, g_time*0.0+0.30*posse.y*(cos(times)))+0.10*rotateYZ3(tangent, 0.01*posse.y*(cos(times)));
   gl_Position = 2.0*rotateYZ(gl_Position, 0.0030*posse.y*(cos(times)));
*/
   gl_Position = mix(posNR, gl_Position, makkara);


   tangent = (modelViewMatrix * vec4(tangent, 0.0)).xyz;

  // gl_Position.y *= 3.0;
/*
  vec3 lightPos = vec3(10*cos(g_time*2.0), 0.0, -5.0);
  vec3 surfPos = vec3(0.0f, 0.0f, 0.0f);
  vec3 lightDir = lightPos-surfPos;

  float lightDist = sqrt(dot(lightDir, lightDir));

  float normalLen = sqrt(dot(normal, normal));

  float d = dot(lightDir, normal)/(lightDist*normalLen);
  d = clamp(-d, 0.0, 1.0);

  gl_Position.xyz += 2.0*vertexNormal*pow(d,12.0f);
*/

 // gl_Position = projectionMatrix * modelViewMatrix * gl_Position;
 // normal = vertexNormal;
 // tangent = vertexTangent;
  uv = vertexUV;
 // gl_Position.z += 0.9350;
}
