import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneFeedback"

    anchors.fill: parent

    Image {
        visible: bSceneEnabled
         anchors.fill: parent
      //  width: windowWidth
      //  height: windowHeight
        source: "../../images/adapt_logo2_full.png"
    }

    Blit {
        textureRT: "adaptBG"
    }



    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
            Image {
                visible: false
                // width: windowWidth
                //height: windowHeight
                // fillMode: Image.PreserveAspectFit
                id: kuva
                source: "../../images/kivitex1s.png"
            }
    }
    DrawMesh {
        Clear {
            cR: 1.0; cG: 1.00; cB: 1.00
        }

        property string name: "PillarMan"
        //file: "mesh/pillarman.dae"
       // file: "mesh/pillarman.obj"
        Rot { d: -235.0; ax: 0.0; ay: 1.0; az: 0.0; }
        // file: "mesh/pillarmanb.x"
        file: "mesh/aivob.x"
    }

    Blit {
        textureRT: "blitti"
    }

//    RenderTarget {
//        RenderTargetLayer {
//            textureRT: "blitti"
//        }
//    }
//    Texture {
//        textureRT: "blitti"
//        blit: true
//    }

    Texture {
        textureRT: "blitti"
        textureUnit: 0
    }
    Texture {
        textureRT: "adaptBG"
        textureUnit: 1
    }

    Texture {
        textureRT: "prevScreen"
        textureUnit: 2
    }

    Shader {
        file: sceneDir+"blit"
        ShaderParam {
            paramName: "feedback"
            paramValue: sync("feedback")
        }
    }
    DrawVB {
        type: "quad"
    }



    Blit {
        textureRT: "prevScreen"
    }
}
