import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneFlowder"

    ClearRT {
        cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0
    }


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/kivitex1s.png"
        }
    }
    DrawMesh {
        property string name: "PillarMan"
      //  file: "mesh/PillarMan.obj"
        file: "mesh/aivob.x"
    }


    Image {
        opacity: sync("demologo")
        id: demoLogo
        layer.enabled: true
        anchors.fill: parent
        source: "../../images/demologo1.png"
    }

    DrawItem {
        enabled: sync("demologo") > 0.01 ? true : false

        flip: false
        itemId: demoLogo
    }

    DrawOverlayMul {
        overlayAlpha: sync("mulOvl")
        file: "scrolltex4.png"
    }

}
