import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneKarvaOlio"


    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Shader {
        file: sceneDir+"sm"
    }
    Texture {
        textureUnit: 0
        textureItem: kuva
        Image {
            id: kuva
            visible: false
            source: "../../images/kivitex1s.png"
        }
    }

    Repeater {
        model: 10
        DrawMesh {
            property string name: "mesh2"
          //  file: "mesh/apehead.obj"
          //  file: "mesh/uvtest.obj"
            file: "mesh/kolkkus_inf.x"
            Pos {
                x: Math.sin(index*1.2)*6.0
                y: Math.cos(index*1.7123)*3.0
                z: Math.cos(index*2.3+Math.sin(index*0.92))*3.0
            }
            Sca {
//                s: 0.2
                x: 1.0
                y: 1.0
                z: 1.0
            }

          //  file: "mesh/hand1b.x"
          //  file: "mesh/scityfly.x"
        }


    }

    DrawMesh {
        enabled: true
        property string name: "mesh2"
      //  file: "mesh/apehead.obj"
        file: "mesh/uvtest.obj"
      //  file: "mesh/kolkkus_inf.x"
      //  file: "mesh/hand1b.x"
      //  file: "mesh/scityfly.x"
        Pos { x: -5.0 }
    }


}
