import QtQuick 2.3

import "../" // to import RocketScene

import AdaptDemoSystem 1.0



RocketScene {
    sceneName: "SkeneTestRT"


    RenderTarget {
        property string name: "rtPinta1"
        /*
        RenderTargetLayer {
            textureRT: "rtPinta1_0" // name for how to access this texture in Texture item
            layerRT: 0 // 0, 1, 2, ... specifies the layer index (used by pixel shader), if not given here, determined from the order of appearance
            width: windowWidth // width & height can be given here and if not given, default to window size
            height: windowHeight
            format: "f16b"  // supported formats: "8", "f16", "f32"; all of these are four channel formats now (defaults to "f16")
            Clear {
                clearColor: true
                cR: 0.0; cG: 0.0; cB: 0.0;

                clearDepth: true
                cD: 1.0;
            }
        }
        RenderTargetLayer {
            textureRT: "rtPinta1_1" // name for how to access this texture in Texture item
            layerRT: 1 // 0, 1, 2, ... specifies the layer index (used by pixel shader), if not given here, determined from the order of appearance
        }
        */

        RenderTargetLayer {
            textureRT: "rtPinta1_0" // name for how to access this texture in Texture item
            Clear {
                // clear color if cR, cG, cB or cA set here
                cR: 0.0; cG: 0.0; cB: 0.0; cA: 1.0; // 0, 0, 0, 1 is default clear color

                // clear depth if cD set here
                cD: 1.0; // 1.0 is default clear depth
            }
        }
//        RenderTargetLayer {
//            textureRT: "rtPinta1_1" // name for how to access this texture in Texture item
//            //layerRT: 1 // 0, 1, 2, ... specifies the layer index (used by pixel shader), if not given here, determined from the order of appearance
//        }


        Camera {
            property string name: "camera"
            x: 0.0; y: 0.0; z: -10.0;
            lookAtX: 0.0; lookAtY: 0.0; lookAtZ: 0.0;
            upX: 0.0; upY: 1.0; upZ: 0.0
        }
        Shader {
            file: sceneDir+"sm"
            tfVaryings: "posG,normalG,uvG,tangentG"
        }
        Texture {
            textureUnit: 0
            textureItem: kuva
            Image {
                id: kuva
                visible: false
                source: "../../images/kivitex1.png"
            }
        }
        DrawMesh {
            property string name: "mesh2"
            file: "mesh/apehead.obj"
        }
    }




    Camera {
        property string name: "camera"
        x: sync(name + ".x")
        y: sync(name + ".y")
        z: sync(name + ".z")
        lookAtX: sync(name + ".lookAtX")
        lookAtY: sync(name + ".lookAtY")
        lookAtZ: sync(name + ".lookAtZ")
        upX: 0.0
        upY: 1.0
        upZ: 0.0
    }

    Texture {
        textureUnit: 0
        textureRT: "rtPinta1_0"
    }
    Shader {
        file: sceneDir+"blit"
    }
//    DrawMesh {
//        property string name: "mesh2"
//        file: "mesh/plane.x"
//        depthTest: false
//        depthWrite: false
//    }
    DrawVB {
        type: "quad"
        depthTest: false
        depthWrite: false
    }

    Shader {
        file: sceneDir+"ssPart"
    }
    DrawMesh {
        property string name: "mesh2"
        file: "mesh/apehead.obj"
    }

    DrawVB {
        type: "pointGrid"
        gridWidth: windowWidth/4
        gridHeight: windowHeight/4
        depthTest: false
        depthWrite: false
    }

//    Shader {
//        file: sceneDir+"sm"
//    }
//    Texture {
//        textureUnit: 0
//        textureItem: kuva
//        Image {
//            id: kuva
//            visible: false
//            source: "../../images/kivitex1.png"
//        }
//    }
//    DrawMesh {
//        property string name: "mesh2"
//      //  file: "mesh/apehead.obj"
//        file: "mesh/uvtest.obj"
//      //  file: "mesh/kolkkus_inf.x"
//      //  file: "mesh/hand1b.x"
//      //  file: "mesh/scityfly.x"
//    }


    Shader {
        file: sceneDir+"plastic"
    }
    Texture {
        textureUnit: 0
        textureRT: "rtPinta1_0"
    }
    DrawMesh {
        property string name: "cube"
        file: "mesh/cube5000.x"
    }

}
