import QtQuick 2.3

import SystemTime 1.0

import AdaptDemoSystem 1.0


import "Skene1"

Item {
    id: root
    visible: true
    width: 400
    height: 720

    focus: true

    //    MouseArea {
    //        anchors.fill: parent
    //        onClicked: { console.log("klik") }
    //    }

    property real frameTime: 0.0

    Timer {
        interval: 10
        running: true
        repeat: true
        onTriggered: {
            //     rocket.update();
            aikapaika.text = "demo time:"+(rocket.getTime()).toFixed(2)
            var fps = (1000.0/rocket.getFrameTime()).toFixed()
            frameTimeText.text = "FPS:"+fps
        }
    }

    Rocket {
        id: rocket
    }

    function syncRocketRoot(track) {
        var a = rocket.sync(track);
        var b = rocket.syncUpdate;
        return a;
    }

    ////   Test that proves we are able to render mesh stuff also into the edit view!
    ////   TBD to make this work: render with correct edit view aspect ratio, maybe edit view
    ////   to have specific 16:9 area for preview etc
    //    Demo {
    //        Scene {
    //            property string sceneName: "editSkene"
    //            property string sceneDir: "fx/"+sceneName+"/"
    //            Camera {
    //                property string name: "camera"
    //                x: 0.0
    //                y: 0.0
    //                z: -150.0
    //                lookAtX: 0.0
    //                lookAtY: 0.0
    //                lookAtZ: 0.0
    //                upX: 0.0
    //                upY: 1.0
    //                upZ: 0.0
    //            }
    //            Mesh {
    //                property string name: "mesh1"
    //                file: "data/aivob.x"
    //                shader: "fx/Skene2/sm"

    ////                Pos { x: 0; y: 0; z: 0 }
    ////                Rot { d: 0.0; ax: 1.0; ay: 0.0; az: 0.0; cx: 0.0; cy: 0.0; cz: 0.0 }
    ////                Sca { x: 1.0; y: 1.0; z: 1.0 }
    //           }
    //        }
    //    }

    Rectangle {
        anchors.fill: parent
        color: "black"
    }


    Column {
        id: kolumni
        focus: true

        Text {
            id: aikapaika
            text: rocket.getTime()
            color: "white"
        }
        Text {
            id: frameTimeText
            color: "white"
        }

        Item {
            height: 30
        }

    }


    Item {

        anchors.bottom: root.bottom
        anchors.left: root.left
        anchors.right: root.right
        anchors.top: kolumni.bottom

        ListView {
            focus: true
            id: effects

            //   anchors.top: kolumni.bottom

            //   contentY: 200

            //  clip: true
            function getModelHeight(mod) {
                var height = 0;
                if (!mod) {
                    return height;
                }
                for (var i=0; i<mod.length; i++) {
                    // height += mod[i].childs.length*35;
                    height += getModelHeight(mod[i].childs);
                    height += 30;
                }
                return height;
            }

            //        MouseArea {
            //             propagateComposedEvents: true
            //            anchors.fill: parent
            //            onClicked: {
            //                //          console.log("cli!")
            //            }
            //        }

            property real currentContentY: 0

            onContentYChanged: {
                //     console.log("content y is :"+contentY);
                if (contentY != 0) {
                    currentContentY = contentY;
                }
            }

            onModelChanged: {
                contentY = currentContentY;
                //      console.log("model changed!");
            }


            //   width: 300
            //   height: Math.min(effects.getModelHeight(myModel), 1000)
            anchors.fill: parent
            model: myModel
            delegate: Item {
                id: sub
                width: 300
                height: 30+effects.getModelHeight(model.modelData.childs)

                focus: true

                //            MouseArea {
                //                propagateComposedEvents: true
                //                //    anchors.fill: sub
                //                width: sub.width
                //                height: sub.height
                //                onClicked: {
                //                    console.log("clik clik!")
                //                }
                //            }

                Rectangle {
                    //  focus: true
                    anchors.fill: parent
                    anchors.margins: 5
                    color: model.modelData.color
                    Text { text: model.modelData.name + " - " + model.modelData.rocketName + " - " + model.modelData.details }
                    MouseArea {
                   //     propagateComposedEvents: true
                        anchors.fill: parent
                        onPressedChanged: {
                            if (pressed) {
                                console.log("mouse pressed on:"+model.modelData.rocketNameStack)
                                rocket.findTrack(model.modelData.rocketNameStack);
                            }
                        }
                    }
                }

                Component.onCompleted: {
                    subList.height = effects.getModelHeight(model.modelData.childs);
                    subList.model = model.modelData.childs;
                }
                ListView {
                    id: subList
                    y: 20
                    width: 300
                    delegate: Item {
                        height: 30+effects.getModelHeight(model.modelData.childs)
                        width: 300
                        Rectangle {
                            anchors.fill: parent
                            anchors.margins: 2
                            anchors.leftMargin: 20
                            color: "lightblue"
                            Text { text: model.modelData.name + " - " + model.modelData.rocketName + " - " + model.modelData.details }

                            MouseArea {
                             //   propagateComposedEvents: true
                                anchors.fill: parent
                                onPressedChanged: {
                                    if (pressed) {
                                        console.log("mouse pressed on:"+model.modelData.rocketNameStack)
                                        rocket.findTrack(model.modelData.rocketNameStack);
                                    }
                                 //   mouse.accepted = false
                                }
                            }
                        }
                        Component.onCompleted: {
                            subSubList.height = effects.getModelHeight(model.modelData.childs);
                            subSubList.model = model.modelData.childs;
                        }
                        ListView {
                            id: subSubList
                            y: 20
                            width: 300
                            delegate: Item {
                                height: 30
                                width: 300
                                Rectangle {
                                    anchors.fill: parent
                                    anchors.margins: 2
                                    anchors.leftMargin: 40
                                    color: "lightgrey"
                                    Text { text: model.modelData.name + " - " + model.modelData.rocketName + " - " + model.modelData.details }
                                }
                                MouseArea {
                                    anchors.fill: parent
                                    onPressedChanged: {
                                        if (pressed) {
                                            console.log("mouse pressed on:"+model.modelData.rocketNameStack)
                                            rocket.findTrack(model.modelData.rocketNameStack);
                                        }
                                    }
                                }
                            }
                        }

                    }
                }

            }
        }
    }


}
