/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.io;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.gstreamer.Buffer;
import org.gstreamer.ClockTime;
import org.gstreamer.FlowReturn;
import org.gstreamer.Format;
import org.gstreamer.elements.CustomSrc;
import org.gstreamer.io.StreamLock;
import org.gstreamer.lowlevel.GstAPI;

public class ReadableByteChannelSrc
extends CustomSrc {
    private final ReadableByteChannel channel;
    private FileChannel fileChannel;
    private long channelPosition = 0L;
    private StreamLock lock = null;

    public ReadableByteChannelSrc(ReadableByteChannel src, String name) {
        super(ReadableByteChannelSrc.class, name);
        this.channel = src;
        if (this.channel instanceof FileChannel) {
            this.fileChannel = (FileChannel)this.channel;
        }
        this.setFormat(Format.BYTES);
    }

    private void readFully(long offset, long size, Buffer buffer) throws IOException {
        ByteBuffer dstBuffer = buffer.getByteBuffer();
        int total = 0;
        long position = this.fileChannel != null ? offset : this.channelPosition;
        buffer.setOffset(position);
        while (dstBuffer.hasRemaining()) {
            int n = 0;
            n = this.fileChannel != null ? this.fileChannel.read(dstBuffer, position) : this.channel.read(dstBuffer);
            if (n < 0) {
                if (total >= true) break;
                throw new EOFException();
            }
            position += (long)n;
            total += n;
        }
        this.channelPosition = position;
        buffer.setLastOffset(position);
        buffer.setTimestamp(ClockTime.NONE);
    }

    protected FlowReturn srcFillBuffer(long offset, int size, Buffer buffer) {
        try {
            this.readFully(offset, size, buffer);
            return FlowReturn.OK;
        }
        catch (IOException ex) {
            this.signalError();
            return FlowReturn.UNEXPECTED;
        }
    }

    public boolean srcIsSeekable() {
        return this.fileChannel != null;
    }

    protected boolean srcSeek(GstAPI.GstSegmentStruct segment) {
        if (this.fileChannel != null) {
            try {
                this.fileChannel.position(segment.start);
                segment.last_stop = segment.start;
                segment.time = segment.start;
                segment.write();
                return true;
            }
            catch (IOException ex) {
                this.signalError();
                Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, null, ex);
                return false;
            }
        }
        return true;
    }

    protected long srcGetSize() {
        if (this.fileChannel != null) {
            try {
                return this.fileChannel.size();
            }
            catch (IOException ex) {
                this.signalError();
                Logger.getLogger(ReadableByteChannelSrc.class.getName()).log(Level.SEVERE, null, ex);
                return -1L;
            }
        }
        return -1L;
    }

    private void signalError() {
        if (null != this.lock) {
            this.lock.setDone();
        }
    }

    public void setNotifyOnError(StreamLock lock) {
        this.lock = lock;
    }
}

