/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.swing;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.gstreamer.Bus;
import org.gstreamer.Format;
import org.gstreamer.Gst;
import org.gstreamer.GstObject;
import org.gstreamer.Pipeline;
import org.gstreamer.SeekType;
import org.gstreamer.swing.SwingExecutorService;

public class PipelinePositionModel
extends DefaultBoundedRangeModel {
    private static final long serialVersionUID = 6687380442713003174L;
    private static final int UPDATE_INTERVAL = 1000;
    private static final TimeUnit scaleUnit = TimeUnit.SECONDS;
    private static final SwingExecutorService swingExec = new SwingExecutorService();
    private final Pipeline pipeline;
    private boolean updating = false;
    private final AtomicBoolean isSeeking = new AtomicBoolean(false);
    private long seekingPos = -1L;
    private volatile ScheduledFuture<?> updateTask = null;

    public PipelinePositionModel(Pipeline element) {
        this.pipeline = element;
        element.getBus().connect(swingExec.wrap(Bus.SEGMENT_DONE.class, new Bus.SEGMENT_DONE(){

            public void segmentDone(GstObject source, Format format, long position) {
                PipelinePositionModel.this.segmentDone(position);
            }
        }));
    }

    private synchronized void startPoll() {
        Runnable task = new Runnable(){

            public void run() {
                final long position = PipelinePositionModel.this.pipeline.queryPosition(scaleUnit);
                final long duration = PipelinePositionModel.this.pipeline.queryDuration(scaleUnit);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        PipelinePositionModel.this.updatePosition(duration, position);
                    }
                });
            }
        };
        this.updateTask = Gst.getScheduledExecutorService().scheduleAtFixedRate(task, 1000L, 1000L, TimeUnit.MILLISECONDS);
    }

    private synchronized void stopPoll() {
        if (this.updateTask != null) {
            this.updateTask.cancel(true);
            this.updateTask = null;
        }
    }

    public void addChangeListener(ChangeListener l) {
        if (this.listenerList.getListenerCount() == 0) {
            this.startPoll();
        }
        super.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        super.removeChangeListener(l);
        if (this.listenerList.getListenerCount() == 0) {
            this.stopPoll();
        }
    }

    private void updatePosition(long duration, long position) {
        if (this.isSeeking.get() || this.getValueIsAdjusting()) {
            return;
        }
        boolean min = false;
        int max = (int)duration;
        int pos = (int)position;
        this.updating = true;
        super.setRangeProperties(pos, 1, 0, max, false);
        this.updating = false;
    }

    public void setValue(int newValue) {
        long pos;
        super.setValue(newValue);
        if (!this.updating && !this.isSeeking.get() && (pos = TimeUnit.SECONDS.toNanos(this.getValue())) != this.seekingPos) {
            this.seekTo(pos);
        }
    }

    private void segmentSeek(final long position) {
        this.isSeeking.set(true);
        this.seekingPos = position;
        Gst.getExecutor().execute(new Runnable(){

            public void run() {
                long stop = position + TimeUnit.MILLISECONDS.toNanos(50L);
                int flags = 9;
                PipelinePositionModel.this.pipeline.seek(1.0, Format.TIME, flags, SeekType.SET, position, SeekType.SET, stop);
            }
        });
    }

    private void seekTo(final long position) {
        this.isSeeking.set(true);
        this.seekingPos = position;
        Gst.getExecutor().execute(new Runnable(){

            public void run() {
                int flags = 3;
                PipelinePositionModel.this.pipeline.seek(1.0, Format.TIME, flags, SeekType.SET, position, SeekType.NONE, -1L);
                PipelinePositionModel.this.isSeeking.set(false);
            }
        });
    }

    private void segmentDone(final long position) {
        long pos = scaleUnit.toNanos(this.getValue());
        if (pos != this.seekingPos) {
            this.segmentSeek(pos);
        } else {
            Gst.getExecutor().execute(new Runnable(){

                public void run() {
                    PipelinePositionModel.this.pipeline.seek(1.0, Format.TIME, 5, SeekType.SET, position, SeekType.SET, -1L);
                    PipelinePositionModel.this.pipeline.getState(50L, TimeUnit.MILLISECONDS);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            PipelinePositionModel.this.seekFinished();
                        }
                    });
                }
            });
        }
    }

    private void seekFinished() {
        long pos = scaleUnit.toNanos(this.getValue());
        if (pos != this.seekingPos) {
            this.segmentSeek(pos);
        } else {
            this.isSeeking.set(false);
        }
    }
}

