/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteOrder;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.Structure;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class BufferDataSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private BaseSink sink;
    private Listener listener;
    private boolean autoDisposeBuffer = true;

    public BufferDataSink(String name, Listener listener) {
        super(BufferDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        String mask = ByteOrder.nativeOrder() == ByteOrder.LITTLE_ENDIAN ? "red_mask=(int)0xFF00, green_mask=(int)0xFF0000, blue_mask=(int)0xFF000000" : "red_mask=(int)0xFF0000, green_mask=(int)0xFF00, blue_mask=(int)0xFF";
        this.initSink(name, mask);
    }

    public BufferDataSink(String name, String mask, Listener listener) {
        super(BufferDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.initSink(name, mask);
    }

    public BufferDataSink(String name, Pipeline pipeline, Listener listener) {
        super(BufferDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName(name);
        if (element == null) {
            this.sink = null;
            throw new RuntimeException("Element with name " + name + " not found in the pipeline");
        }
        this.sink = (BaseSink)element;
        this.sink.set("signal-handoffs", true);
        this.sink.set("sync", true);
        this.sink.set("preroll-queue-len", 1);
        this.sink.connect(new SinkNewBufferListener());
        this.sink.connect(new SinkNewBufferListener());
    }

    private void initSink(String name, String mask) {
        this.sink = (FakeSink)ElementFactory.make("fakesink", name);
        this.sink.set("signal-handoffs", true);
        this.sink.set("sync", true);
        this.sink.set("preroll-queue-len", 1);
        this.sink.connect(new SinkNewBufferListener());
        this.sink.connect(new SinkNewBufferListener());
        Element conv = ElementFactory.make("ffmpegcolorspace", "ColorConverter");
        Element videofilter = ElementFactory.make("capsfilter", "ColorFilter");
        StringBuilder caps = new StringBuilder("video/x-raw-rgb, bpp=32, depth=24, endianness=(int)4321, ");
        caps.append(mask);
        videofilter.setCaps(new Caps(caps.toString()));
        this.addMany(conv, videofilter, this.sink);
        Element.linkMany(conv, videofilter, this.sink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setAutoDisposeBuffer(boolean autoDispose) {
        this.autoDisposeBuffer = autoDispose;
    }

    public BaseSink getSinkElement() {
        return this.sink;
    }

    class SinkNewBufferListener
    implements BaseSink.HANDOFF,
    BaseSink.PREROLL_HANDOFF {
        SinkNewBufferListener() {
        }

        public void handoff(BaseSink s, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, false);
        }

        public void prerollHandoff(BaseSink s, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, true);
        }

        private void doHandoff(Buffer buffer, Pad pad, boolean isPrerollFrame) {
            Caps caps = buffer.getCaps();
            Structure struct = caps.getStructure(0);
            int width = struct.getInteger("width");
            int height = struct.getInteger("height");
            if (width < 1 || height < 1) {
                return;
            }
            BufferDataSink.this.listener.bufferFrame(width, height, buffer);
            if (BufferDataSink.this.autoDisposeBuffer) {
                buffer.dispose();
            }
        }
    }

    public static interface Listener {
        public void bufferFrame(int var1, int var2, Buffer var3);
    }
}

