/*
 * Decompiled with CFR 0.152.
 */
package org.gstreamer.elements;

import java.nio.ByteBuffer;
import org.gstreamer.Bin;
import org.gstreamer.Buffer;
import org.gstreamer.Caps;
import org.gstreamer.Element;
import org.gstreamer.ElementFactory;
import org.gstreamer.GhostPad;
import org.gstreamer.Pad;
import org.gstreamer.Pipeline;
import org.gstreamer.elements.BaseSink;
import org.gstreamer.elements.FakeSink;
import org.gstreamer.lowlevel.GstBinAPI;
import org.gstreamer.lowlevel.GstNative;

public class ByteDataSink
extends Bin {
    private static final GstBinAPI gst = GstNative.load(GstBinAPI.class);
    private final BaseSink sink;
    private boolean passDirectBuffer = false;
    private Listener listener;

    public ByteDataSink(String name, Listener listener) {
        super(ByteDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        this.sink = (FakeSink)ElementFactory.make("fakesink", name);
        this.sink.set("signal-handoffs", true);
        this.sink.set("sync", true);
        this.sink.set("preroll-queue-len", 1);
        this.sink.connect(new DataHandoffListener());
        this.sink.connect(new DataHandoffListener());
        Element conv = ElementFactory.make("identity", "Data");
        this.addMany(conv, this.sink);
        Element.linkMany(conv, this.sink);
        this.addPad(new GhostPad("sink", conv.getStaticPad("sink")));
    }

    public ByteDataSink(String name, Pipeline pipeline, Listener listener) {
        super(ByteDataSink.initializer(gst.ptr_gst_bin_new(name)));
        this.listener = listener;
        Element element = pipeline.getElementByName(name);
        if (element == null) {
            this.sink = null;
            throw new RuntimeException("Element with name " + name + " not found in the pipeline");
        }
        this.sink = (BaseSink)element;
        this.sink.set("signal-handoffs", true);
        this.sink.set("sync", true);
        this.sink.set("preroll-queue-len", 1);
        this.sink.connect(new DataHandoffListener());
        this.sink.connect(new DataHandoffListener());
    }

    public void removeListener() {
        this.listener = null;
    }

    public void setPassDirectBuffer(boolean passThru) {
        this.passDirectBuffer = passThru;
    }

    public BaseSink getSinkElement() {
        return this.sink;
    }

    class DataHandoffListener
    implements BaseSink.HANDOFF,
    BaseSink.PREROLL_HANDOFF {
        DataHandoffListener() {
        }

        public void handoff(BaseSink s, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, false);
        }

        public void prerollHandoff(BaseSink s, Buffer buffer, Pad pad) {
            this.doHandoff(buffer, pad, true);
        }

        private void doHandoff(Buffer buffer, Pad pad, boolean isPrerollFrame) {
            ByteBuffer data;
            Caps caps = buffer.getCaps();
            int n = buffer.getSize();
            if (n < 1) {
                return;
            }
            if (ByteDataSink.this.passDirectBuffer) {
                data = buffer.getByteBuffer();
            } else {
                data = ByteBuffer.allocate(n);
                data.put(buffer.getByteBuffer()).flip();
            }
            ByteDataSink.this.listener.byteFrame(isPrerollFrame, caps, n, data);
            buffer.dispose();
        }
    }

    public static interface Listener {
        public void byteFrame(boolean var1, Caps var2, int var3, ByteBuffer var4);
    }
}

